/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.registries.pages;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

public class PageNavigationServiceDefault
implements PageNavigationService {
    public static final String LOGICAL_TYPE_NAME = "causeway.viewer.wicket.PageNavigationServiceDefault";
    private static final long serialVersionUID = 1L;
    @Inject
    private PageClassRegistry pageClassRegistry;

    public void navigateTo(PageType pageType) {
        this.navigateTo(pageType, new PageParameters());
    }

    public void navigateTo(PageType pageType, PageParameters parameters) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        RequestCycle.get().setResponsePage(pageClass, parameters);
    }

    public void restartAt(PageType pageType) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        throw new RestartResponseException(pageClass);
    }

    public void interceptAndRestartAt(PageType pageType) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        throw new RestartResponseAtInterceptPageException(pageClass);
    }

    @Configuration
    public static class AutoConfiguration {
        @Bean
        @Named(value="causeway.viewer.wicket.PageNavigationServiceDefault")
        @Order(value=0x3FFFFFFF)
        @Qualifier(value="Default")
        public PageNavigationServiceDefault pageNavigationServiceDefault() {
            return new PageNavigationServiceDefault();
        }
    }
}

