/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyType {
    public static final int STRING_ORD = 1;
    public static final int DECIMAL_ORD = 2;
    public static final int INTEGER_ORD = 3;
    public static final int BOOLEAN_ORD = 4;
    public static final int DATETIME_ORD = 5;
    public static final int URI_ORD = 6;
    public static final int ID_ORD = 7;
    public static final int HTML_ORD = 8;
    private static final Map<String, PropertyType> all = new HashMap<String, PropertyType>();
    public static final PropertyType STRING = PropertyType.register(new PropertyType("string", 1, String.class));
    public static final PropertyType DECIMAL = PropertyType.register(new PropertyType("decimal", 2, BigDecimal.class));
    public static final PropertyType INTEGER = PropertyType.register(new PropertyType("integer", 3, Integer.class));
    public static final PropertyType BOOLEAN = PropertyType.register(new PropertyType("boolean", 4, Boolean.class));
    public static final PropertyType DATETIME = PropertyType.register(new PropertyType("datetime", 5, Calendar.class));
    public static final PropertyType URI = PropertyType.register(new PropertyType("uri", 6, URI.class));
    public static final PropertyType ID = PropertyType.register(new PropertyType("id", 7, String.class));
    public static final PropertyType HTML = PropertyType.register(new PropertyType("html", 8, String.class));
    private final String name;
    private final int ordinal;
    private final Class<?> klass;

    protected PropertyType(String name, int ordinal, Class<?> klass) {
        this.name = name;
        this.ordinal = ordinal;
        this.klass = klass;
    }

    protected static synchronized <T extends PropertyType> T register(T propertyType) {
        String n = propertyType.name();
        int o = propertyType.ordinal();
        for (PropertyType pt : all.values()) {
            if (n.equals(pt.name())) {
                throw new IllegalArgumentException("Name " + n + " already registered for " + pt);
            }
            if (o != pt.ordinal()) continue;
            throw new IllegalArgumentException("Ordinal " + o + " already registered for " + pt);
        }
        all.put(n, propertyType);
        return propertyType;
    }

    public static PropertyType get(String name) {
        return all.get(name);
    }

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public Class<?> klass() {
        return this.klass;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.name + ')';
    }

    public int hashCode() {
        return 31 + this.ordinal;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyType) {
            return this.ordinal == ((PropertyType)obj).ordinal;
        }
        return false;
    }
}

