/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RelationshipDirection {
    SOURCE("source"),
    TARGET("target"),
    EITHER("either");

    private final String value;
    private static final Map<String, RelationshipDirection> all;
    protected static final String INCLUSION_NONE = "none";
    protected static final String INCLUSION_SOURCE = "source";
    protected static final String INCLUSION_TARGET = "target";
    protected static final String INCLUSION_BOTH = "both";

    private RelationshipDirection(String value) {
        this.value = value;
    }

    public static RelationshipDirection get(String value) {
        RelationshipDirection o = all.get(value);
        if (o == null) {
            throw new IllegalArgumentException(value);
        }
        return o;
    }

    public static RelationshipDirection get(String value, RelationshipDirection def) {
        RelationshipDirection o = all.get(value);
        if (o == null) {
            o = def;
        }
        return o;
    }

    public static RelationshipDirection fromInclusion(String value) {
        if (INCLUSION_SOURCE.equals(value)) {
            return SOURCE;
        }
        if (INCLUSION_TARGET.equals(value)) {
            return TARGET;
        }
        if (INCLUSION_BOTH.equals(value)) {
            return EITHER;
        }
        return null;
    }

    public static String toInclusion(RelationshipDirection o) {
        if (o == SOURCE) {
            return INCLUSION_SOURCE;
        }
        if (o == TARGET) {
            return INCLUSION_TARGET;
        }
        if (o == EITHER) {
            return INCLUSION_BOTH;
        }
        return INCLUSION_NONE;
    }

    public String toString() {
        return this.value;
    }

    static {
        all = new HashMap<String, RelationshipDirection>();
        for (RelationshipDirection o : RelationshipDirection.values()) {
            all.put(o.value, o);
        }
    }
}

