/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryEntry;
import org.apache.chemistry.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManager
implements RepositoryService {
    protected static RepositoryManager instance;
    protected List<Runnable> activators = new ArrayList<Runnable>(1);
    protected List<RepositoryService> services = new CopyOnWriteArrayList<RepositoryService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RepositoryManager getInstance() {
        if (instance != null) return instance;
        Class<RepositoryManager> clazz = RepositoryManager.class;
        synchronized (RepositoryManager.class) {
            if (instance != null) return instance;
            instance = new RepositoryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void registerActivator(Runnable activator) {
        this.activators.add(activator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runActivators() {
        if (this.activators.isEmpty()) {
            return;
        }
        RepositoryManager repositoryManager = this;
        synchronized (repositoryManager) {
            for (Runnable activator : this.activators) {
                activator.run();
            }
            this.activators.clear();
        }
    }

    public synchronized void registerService(RepositoryService service) {
        if (service == this) {
            throw new IllegalArgumentException();
        }
        if (this.services.contains(service)) {
            throw new IllegalArgumentException();
        }
        this.services.add(service);
    }

    public synchronized void unregisterService(RepositoryService service) {
        if (!this.services.remove(service)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Repository getDefaultRepository() {
        this.runActivators();
        for (RepositoryService service : this.services) {
            Repository repository = service.getDefaultRepository();
            if (repository == null) continue;
            return repository;
        }
        return null;
    }

    @Override
    public Collection<RepositoryEntry> getRepositories() {
        this.runActivators();
        ArrayList<RepositoryEntry> entries = new ArrayList<RepositoryEntry>(1);
        for (RepositoryService service : this.services) {
            entries.addAll(service.getRepositories());
        }
        return entries;
    }

    @Override
    public Repository getRepository(String repositoryId) {
        this.runActivators();
        for (RepositoryService service : this.services) {
            Repository repository = service.getRepository(repositoryId);
            if (repository == null) continue;
            return repository;
        }
        return null;
    }
}

