/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Folder;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Policy;
import org.apache.chemistry.Property;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Relationship;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Type;
import org.apache.chemistry.atompub.client.APPDocument;
import org.apache.chemistry.atompub.client.APPFolder;
import org.apache.chemistry.atompub.client.APPObjectEntry;
import org.apache.chemistry.impl.base.BaseObject;
import org.apache.commons.httpclient.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APPObject
extends BaseObject {
    protected static final String UNINITIALIZED_STRING = "__UNINITIALIZED__\u0000\u0000\u0000";
    protected static final URI UNINITIALIZED_URI;
    protected APPObjectEntry entry;
    private final Type type;

    public APPObject(APPObjectEntry entry, Type type) {
        this.entry = entry;
        this.type = type;
    }

    protected static APPObject construct(APPObjectEntry entry) {
        Type type = entry.connection.repository.getType(entry.getTypeId());
        switch (entry.getBaseType()) {
            case DOCUMENT: {
                return new APPDocument(entry, type);
            }
            case FOLDER: {
                return new APPFolder(entry, type);
            }
        }
        throw new AssertionError((Object)entry.getBaseType().getId());
    }

    @Override
    public Connection getConnection() {
        return this.entry.connection;
    }

    @Override
    public void move(Folder targetFolder, Folder sourceFolder) {
        this.entry.connection.moveObject(this.entry, targetFolder, sourceFolder);
    }

    @Override
    public void delete() {
        this.entry.connection.deleteObject(this.entry, false);
    }

    @Override
    public void unfile() {
        this.entry.connection.removeObjectFromFolder(this.entry, null);
    }

    @Override
    public ContentStream getContentStream(String contentStreamId) throws IOException {
        ContentStream contentStream = this.entry.getContentStream();
        if (contentStream != APPObjectEntry.REMOTE_CONTENT_STREAM) {
            return contentStream;
        }
        String url = this.entry.getContentHref();
        return url == null ? null : new APPContentStream(url);
    }

    @Override
    public Folder getParent() {
        APPObjectEntry parentEntry;
        if (this.getBaseType() == BaseType.FOLDER) {
            parentEntry = (APPObjectEntry)this.entry.connection.getFolderParent(this, null);
            if (parentEntry == null) {
                return null;
            }
        } else {
            String href = this.entry.getLink("up");
            if (href == null) {
                return null;
            }
            Collection<ObjectEntry> parents = this.entry.connection.getObjectParents(this, null);
            if (parents.isEmpty()) {
                return null;
            }
            parentEntry = (APPObjectEntry)parents.iterator().next();
        }
        return (Folder)((Object)APPObject.construct(parentEntry));
    }

    @Override
    public Collection<Folder> getParents() {
        return Collections.singleton(this.getParent());
    }

    @Override
    public List<Relationship> getRelationships(RelationshipDirection direction, String typeId, boolean includeSubRelationshipTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyPolicy(Policy policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePolicy(Policy policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Policy> getPolicies() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.entry.getId();
    }

    @Override
    public String getTypeId() {
        return this.entry.getTypeId();
    }

    public APPObjectEntry getEntry() {
        return this.entry;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public BaseType getBaseType() {
        return this.type.getBaseType();
    }

    @Override
    public Property getProperty(String id) {
        PropertyDefinition pd = this.getType().getPropertyDefinition(id);
        if (pd == null) {
            throw new IllegalArgumentException(id);
        }
        return this.entry.getProperty(pd);
    }

    @Override
    public Serializable getValue(String id) {
        PropertyDefinition pd = this.getType().getPropertyDefinition(id);
        if (pd == null) {
            throw new IllegalArgumentException(id);
        }
        Serializable value = this.entry.getValue(id);
        if (value == null) {
            value = pd.getDefaultValue();
        }
        return value;
    }

    @Override
    public void save() {
        if (this.entry.isCreation()) {
            this.create();
        } else {
            this.update();
        }
    }

    protected void create() {
        String href = this.entry.getLink("up");
        if (href == null) {
            throw new CMISRuntimeException("Missing up link");
        }
        href = href.replaceAll("/object/([0-9a-f-]{36}$)", "/children/$1");
        this.entry = this.entry.connection.connector.postEntry(href, null, this.entry);
    }

    protected void update() {
        String href = this.entry.getEditLink();
        if (href == null) {
            throw new CMISRuntimeException("Missing edit link");
        }
        Header header = new Header("Content-Type", "application/atom+xml;type=entry");
        this.entry = this.entry.connection.connector.putEntry(href, header, this.entry);
    }

    static {
        try {
            UNINITIALIZED_URI = new URI("http://__UNINITIALIZED__/%00%00%00");
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public class APPContentStream
    implements ContentStream {
        protected final String url;
        protected String mimeType = "__UNINITIALIZED__\u0000\u0000\u0000";
        protected String filename = "__UNINITIALIZED__\u0000\u0000\u0000";
        protected URI uri = UNINITIALIZED_URI;
        protected long length = -1L;

        public APPContentStream(String url) {
            this.url = url;
        }

        public String getMimeType() {
            if (this.mimeType == APPObject.UNINITIALIZED_STRING) {
                this.mimeType = APPObject.this.getString("cmis:contentStreamMimeType");
            }
            return this.mimeType;
        }

        public String getFileName() {
            if (this.filename == APPObject.UNINITIALIZED_STRING) {
                this.filename = APPObject.this.getString("cmis:contentStreamFileName");
            }
            return this.filename;
        }

        public long getLength() {
            if (this.length == -1L) {
                Integer value = APPObject.this.getInteger("cmis:contentStreamLength");
                this.length = value == null ? -1L : value.longValue();
                return this.length;
            }
            return this.length;
        }

        public InputStream getStream() throws IOException {
            ContentStream cs = APPObject.this.entry.connection.connector.getContentStream(this.url, null, null);
            if (this.length == -1L) {
                this.length = cs.getLength();
            }
            return cs.getStream();
        }
    }
}

