/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Tree;
import org.apache.chemistry.atompub.AtomPub;
import org.apache.chemistry.atompub.client.APPConnection;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.APPObjectEntry;
import org.apache.chemistry.atompub.client.stax.AbstractObjectReader;
import org.apache.chemistry.atompub.client.stax.XmlProperty;
import org.apache.chemistry.xml.stax.StaxReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APPObjectEntryReader
extends AbstractObjectReader<APPObjectEntry> {
    @Override
    protected APPObjectEntry createObject(APPContext ctx) {
        APPConnection connection = (APPConnection)ctx.getConnection();
        return new APPObjectEntry(connection, new HashMap<String, XmlProperty>(), null);
    }

    @Override
    protected void setProperty(APPObjectEntry object, XmlProperty p) {
        object.properties.put(p.getId(), p);
    }

    @Override
    protected void setAllowableActions(APPObjectEntry object, Set<QName> allowableActions) {
        object.allowableActions = Collections.unmodifiableSet(allowableActions);
    }

    @Override
    protected void setPathSegment(APPObjectEntry object, String pathSegment) {
        object.pathSegment = pathSegment;
    }

    @Override
    protected void setChildren(APPObjectEntry object, List<Tree<ObjectEntry>> list) {
        object.children = list;
    }

    @Override
    protected void readAtomElement(APPContext ctx, StaxReader reader, APPObjectEntry object) throws XMLStreamException {
        QName name = reader.getName();
        if (AtomPub.ATOM_CONTENT.equals(name)) {
            String href = reader.getAttributeValue("http://www.w3.org/2005/Atom", "src");
            String type = reader.getAttributeValue("http://www.w3.org/2005/Atom", "type");
            object.addContentHref(href, type);
        } else if (AtomPub.ATOM_LINK.equals(name)) {
            String rel = reader.getAttributeValue("http://www.w3.org/2005/Atom", "rel");
            String href = reader.getAttributeValue("http://www.w3.org/2005/Atom", "href");
            String type = reader.getAttributeValue("http://www.w3.org/2005/Atom", "type");
            object.addLink(rel, href, type);
        }
    }
}

