/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.Choice;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.PropertyType;
import org.apache.chemistry.Updatability;
import org.apache.chemistry.atompub.ValueAdapter;
import org.apache.chemistry.xml.stax.ChildrenNavigator;
import org.apache.chemistry.xml.stax.StaxReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APPPropertyDefinition
implements PropertyDefinition {
    public static final Log log = LogFactory.getLog(APPPropertyDefinition.class);
    protected final Map<String, Object> map;
    protected String id;
    protected PropertyType type;
    protected boolean multiValued;
    protected Updatability updatability;
    protected Serializable defaultValue;
    private static final Map<String, ValueAdapter> adapters = new HashMap<String, ValueAdapter>();

    protected APPPropertyDefinition(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLocalName() {
        return (String)this.map.get(CMIS.LOCAL_NAME.getLocalPart());
    }

    @Override
    public URI getLocalNamespace() {
        String uri = (String)this.map.get(CMIS.LOCAL_NAMESPACE.getLocalPart());
        try {
            return uri == null ? null : new URI(uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public String getQueryName() {
        return (String)this.map.get(CMIS.QUERY_NAME.getLocalPart());
    }

    @Override
    public String getDisplayName() {
        return (String)this.map.get(CMIS.DISPLAY_NAME.getLocalPart());
    }

    @Override
    public String getDescription() {
        return (String)this.map.get("description");
    }

    @Override
    public boolean isInherited() {
        Boolean v = (Boolean)this.map.get("inherited");
        return v == null ? false : v;
    }

    @Override
    public PropertyType getType() {
        if (this.type == null) {
            String t = (String)this.map.get("propertyType");
            if (t != null) {
                this.type = PropertyType.get(t);
            }
            if (this.type == null) {
                this.type = PropertyType.STRING;
            }
        }
        return this.type;
    }

    @Override
    public boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public List<Choice> getChoices() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected final boolean getBooleanValue(String name) {
        Boolean v = (Boolean)this.map.get(name);
        return v == null ? false : v;
    }

    @Override
    public boolean isOpenChoice() {
        return this.getBooleanValue("openChoice");
    }

    @Override
    public boolean isRequired() {
        return this.getBooleanValue("required");
    }

    @Override
    public Serializable getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Updatability getUpdatability() {
        if (this.updatability == null) {
            String text = (String)this.map.get(CMIS.UPDATABILITY.getLocalPart());
            this.updatability = Updatability.get(text, Updatability.READ_WRITE);
        }
        return this.updatability;
    }

    @Override
    public boolean isQueryable() {
        return this.getBooleanValue(CMIS.QUERYABLE.getLocalPart());
    }

    @Override
    public boolean isOrderable() {
        return this.getBooleanValue(CMIS.ORDERABLE.getLocalPart());
    }

    @Override
    public int getPrecision() {
        Integer v = (Integer)this.map.get("precision");
        return v != null ? v : 32;
    }

    @Override
    public Integer getMinValue() {
        return (Integer)this.map.get("minValue");
    }

    @Override
    public Integer getMaxValue() {
        return (Integer)this.map.get("maxValue");
    }

    @Override
    public int getMaxLength() {
        Integer v = (Integer)this.map.get("maxLength");
        return v != null ? v : -1;
    }

    @Override
    public URI getSchemaURI() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean validates(Serializable value) {
        return this.validationError(value) == null;
    }

    @Override
    public String validationError(Serializable value) {
        if (this.getUpdatability() == Updatability.READ_ONLY) {
            return "Property is read-only";
        }
        if (value == null) {
            if (this.isRequired()) {
                return "Property is required";
            }
            return null;
        }
        boolean multi = this.isMultiValued();
        if (multi != value.getClass().isArray()) {
            return multi ? "Property is multi-valued" : "Property is single-valued";
        }
        Class<?> klass = this.getType().klass();
        if (klass == null) {
            throw new UnsupportedOperationException(this.getType().toString());
        }
        if (multi) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object v = Array.get(value, i);
                if (v == null) {
                    return "Array value cannot contain null elements";
                }
                if (klass.isInstance(v)) continue;
                return "Array value has type " + v.getClass() + " instead of " + klass.getName();
            }
        } else if (!klass.isInstance(value)) {
            return "Value has type " + value.getClass() + " instead of " + klass.getName();
        }
        return null;
    }

    public static APPPropertyDefinition fromXml(StaxReader reader) throws XMLStreamException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        LinkedList<String> defaultValues = null;
        APPPropertyDefinition pd = new APPPropertyDefinition(map);
        ChildrenNavigator nav = reader.getChildren();
        while (nav.next()) {
            String tag = reader.getLocalName();
            if (tag.equals(CMIS.ID.getLocalPart())) {
                pd.id = reader.getElementText();
                continue;
            }
            if (tag.equals(CMIS.CARDINALITY.getLocalPart())) {
                String text = reader.getElementText();
                pd.multiValued = APPPropertyDefinition.isMultiValued(text);
                continue;
            }
            if (tag.equals(CMIS.DEFAULT_VALUE.getLocalPart())) {
                defaultValues = new LinkedList<String>();
                ChildrenNavigator nav2 = reader.getChildren();
                while (nav2.next()) {
                    String tag2 = reader.getLocalName();
                    if (!tag2.equals(CMIS.VALUE.getLocalPart())) continue;
                    defaultValues.add(reader.getElementText());
                }
                continue;
            }
            if (tag.startsWith("choice")) continue;
            ValueAdapter adapter = adapters.get(tag);
            Object val = adapter == null ? reader.getElementText() : adapter.readValue(reader.getElementText());
            map.put(tag, val);
        }
        if (defaultValues != null) {
            ValueAdapter va = ValueAdapter.getAdapter(pd.getType());
            if (pd.isMultiValued()) {
                Serializable[] ar = va.createArray(defaultValues.size());
                if (pd.getType() == PropertyType.STRING) {
                    pd.defaultValue = defaultValues.toArray(ar);
                } else {
                    int i = 0;
                    for (String s : defaultValues) {
                        ar[i++] = va.readValue(s);
                    }
                    pd.defaultValue = ar;
                }
            } else {
                if (defaultValues.size() != 1) {
                    log.error("Single-valued property " + pd.getId() + " got a defaultValue of size: " + defaultValues.size());
                }
                if (!defaultValues.isEmpty()) {
                    pd.defaultValue = va.readValue((String)defaultValues.get(0));
                }
            }
        }
        return pd;
    }

    protected static boolean isMultiValued(String text) {
        return "multi".equals(text);
    }

    static {
        adapters.put(CMIS.INHERITED.getLocalPart(), ValueAdapter.BOOLEAN);
        adapters.put(CMIS.REQUIRED.getLocalPart(), ValueAdapter.BOOLEAN);
        adapters.put(CMIS.QUERYABLE.getLocalPart(), ValueAdapter.BOOLEAN);
        adapters.put(CMIS.ORDERABLE.getLocalPart(), ValueAdapter.BOOLEAN);
        adapters.put("openChoice", ValueAdapter.BOOLEAN);
        adapters.put("maxLength", ValueAdapter.INTEGER);
    }
}

