/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.Paging;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryInfo;
import org.apache.chemistry.SPI;
import org.apache.chemistry.Type;
import org.apache.chemistry.TypeManager;
import org.apache.chemistry.atompub.URITemplate;
import org.apache.chemistry.atompub.client.APPConnection;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.APPRepositoryService;
import org.apache.chemistry.atompub.client.APPType;
import org.apache.chemistry.atompub.client.Connector;
import org.apache.chemistry.impl.simple.SimpleTypeManager;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APPRepository
implements Repository {
    private static final Log log = LogFactory.getLog(APPRepository.class);
    protected final APPRepositoryService rs;
    protected final Connector typesConnector;
    protected RepositoryInfo info;
    protected String id;
    protected TypeManager typeManager;
    protected final Map<String, String> collections = new HashMap<String, String>();
    protected final Map<String, URITemplate> uriTemplates = new HashMap<String, URITemplate>();

    public APPRepository(APPRepositoryService rs) {
        this(rs, null);
    }

    public APPRepository(APPRepositoryService rs, RepositoryInfo info) {
        this.rs = rs;
        this.typesConnector = new Connector(rs.getDefaultClient(), new APPContext(this));
        this.info = info;
    }

    public void setInfo(RepositoryInfo info) {
        this.info = info;
    }

    public HttpClient getClient(Map<String, Serializable> params) {
        return this.rs.getClient(params);
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.info.getId();
        }
        return this.id;
    }

    @Override
    public String getName() {
        return this.info.getName();
    }

    @Override
    public URI getThinClientURI() {
        return this.info.getThinClientURI();
    }

    @Override
    public SPI getSPI(Map<String, Serializable> params) {
        this.loadTypes();
        return new APPConnection(this, params);
    }

    @Override
    public Connection getConnection(Map<String, Serializable> params) {
        this.loadTypes();
        return new APPConnection(this, params);
    }

    public void addCollection(String type, String href) {
        this.collections.put(type, href);
    }

    public void addURITemplate(URITemplate uriTemplate) {
        this.uriTemplates.put(uriTemplate.type, uriTemplate);
    }

    @Override
    public RepositoryInfo getInfo() {
        return this.info;
    }

    @Override
    public void addType(Type type) {
        throw new UnsupportedOperationException("Cannot add types");
    }

    @Override
    public Type getType(String typeId) {
        this.loadTypes();
        return this.typeManager.getType(typeId);
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String id) {
        this.loadTypes();
        return this.typeManager.getPropertyDefinition(id);
    }

    @Override
    public Collection<Type> getTypes() {
        this.loadTypes();
        return this.typeManager.getTypes();
    }

    @Override
    public Collection<Type> getTypeDescendants(String typeId) {
        this.loadTypes();
        return this.typeManager.getTypeDescendants(typeId);
    }

    @Override
    public ListPage<Type> getTypeChildren(String typeId, boolean includePropertyDefinitions, Paging paging) {
        this.loadTypes();
        return this.typeManager.getTypeChildren(typeId, includePropertyDefinitions, paging);
    }

    @Override
    public Collection<Type> getTypeDescendants(String typeId, int depth, boolean includePropertyDefinitions) {
        this.loadTypes();
        return this.typeManager.getTypeDescendants(typeId, depth, includePropertyDefinitions);
    }

    public String getCollectionHref(String type) {
        return this.collections.get(type);
    }

    public URITemplate getURITemplate(String type) {
        return this.uriTemplates.get(type);
    }

    public void addType(APPType type) {
        this.typeManager.addType(type);
    }

    protected synchronized void loadTypes() {
        if (this.typeManager != null) {
            return;
        }
        try {
            String href = this.getCollectionHref("types");
            if (href == null) {
                throw new IllegalArgumentException("Invalid CMIS repository. No types children collection defined");
            }
            this.typeManager = new SimpleTypeManager();
            Collection<Type> baseTypes = this.readTypes(href).getTypes();
            for (Type type : baseTypes) {
                if (!BaseType.ALL_IDS.contains(type.getId())) continue;
                this.typeManager.addType(type);
                href = ((APPType)type).getLink("down", "application/cmistree+xml");
                if (href == null) {
                    log.error("Type " + type.getId() + " is missing descendants link");
                    continue;
                }
                TypeManager rr = this.readTypes(href);
                Collection<Type> subTypes = rr.getTypes();
                for (Type t : subTypes) {
                    this.typeManager.addType(t);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load repository types for " + this.getName(), e);
        }
    }

    protected TypeManager readTypes(String href) throws Exception {
        href = APPRepository.includePropertyDefinitionsInURI(href);
        return this.typesConnector.getTypeFeed(href, true);
    }

    protected static String includePropertyDefinitionsInURI(String href) {
        if (!href.contains("includePropertyDefinitions")) {
            char sep = href.contains("?") ? (char)'&' : '?';
            href = href + sep + "includePropertyDefinitions" + "=true";
        }
        return href;
    }

    @Override
    public <T> T getExtension(Class<T> clazz) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getName() + ')';
    }
}

