/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.ACLCapabilityType;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.RepositoryCapabilities;
import org.apache.chemistry.RepositoryEntry;
import org.apache.chemistry.RepositoryInfo;
import org.apache.chemistry.impl.simple.SimpleObjectId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APPRepositoryInfo
implements RepositoryInfo {
    public static final Log log = LogFactory.getLog(APPRepositoryInfo.class);
    protected final Map<String, Object> map;
    protected final RepositoryCapabilities caps;
    protected final Set<BaseType> changeLogBaseTypes;

    public APPRepositoryInfo(RepositoryCapabilities caps, Map<String, Object> map, Set<BaseType> changeLogBaseTypes) {
        this.map = map;
        this.caps = caps;
        this.changeLogBaseTypes = changeLogBaseTypes.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(changeLogBaseTypes));
    }

    public String getString(String name) {
        return (String)this.map.get(name);
    }

    public boolean getBoolean(String name) {
        return Boolean.parseBoolean((String)this.map.get(name));
    }

    @Override
    public String getId() {
        return this.getString(CMIS.REPOSITORY_ID.getLocalPart());
    }

    @Override
    public String getName() {
        return this.getString(CMIS.REPOSITORY_NAME.getLocalPart());
    }

    @Override
    public URI getThinClientURI() {
        String uri = this.getString(CMIS.THIN_CLIENT_URI.getLocalPart());
        try {
            return uri == null ? null : new URI(uri);
        }
        catch (URISyntaxException e) {
            log.error("Invalid URI: " + uri, e);
            return null;
        }
    }

    @Override
    public String getDescription() {
        return this.getString(CMIS.REPOSITORY_DESCRIPTION.getLocalPart());
    }

    @Override
    public String getProductName() {
        return this.getString(CMIS.PRODUCT_NAME.getLocalPart());
    }

    @Override
    public String getProductVersion() {
        return this.getString(CMIS.PRODUCT_VERSION.getLocalPart());
    }

    @Override
    public ObjectId getRootFolderId() {
        String id = this.getString(CMIS.ROOT_FOLDER_ID.getLocalPart());
        return new SimpleObjectId(id);
    }

    @Override
    public String getVendorName() {
        return this.getString(CMIS.VENDOR_NAME.getLocalPart());
    }

    @Override
    public String getVersionSupported() {
        return this.getString(CMIS.VERSION_SUPPORTED.getLocalPart());
    }

    @Override
    public Document getRepositorySpecificInformation() {
        return (Document)this.map.get(CMIS.REPOSITORY_SPECIFIC_INFORMATION.getLocalPart());
    }

    @Override
    public RepositoryCapabilities getCapabilities() {
        return this.caps;
    }

    @Override
    public Set<BaseType> getChangeLogBaseTypes() {
        return this.changeLogBaseTypes;
    }

    @Override
    public boolean isChangeLogIncomplete() {
        return this.getBoolean(CMIS.CHANGES_INCOMPLETE.getLocalPart());
    }

    @Override
    public String getLatestChangeLogToken() {
        return this.getString(CMIS.LATEST_CHANGE_LOG_TOKEN.getLocalPart());
    }

    @Override
    public ACLCapabilityType getACLCapabilityType() {
        return null;
    }

    @Override
    public Collection<RepositoryEntry> getRelatedRepositories() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getName() + ')';
    }
}

