/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryEntry;
import org.apache.chemistry.RepositoryService;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.APPRepository;
import org.apache.chemistry.atompub.client.Connector;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APPRepositoryService
implements RepositoryService {
    protected final String url;
    protected final Map<String, Serializable> urlParams;
    protected final List<HttpClient> clients = new ArrayList<HttpClient>(2);
    protected final List<Map<String, Serializable>> clientParams = new ArrayList<Map<String, Serializable>>(2);
    protected List<APPRepository> repos;

    public APPRepositoryService(String url, Map<String, Serializable> params) {
        this.url = url;
        this.urlParams = params;
    }

    @Override
    public Collection<RepositoryEntry> getRepositories() {
        this.loadRepositories();
        ArrayList<RepositoryEntry> res = new ArrayList<RepositoryEntry>(this.repos.size());
        res.addAll(this.repos);
        return res;
    }

    protected void loadRepositories() {
        if (this.repos != null) {
            return;
        }
        Connector connector = new Connector(this.getDefaultClient(), new APPContext(this));
        this.repos = connector.getServiceDocument(this.url);
    }

    @Override
    public Repository getDefaultRepository() {
        this.loadRepositories();
        return this.repos.size() == 0 ? null : this.repos.get(0);
    }

    @Override
    public Repository getRepository(String id) {
        this.loadRepositories();
        for (APPRepository repository : this.repos) {
            if (!repository.getId().equals(id)) continue;
            return repository;
        }
        return null;
    }

    public synchronized HttpClient getClient(Map<String, Serializable> params) {
        int i = 0;
        for (Map<String, Serializable> p : this.clientParams) {
            if (params == null && p == null || params != null && ((Object)params).equals(p)) {
                return this.clients.get(i);
            }
            ++i;
        }
        HttpClient client = this.newClient(params);
        this.clients.add(client);
        this.clientParams.add(params);
        return client;
    }

    protected HttpClient getDefaultClient() {
        return this.getClient(this.urlParams);
    }

    protected HttpClient newClient(Map<String, Serializable> params) {
        HttpClient client = new HttpClient();
        client.setHttpConnectionManager(new MultiThreadedHttpConnectionManager());
        Credentials credentials = this.getCredentials(params);
        if (credentials != null) {
            FixedCredentialsProvider cp = new FixedCredentialsProvider(credentials);
            client.getState().setCredentials(AuthScope.ANY, credentials);
            client.getParams().setParameter("http.authentication.credential-provider", cp);
            client.getParams().setAuthenticationPreemptive(true);
        }
        return client;
    }

    protected Credentials getCredentials(Map<String, Serializable> params) {
        if (params == null) {
            return null;
        }
        String username = (String)((Object)params.get("username"));
        if (username == null) {
            return null;
        }
        String password = (String)((Object)params.get("password"));
        return new UsernamePasswordCredentials(username, password);
    }

    public static class FixedCredentialsProvider
    implements CredentialsProvider {
        protected final Credentials credentials;

        public FixedCredentialsProvider(Credentials credentials) {
            this.credentials = credentials;
        }

        public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) {
            return this.credentials;
        }
    }
}

