/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.stax.EntryReader;
import org.apache.chemistry.xml.stax.ChildrenNavigator;
import org.apache.chemistry.xml.stax.StaxReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllowableActionsReader
implements EntryReader<Set<QName>> {
    private static final String AA_PREFIX = "can";

    @Override
    public Set<QName> read(APPContext ctx, InputStream in) throws XMLStreamException {
        return this.read(ctx, StaxReader.newReader(in));
    }

    @Override
    public Set<QName> read(APPContext ctx, XMLStreamReader reader) throws XMLStreamException {
        return this.read(ctx, StaxReader.newReader(reader));
    }

    @Override
    public Set<QName> read(APPContext ctx, StaxReader reader) throws XMLStreamException {
        if (!reader.getFirstTag(CMIS.ALLOWABLE_ACTIONS)) {
            return null;
        }
        HashSet<QName> set = new HashSet<QName>();
        ChildrenNavigator children = reader.getChildren();
        while (children.next()) {
            boolean bool;
            if (!reader.getNamespaceURI().equals("http://docs.oasis-open.org/ns/cmis/core/200908/") && !reader.getLocalName().startsWith(AA_PREFIX) || !(bool = Boolean.parseBoolean(reader.getElementText()))) continue;
            set.add(reader.getName());
        }
        return set;
    }
}

