/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.ConstraintViolationException;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectNotFoundException;
import org.apache.chemistry.Paging;
import org.apache.chemistry.Tree;
import org.apache.chemistry.TypeManager;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.APPObjectEntry;
import org.apache.chemistry.atompub.client.APPObjectEntryReader;
import org.apache.chemistry.atompub.client.APPObjectEntryWriter;
import org.apache.chemistry.atompub.client.APPObjectFeedReader;
import org.apache.chemistry.atompub.client.APPObjectFeedTreeReader;
import org.apache.chemistry.atompub.client.APPRepository;
import org.apache.chemistry.atompub.client.APPServiceDocumentReader;
import org.apache.chemistry.atompub.client.APPType;
import org.apache.chemistry.atompub.client.AllowableActionsReader;
import org.apache.chemistry.atompub.client.NameValuePairs;
import org.apache.chemistry.atompub.client.TypeEntryReader;
import org.apache.chemistry.atompub.client.TypeFeedReader;
import org.apache.chemistry.atompub.client.stax.EntryReader;
import org.apache.chemistry.atompub.client.stax.FeedReader;
import org.apache.chemistry.atompub.client.stax.QueryWriter;
import org.apache.chemistry.atompub.client.stax.XmlObjectWriter;
import org.apache.chemistry.impl.simple.SimpleContentStream;
import org.apache.chemistry.impl.simple.SimpleTree;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connector {
    protected final HttpClient client;
    protected final APPContext ctx;

    public Connector(HttpClient client, APPContext ctx) {
        this.client = client;
        this.ctx = ctx;
    }

    public List<APPRepository> getServiceDocument(String uri) {
        GetMethod method = new GetMethod(uri);
        try {
            this.client.executeMethod(method);
            int status = method.getStatusCode();
            if (status >= 400) {
                throw new CMISRuntimeException("Remote server returned error code: " + status);
            }
            List<APPRepository> list = new APPServiceDocumentReader().read(this.ctx, method.getResponseBodyAsStream());
            return list;
        }
        catch (IOException e) {
            throw new CMISRuntimeException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public ListPage<ObjectEntry> getEntryFeed(String href, NameValuePairs params) {
        return this.getObjectFeed(href, params, new APPObjectFeedReader());
    }

    public TypeManager getTypeFeed(String href, boolean includePropertyDefinitions) {
        return this.getObjectFeed(href, null, new TypeFeedReader(includePropertyDefinitions));
    }

    protected <T> T getObjectFeed(String href, NameValuePairs params, FeedReader<T> reader) {
        GetMethod method = new GetMethod(href);
        try {
            if (params != null) {
                method.setQueryString(params.toArray());
            }
            this.client.executeMethod(method);
            int status = method.getStatusCode();
            if (status >= 400) {
                throw new CMISRuntimeException("Remote server returned error code: " + status);
            }
            T t = reader.read(this.ctx, method.getResponseBodyAsStream());
            return t;
        }
        catch (IOException e) {
            throw new CMISRuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new CMISRuntimeException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public Tree<ObjectEntry> getEntryFeedTree(String href, NameValuePairs params) {
        List list = this.getObjectFeed(href, params, new APPObjectFeedTreeReader());
        return new SimpleTree<Object>(null, list);
    }

    public APPObjectEntry getEntry(String href, String msg) {
        return this.getObject(href, msg, new APPObjectEntryReader());
    }

    public APPType getType(String href, boolean includePropertyDefinitions, String msg) {
        return this.getObject(href, msg, new TypeEntryReader(includePropertyDefinitions));
    }

    protected <T> T getObject(String href, String msg, EntryReader<T> reader) {
        GetMethod method = new GetMethod(href);
        try {
            this.client.executeMethod(method);
            int status = method.getStatusCode();
            if (status == 404) {
                throw new ObjectNotFoundException(msg);
            }
            if (status == 409) {
                throw new ConstraintViolationException(msg);
            }
            if (status >= 400) {
                throw new CMISRuntimeException("Remote server returned error code: " + status);
            }
            T t = reader.read(this.ctx, method.getResponseBodyAsStream());
            return t;
        }
        catch (IOException e) {
            throw new CMISRuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new CMISRuntimeException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentStream getContentStream(String href, String mimeType, String filename) throws IOException {
        GetMethod method = new GetMethod(href);
        try {
            this.client.executeMethod(method);
            int status = method.getStatusCode();
            if (status == 404 || status == 409) {
                throw new ConstraintViolationException("No content stream");
            }
            if (status >= 400) {
                throw new CMISRuntimeException("Remote server returned error code: " + status);
            }
            InputStream is = method.getResponseBodyAsStream();
            SimpleContentStream simpleContentStream = new SimpleContentStream(is, mimeType, filename);
            return simpleContentStream;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Set<QName> getAllowableActions(String href) {
        return this.getObject(href, "", new AllowableActionsReader());
    }

    public APPObjectEntry putEntry(String href, Header header, APPObjectEntry entry) {
        XmlObjectWriterRequestEntity<APPObjectEntry> requestEntity = new XmlObjectWriterRequestEntity<APPObjectEntry>(new APPObjectEntryWriter(), entry);
        return this.put(href, header, requestEntity);
    }

    public APPObjectEntry putStream(String href, ContentStream cs) throws IOException {
        InputStreamRequestEntity requestEntity = new InputStreamRequestEntity(cs.getStream(), cs.getLength(), cs.getMimeType());
        String filename = cs.getFileName();
        Header header = filename == null ? null : new Header("Slug", filename);
        return this.put(href, header, requestEntity);
    }

    protected APPObjectEntry put(String href, Header header, RequestEntity requestEntity) {
        PutMethod method = new PutMethod(href);
        try {
            if (header != null) {
                method.addRequestHeader(header);
            }
            method.setRequestEntity(requestEntity);
            method.setContentChunked(true);
            this.client.executeMethod(method);
            int status = method.getStatusCode();
            if (status >= 400) {
                throw new CMISRuntimeException("Remote server returned error code: " + status);
            }
            if (requestEntity instanceof InputStreamRequestEntity) {
                APPObjectEntry aPPObjectEntry = null;
                return aPPObjectEntry;
            }
            APPObjectEntry aPPObjectEntry = (APPObjectEntry)new APPObjectEntryReader().read(this.ctx, method.getResponseBodyAsStream());
            return aPPObjectEntry;
        }
        catch (IOException e) {
            throw new CMISRuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new CMISRuntimeException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public APPObjectEntry postEntry(String href, NameValuePairs params, APPObjectEntry entry) {
        PostMethod method = new PostMethod(href);
        try {
            if (params != null) {
                method.setQueryString(params.toArray());
            }
            method.addRequestHeader("Content-Type", "application/atom+xml;type=entry");
            method.setRequestEntity(new XmlObjectWriterRequestEntity<APPObjectEntry>(new APPObjectEntryWriter(), entry));
            method.setContentChunked(true);
            this.client.executeMethod(method);
            int status = method.getStatusCode();
            if (status != 201) {
                throw new CMISRuntimeException("Remote server returned error code: " + status);
            }
            APPObjectEntry newEntry = (APPObjectEntry)new APPObjectEntryReader().read(this.ctx, method.getResponseBodyAsStream());
            Header loc = method.getResponseHeader("Location");
            Header cloc = method.getResponseHeader("Content-Location");
            if (loc == null) {
                throw new CMISRuntimeException("Remote server failed to return a Location header");
            }
            if (!(newEntry != null && loc.equals(cloc) || (newEntry = this.getEntry(loc.getValue(), loc.getValue())) != null)) {
                throw new CMISRuntimeException("Remote server failed to return an entry for Location: " + loc);
            }
            APPObjectEntry aPPObjectEntry = newEntry;
            return aPPObjectEntry;
        }
        catch (IOException e) {
            throw new CMISRuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new CMISRuntimeException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public ListPage<ObjectEntry> postQuery(String href, String statement, boolean searchAllVersions, Inclusion inclusion, Paging paging) {
        PostMethod method = new PostMethod(href);
        try {
            method.setRequestEntity(new XmlObjectWriterRequestEntity<String>(new QueryWriter(searchAllVersions, inclusion, paging), statement));
            method.setContentChunked(true);
            this.client.executeMethod(method);
            int status = method.getStatusCode();
            if (status >= 400) {
                throw new CMISRuntimeException("Remote server returned error code: " + status);
            }
            ListPage listPage = (ListPage)new APPObjectFeedReader().read(this.ctx, method.getResponseBodyAsStream());
            return listPage;
        }
        catch (IOException e) {
            throw new CMISRuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new CMISRuntimeException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void delete(String href, NameValuePairs params, String msg) {
        DeleteMethod method = new DeleteMethod(href);
        try {
            if (params != null) {
                method.setQueryString(params.toArray());
            }
            this.client.executeMethod(method);
            int status = method.getStatusCode();
            if (status == 404) {
                throw new ObjectNotFoundException(msg);
            }
            if (status == 409) {
                throw new ConstraintViolationException(method.getStatusLine().getReasonPhrase());
            }
            if (status >= 400) {
                throw new CMISRuntimeException("Remote server returned error code: " + status);
            }
        }
        catch (IOException e) {
            throw new CMISRuntimeException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmlObjectWriterRequestEntity<T>
    implements RequestEntity {
        protected final XmlObjectWriter<T> writer;
        protected final T obj;

        public XmlObjectWriterRequestEntity(XmlObjectWriter<T> writer, T obj) {
            this.writer = writer;
            this.obj = obj;
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public String getContentType() {
            return this.writer.getContentType();
        }

        @Override
        public boolean isRepeatable() {
            return false;
        }

        @Override
        public void writeRequest(OutputStream out) throws IOException {
            this.writer.write(this.obj, out);
        }
    }
}

