/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client;

import java.util.Arrays;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.atompub.AtomPub;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.APPPropertyDefinition;
import org.apache.chemistry.atompub.client.APPRepository;
import org.apache.chemistry.atompub.client.APPType;
import org.apache.chemistry.atompub.client.stax.AbstractEntryReader;
import org.apache.chemistry.xml.stax.ChildrenNavigator;
import org.apache.chemistry.xml.stax.StaxReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeEntryReader
extends AbstractEntryReader<APPType> {
    private static final Log log = LogFactory.getLog(TypeEntryReader.class);
    protected final boolean includePropertyDefinitions;

    public TypeEntryReader(boolean includePropertyDefinitions) {
        this.includePropertyDefinitions = includePropertyDefinitions;
    }

    @Override
    protected APPType createObject(APPContext ctx) {
        APPType type = new APPType((APPRepository)ctx.getRepository());
        return type;
    }

    @Override
    protected void readAtomElement(APPContext ctx, StaxReader reader, APPType object) throws XMLStreamException {
        if (AtomPub.ATOM_LINK.equals(reader.getName())) {
            String rel = reader.getAttributeValue("http://www.w3.org/2005/Atom", "rel");
            String href = reader.getAttributeValue("http://www.w3.org/2005/Atom", "href");
            String type = reader.getAttributeValue("http://www.w3.org/2005/Atom", "type");
            object.addLink(rel, href, type);
        }
    }

    @Override
    protected void readCmisElement(APPContext ctx, StaxReader reader, APPType entry) throws XMLStreamException {
        if (AtomPubCMIS.TYPE.equals(reader.getName())) {
            ChildrenNavigator children = reader.getChildren();
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, PropertyDefinition> pdefs = new HashMap<String, PropertyDefinition>();
            while (children.next()) {
                String text;
                String name = reader.getLocalName();
                if (name.startsWith("property")) {
                    if (!this.includePropertyDefinitions) continue;
                    PropertyDefinition pdef = this.readPropertyDef(reader);
                    if (pdef.getId() == null) {
                        throw new IllegalArgumentException("Invalid property definition: no id given");
                    }
                    pdefs.put(pdef.getId(), pdef);
                    continue;
                }
                try {
                    text = reader.getElementText();
                }
                catch (XMLStreamException e) {
                    log.error("Cannot read text element for: " + name, e);
                    continue;
                }
                map.put(name, text);
            }
            if (!map.containsKey(CMIS.PARENT_ID.getLocalPart())) {
                map.put(CMIS.PARENT_ID.getLocalPart(), null);
            }
            for (QName qname : Arrays.asList(CMIS.ID, CMIS.LOCAL_NAME, CMIS.QUERY_NAME, CMIS.DISPLAY_NAME, CMIS.BASE_ID, CMIS.PARENT_ID, CMIS.DESCRIPTION, CMIS.CREATABLE, CMIS.FILEABLE, CMIS.QUERYABLE, CMIS.CONTROLLABLE_POLICY, CMIS.CONTROLLABLE_ACL, CMIS.FULLTEXT_INDEXED, CMIS.INCLUDED_IN_SUPERTYPE_QUERY)) {
                if (map.containsKey(qname.getLocalPart())) continue;
                log.error("Invalid type definition for " + (String)map.get(CMIS.ID.getLocalPart()) + ", missing " + qname.getPrefix() + ':' + qname.getLocalPart());
            }
            if (!this.includePropertyDefinitions) {
                pdefs = null;
            }
            entry.init(map, pdefs);
        }
    }

    protected PropertyDefinition readPropertyDef(StaxReader reader) throws XMLStreamException {
        return APPPropertyDefinition.fromXml(reader);
    }
}

