/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.atompub.AtomPub;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.stax.EntryReader;
import org.apache.chemistry.atompub.client.stax.FeedReader;
import org.apache.chemistry.xml.stax.ChildrenNavigator;
import org.apache.chemistry.xml.stax.StaxReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeedReader<T, E>
implements FeedReader<T> {
    protected EntryReader<E> entryBuilder;

    protected abstract T createFeed(StaxReader var1);

    protected abstract void addEntry(T var1, E var2);

    protected abstract void setHasMoreItems(T var1, boolean var2);

    protected abstract void setNumItems(T var1, int var2);

    protected AbstractFeedReader(EntryReader<E> entryBuilder) {
        this.entryBuilder = entryBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read(APPContext ctx, File file) throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            T t = this.read(ctx, in);
            return t;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read(APPContext ctx, URL url) throws XMLStreamException, IOException {
        InputStream in = url.openStream();
        try {
            T t = this.read(ctx, in);
            return t;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(APPContext ctx, InputStream in) throws XMLStreamException {
        StaxReader xr = StaxReader.newReader(in);
        try {
            T t = this.read(ctx, xr);
            return t;
        }
        finally {
            xr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(APPContext ctx, Reader reader) throws XMLStreamException {
        StaxReader xr = StaxReader.newReader(reader);
        try {
            T t = this.read(ctx, xr);
            return t;
        }
        finally {
            xr.close();
        }
    }

    @Override
    public T read(APPContext ctx, StaxReader reader) throws XMLStreamException {
        if (!reader.getFirstTag(AtomPub.ATOM_FEED)) {
            throw new XMLStreamException("Parse error: Not an atom feed");
        }
        T feed = this.createFeed(reader);
        ChildrenNavigator nav = reader.getChildren();
        while (nav.next() && !this.isDone(ctx, reader)) {
            String nsUri = reader.getNamespaceURI();
            if ("http://www.w3.org/2005/Atom".equals(nsUri)) {
                if (AtomPub.ATOM_ENTRY.equals(reader.getName())) {
                    this.addEntry(feed, this.entryBuilder.read(ctx, reader));
                    continue;
                }
                this.readAtomElement(ctx, reader, nsUri, feed);
                continue;
            }
            if (AtomPubCMIS.NUM_ITEMS.equals(reader.getName())) {
                String text = reader.getElementText();
                try {
                    this.setNumItems(feed, Integer.parseInt(text));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new XMLStreamException("Bad cmisra:numItems: " + e, e);
                }
            }
            this.readExtensionElement(ctx, reader, nsUri, feed);
        }
        return feed;
    }

    protected boolean isDone(APPContext ctx, StaxReader reader) throws XMLStreamException {
        return false;
    }

    protected void readAtomElement(APPContext ctx, StaxReader reader, String nsUri, T feed) throws XMLStreamException {
        String rel;
        if (AtomPub.ATOM_LINK.equals(reader.getName()) && "next".equals(rel = reader.getAttributeValue("http://www.w3.org/2005/Atom", "rel"))) {
            this.setHasMoreItems(feed, true);
        }
    }

    protected void readExtensionElement(APPContext ctx, StaxReader reader, String nsUri, T feed) throws XMLStreamException {
    }
}

