/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.client.stax;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.CapabilityACL;
import org.apache.chemistry.CapabilityChange;
import org.apache.chemistry.CapabilityJoin;
import org.apache.chemistry.CapabilityQuery;
import org.apache.chemistry.CapabilityRendition;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryInfo;
import org.apache.chemistry.atompub.AtomPub;
import org.apache.chemistry.atompub.AtomPubCMIS;
import org.apache.chemistry.atompub.URITemplate;
import org.apache.chemistry.atompub.client.APPContext;
import org.apache.chemistry.atompub.client.APPRepositoryCapabilities;
import org.apache.chemistry.atompub.client.APPRepositoryInfo;
import org.apache.chemistry.xml.stax.ChildrenNavigator;
import org.apache.chemistry.xml.stax.StaxReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceDocumentReader<T extends Repository> {
    protected abstract T createRepository(APPContext var1);

    protected abstract void addCollection(T var1, String var2, String var3);

    protected abstract void addURITemplate(T var1, URITemplate var2);

    protected abstract void setInfo(T var1, RepositoryInfo var2);

    public List<T> read(APPContext ctx, InputStream in) throws IOException {
        try {
            StaxReader reader = StaxReader.newReader(in);
            if (!reader.fwdTag("service")) {
                throw new IOException("Invalid APP service document");
            }
            ArrayList<T> repos = new ArrayList<T>(1);
            ChildrenNavigator workspaces = reader.getChildren("workspace");
            while (workspaces.next()) {
                T repo = this.createRepository(ctx);
                ChildrenNavigator children = reader.getChildren();
                while (children.next()) {
                    QName name = reader.getName();
                    if (AtomPub.APP_COLLECTION.equals(name)) {
                        String href = reader.getAttributeValue("href");
                        String type = "";
                        ChildrenNavigator nav = reader.getChildren();
                        while (nav.next()) {
                            QName n = reader.getName();
                            if (!AtomPubCMIS.COLLECTION_TYPE.equals(n)) continue;
                            type = reader.getElementText();
                        }
                        this.addCollection(repo, href, type);
                        continue;
                    }
                    if (AtomPubCMIS.REPOSITORY_INFO.equals(name)) {
                        RepositoryInfo info = this.readRepositoryInfo(ctx, reader);
                        this.setInfo(repo, info);
                        continue;
                    }
                    if (!AtomPubCMIS.URI_TEMPLATE.equals(name)) continue;
                    URITemplate uriTemplate = this.readURITemplate(ctx, reader);
                    this.addURITemplate(repo, uriTemplate);
                }
                repos.add(repo);
            }
            return repos;
        }
        catch (XMLStreamException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected RepositoryInfo readRepositoryInfo(APPContext ctx, StaxReader reader) throws XMLStreamException {
        APPRepositoryCapabilities caps = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet<BaseType> changeLogBaseTypes = new HashSet<BaseType>();
        ChildrenNavigator nav = reader.getChildren();
        while (nav.next()) {
            QName name = reader.getName();
            if (CMIS.CAPABILITIES.equals(name)) {
                caps = new APPRepositoryCapabilities();
                ChildrenNavigator capElems = reader.getChildren();
                while (capElems.next()) {
                    name = reader.getName();
                    if (CMIS.CAPABILITY_ALL_VERSIONS_SEARCHABLE.equals(name)) {
                        caps.setAllVersionsSearchable(Boolean.parseBoolean(reader.getElementText()));
                        continue;
                    }
                    if (CMIS.CAPABILITY_CAN_GET_DESCENDANTS.equals(name)) {
                        caps.setHasGetDescendants(Boolean.parseBoolean(reader.getElementText()));
                        continue;
                    }
                    if (CMIS.CAPABILITY_CAN_GET_FOLDER_TREE.equals(name)) {
                        caps.setHasGetFolderTree(Boolean.parseBoolean(reader.getElementText()));
                        continue;
                    }
                    if (CMIS.CAPABILITY_CONTENT_STREAM_UPDATABILITY.equals(name)) {
                        caps.setContentStreamUpdatableAnytime("anytime".equals(reader.getElementText()));
                        continue;
                    }
                    if (CMIS.CAPABILITY_MULTIFILING.equals(name)) {
                        caps.setHasMultifiling(Boolean.parseBoolean(reader.getElementText()));
                        continue;
                    }
                    if (CMIS.CAPABILITY_PWC_SEARCHABLE.equals(name)) {
                        caps.setPWCSearchable(Boolean.parseBoolean(reader.getElementText()));
                        continue;
                    }
                    if (CMIS.CAPABILITY_PWC_UPDATABLE.equals(name)) {
                        caps.setPWCUpdatable(Boolean.parseBoolean(reader.getElementText()));
                        continue;
                    }
                    if (CMIS.CAPABILITY_UNFILING.equals(name)) {
                        caps.setHasUnfiling(Boolean.parseBoolean(reader.getElementText()));
                        continue;
                    }
                    if (CMIS.CAPABILITY_VERSION_SPECIFIC_FILING.equals(name)) {
                        caps.setHasVersionSpecificFiling(Boolean.parseBoolean(reader.getElementText()));
                        continue;
                    }
                    if (CMIS.CAPABILITY_QUERY.equals(name)) {
                        caps.setQueryCapability(CapabilityQuery.get(reader.getElementText(), CapabilityQuery.NONE));
                        continue;
                    }
                    if (CMIS.CAPABILITY_JOIN.equals(name)) {
                        caps.setJoinCapability(CapabilityJoin.get(reader.getElementText(), CapabilityJoin.NONE));
                        continue;
                    }
                    if (CMIS.CAPABILITY_RENDITIONS.equals(name)) {
                        caps.setRenditionCapability(CapabilityRendition.get(reader.getElementText(), CapabilityRendition.NONE));
                        continue;
                    }
                    if (CMIS.CAPABILITY_CHANGES.equals(name)) {
                        caps.setChangeCapability(CapabilityChange.get(reader.getElementText(), CapabilityChange.NONE));
                        continue;
                    }
                    if (!CMIS.CAPABILITY_ACL.equals(name)) continue;
                    caps.setACLCapability(CapabilityACL.get(reader.getElementText(), CapabilityACL.NONE));
                }
                continue;
            }
            if (CMIS.REPOSITORY_SPECIFIC_INFORMATION.equals(name)) {
                this.readRepositorySpecificInformation(ctx, reader);
                continue;
            }
            if (CMIS.CHANGES_ON_TYPE.equals(name)) {
                changeLogBaseTypes.add(BaseType.get(reader.getElementText()));
                continue;
            }
            if (CMIS.ACL_CAPABILITY.equals(name)) continue;
            try {
                map.put(name.getLocalPart(), reader.getElementText());
            }
            catch (XMLStreamException e) {
            }
        }
        if (changeLogBaseTypes.isEmpty()) {
            changeLogBaseTypes.add(BaseType.DOCUMENT);
            changeLogBaseTypes.add(BaseType.FOLDER);
            changeLogBaseTypes.add(BaseType.RELATIONSHIP);
            changeLogBaseTypes.add(BaseType.POLICY);
        }
        return new APPRepositoryInfo(caps, map, changeLogBaseTypes);
    }

    protected URITemplate readURITemplate(APPContext ctx, StaxReader reader) throws XMLStreamException {
        String type = null;
        String mediaType = null;
        String template = null;
        ChildrenNavigator nav = reader.getChildren();
        while (nav.next()) {
            QName name = reader.getName();
            if (AtomPubCMIS.TYPE.equals(name)) {
                type = reader.getElementText();
                continue;
            }
            if (AtomPubCMIS.MEDIA_TYPE.equals(name)) {
                mediaType = reader.getElementText();
                continue;
            }
            if (!AtomPubCMIS.TEMPLATE.equals(name)) continue;
            template = reader.getElementText();
        }
        return new URITemplate(type, mediaType, template);
    }

    protected void readRepositorySpecificInformation(APPContext ctx, StaxReader reader) {
    }
}

