/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import java.io.Serializable;
import java.util.Map;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.model.Document;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.BaseResponseContext;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.axiom.om.OMContainer;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Repository;
import org.apache.chemistry.SPI;
import org.apache.chemistry.atompub.abdera.AllowableActionsDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISAllowableActionsEntry
implements CollectionAdapter {
    protected final Repository repository;

    public CMISAllowableActionsEntry(Repository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseContext getEntry(RequestContext request) {
        SPI spi = this.getSPI(request);
        try {
            String id = this.getResourceName(request);
            Inclusion inclusion = new Inclusion(null, null, null, true, false, false);
            ObjectEntry object = spi.getProperties(spi.newObjectId(id), inclusion);
            if (object == null) {
                EmptyResponseContext emptyResponseContext = new EmptyResponseContext(404);
                return emptyResponseContext;
            }
            Factory factory = request.getAbdera().getFactory();
            Document doc = factory.newDocument();
            AllowableActionsDocument el = new AllowableActionsDocument((OMContainer)((Object)doc), factory);
            el.setAllowableActions(object.getAllowableActions());
            BaseResponseContext baseResponseContext = new BaseResponseContext(doc);
            return baseResponseContext;
        }
        catch (Exception e) {
            EmptyResponseContext emptyResponseContext = new EmptyResponseContext(500, e.toString());
            return emptyResponseContext;
        }
        finally {
            spi.close();
        }
    }

    public SPI getSPI(RequestContext request) {
        return this.repository.getSPI(this.getConnectionParams(request));
    }

    protected Map<String, Serializable> getConnectionParams(RequestContext request) {
        return null;
    }

    protected String getResourceName(RequestContext request) {
        String resourceName = request.getTarget().getParameter("objectid");
        return UrlEncoding.decode(resourceName);
    }

    @Override
    public ResponseContext headEntry(RequestContext request) {
        return this.getEntry(request);
    }

    @Override
    public ResponseContext deleteEntry(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseContext extensionRequest(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseContext getCategories(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseContext getFeed(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseContext optionsEntry(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseContext postEntry(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseContext putEntry(RequestContext request) {
        throw new UnsupportedOperationException();
    }
}

