/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import java.util.Collection;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.Repository;
import org.apache.chemistry.SPI;
import org.apache.chemistry.atompub.server.CMISObjectsCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISParentsCollection
extends CMISObjectsCollection {
    public CMISParentsCollection(String type, String id, Repository repository) {
        super(type, "parents", id, repository);
    }

    @Override
    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Feed feed = super.createFeedBase(request);
        feed.addLink(this.getParentsLink(this.id, request), "self", "application/atom+xml;type=feed", null, null, -1L);
        return feed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<ObjectEntry> getEntries(RequestContext request) throws ResponseContextException {
        SPI spi = this.getSPI(request);
        try {
            Collection<ObjectEntry> parents;
            ObjectId objectId = spi.newObjectId(this.id);
            Collection<ObjectEntry> collection = parents = spi.getObjectParents(objectId, null);
            return collection;
        }
        finally {
            spi.close();
        }
    }
}

