/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetBuilder;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.WorkspaceManager;
import org.apache.abdera.protocol.server.impl.AbstractProvider;
import org.apache.abdera.protocol.server.impl.AbstractWorkspaceManager;
import org.apache.abdera.protocol.server.impl.RegexTargetResolver;
import org.apache.abdera.protocol.server.impl.SimpleWorkspaceInfo;
import org.apache.abdera.protocol.server.impl.TemplateTargetBuilder;
import org.apache.chemistry.Repository;
import org.apache.chemistry.atompub.URITemplate;
import org.apache.chemistry.atompub.server.CMISChildrenCollection;
import org.apache.chemistry.atompub.server.CMISCollectionForOther;
import org.apache.chemistry.atompub.server.CMISObjectsCollection;
import org.apache.chemistry.atompub.server.CMISQueryFeed;
import org.apache.chemistry.atompub.server.CMISServiceResponse;
import org.apache.chemistry.atompub.server.CMISTypesCollection;
import org.apache.chemistry.atompub.server.CMISWorkspaceManager;
import org.apache.chemistry.atompub.server.ServletRegexTargetResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISProvider
extends AbstractProvider {
    protected final Repository repository;
    protected final AbstractWorkspaceManager workspaceManager;
    protected final TemplateTargetBuilder targetBuilder;
    protected final RegexTargetResolver targetResolver;

    public CMISProvider(Repository repository) {
        this.repository = repository;
        this.targetBuilder = new TemplateTargetBuilder();
        this.targetResolver = new ServletRegexTargetResolver();
        this.targetBuilder.setTemplate((Object)TargetType.TYPE_SERVICE, "{target_base}/repository");
        this.targetResolver.setPattern("/repository(\\?.*)?", TargetType.TYPE_SERVICE);
        this.targetBuilder.setTemplate((Object)TargetType.TYPE_ENTRY, "{target_base}/{entrytype}/{id}");
        this.targetResolver.setPattern("/object(?:/?)([^/?]*)(\\?.*)?", TargetType.TYPE_ENTRY, "objectid");
        this.targetResolver.setPattern("/allowableactions/([^/?]+)", TargetType.TYPE_ENTRY, "objectid");
        this.targetResolver.setPattern("/type/([^/?]+)(\\?.*)?", TargetType.TYPE_ENTRY, "typeid");
        this.targetResolver.setPattern("/path/([^?]*)(\\?.*)?", TargetType.TYPE_ENTRY, "path");
        this.targetBuilder.setTemplate((Object)TargetType.TYPE_MEDIA, "{target_base}/file/{objectid}");
        this.targetResolver.setPattern("/file/([^/?]+)", TargetType.TYPE_MEDIA, "objectid");
        this.targetBuilder.setTemplate((Object)TargetType.TYPE_COLLECTION, "{target_base}/{collection}{-prefix|/|id}");
        this.targetResolver.setPattern("/checkedout(\\?.*)?", TargetType.TYPE_COLLECTION);
        this.targetResolver.setPattern("/unfiled", TargetType.TYPE_COLLECTION);
        this.targetResolver.setPattern("/query(\\?.*)?", CMISQueryFeed.TARGET_TYPE_CMIS_QUERY);
        this.targetResolver.setPattern("/typechildren(\\?.*)?", TargetType.TYPE_COLLECTION);
        this.targetResolver.setPattern("/parents/([^/?]+)(\\?.*)?", TargetType.TYPE_COLLECTION, "objectid");
        this.targetResolver.setPattern("/children/([^/?]+)(\\?.*)?", TargetType.TYPE_COLLECTION, "objectid");
        this.targetResolver.setPattern("/descendants/([^/?]+)(\\?.*)?", CMISObjectsCollection.TARGET_TYPE_CMIS_DESCENDANTS, "objectid");
        this.targetResolver.setPattern("/foldertree/([^/?]+)(\\?.*)?", CMISObjectsCollection.TARGET_TYPE_CMIS_FOLDER_TREE, "objectid");
        this.targetResolver.setPattern("/allversions/([^/?]+)(\\?.*)?", TargetType.TYPE_COLLECTION, "objectid");
        this.targetResolver.setPattern("/relationships/([^/?]+)(\\?.*)?", TargetType.TYPE_COLLECTION, "objectid");
        this.targetResolver.setPattern("/policies/([^/?]+)(\\?.*)?", TargetType.TYPE_COLLECTION, "objectid");
        this.targetResolver.setPattern("/typechildren/([^/?]+)(\\?.*)?", TargetType.TYPE_COLLECTION, "typeid");
        this.targetResolver.setPattern("/typedescendants(\\?.*)?", TargetType.TYPE_COLLECTION);
        this.targetResolver.setPattern("/typedescendants/([^/?]+)(\\?.*)?", TargetType.TYPE_COLLECTION, "typeid");
        SimpleWorkspaceInfo workspaceInfo = new SimpleWorkspaceInfo();
        workspaceInfo.setTitle(repository.getInfo().getName());
        workspaceInfo.addCollection(new CMISChildrenCollection("root", repository.getInfo().getRootFolderId().getId(), repository));
        workspaceInfo.addCollection(new CMISCollectionForOther("unfiled", "unfiled", null, repository));
        workspaceInfo.addCollection(new CMISCollectionForOther("checkedout", "checkedout", null, repository));
        workspaceInfo.addCollection(new CMISTypesCollection("types", null, repository));
        workspaceInfo.addCollection(new CMISQueryFeed(repository));
        this.workspaceManager = new CMISWorkspaceManager(this);
        this.workspaceManager.addWorkspace(workspaceInfo);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public List<URITemplate> getURITemplates(RequestContext request) {
        String base = request.getBaseUri().toString();
        if (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        base = base + request.getTargetBasePath().substring(request.getContextPath().length());
        ArrayList<URITemplate> list = new ArrayList<URITemplate>(3);
        list.add(new URITemplate("objectbyid", "application/atom+xml;type=entry", CMISProvider.addURITemplateParameters(base + "/object/{id}", "filter", "renditionFilter", "includeRelationships", "includeAllowableActions", "includePolicyIds", "includeACL")));
        list.add(new URITemplate("objectbypath", "application/atom+xml;type=entry", CMISProvider.addURITemplateParameters(base + "/object", "path", "filter", "renditionFilter", "includeRelationships", "includeAllowableActions", "includePolicyIds", "includeACL")));
        list.add(new URITemplate("query", "application/atom+xml;type=feed", CMISProvider.addURITemplateParameters(base + "/query", "q", "searchAllVersions", "maxItems", "skipCount", "includeRelationships", "includeAllowableActions")));
        list.add(new URITemplate("typebyid", "application/atom+xml;type=feed", base + "/type/{id}"));
        return list;
    }

    protected static String addURITemplateParameters(String s, String ... params) {
        StringBuilder buf = new StringBuilder(s);
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            buf.append(i == 0 ? (char)'?' : '&');
            buf.append(param);
            buf.append("={");
            buf.append(param);
            buf.append('}');
        }
        return buf.toString();
    }

    @Override
    protected TargetBuilder getTargetBuilder(RequestContext request) {
        return this.targetBuilder;
    }

    @Override
    protected Resolver<Target> getTargetResolver(RequestContext request) {
        return this.targetResolver;
    }

    @Override
    public WorkspaceManager getWorkspaceManager(RequestContext request) {
        return this.workspaceManager;
    }

    @Override
    public ResponseContext getServiceDocument(RequestContext request) {
        CMISServiceResponse response = new CMISServiceResponse(this, request);
        response.setStatus(200);
        response.setContentType("application/atomsvc+xml");
        return response;
    }
}

