/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.server;

import org.apache.abdera.model.Element;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.axiom.om.OMDocument;
import org.apache.chemistry.Inclusion;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Paging;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Repository;
import org.apache.chemistry.SPI;
import org.apache.chemistry.atompub.abdera.QueryElement;
import org.apache.chemistry.atompub.server.CMISObjectsCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISQueryFeed
extends CMISObjectsCollection {
    public static final TargetType TARGET_TYPE_CMIS_QUERY = TargetType.get("CMISQUERY", true);
    protected String statement;
    protected boolean searchAllVersions;
    protected int maxItems;
    protected int skipCount;
    protected String renditions;
    protected RelationshipDirection relationships;
    protected boolean allowableActions;
    protected boolean policies;
    protected boolean acls;

    public CMISQueryFeed(Repository repository) {
        super("query", "query", null, repository);
    }

    @Override
    public String getId(RequestContext request) {
        return "urn:id:1234collid";
    }

    @Override
    public ResponseContext extensionRequest(RequestContext request) {
        if (request.getTarget().getType() != TARGET_TYPE_CMIS_QUERY) {
            return ProviderHelper.notsupported(request);
        }
        if (request.getMethod().equalsIgnoreCase("GET")) {
            return this.getEntry(request);
        }
        if (request.getMethod().equalsIgnoreCase("POST")) {
            return this.postEntry(request);
        }
        return ProviderHelper.notallowed(request, "POST");
    }

    @Override
    public ResponseContext postEntry(RequestContext request) {
        OMDocument document;
        try {
            document = (OMDocument)((Object)request.getDocument(request.getAbdera().getParser()));
        }
        catch (Exception e) {
            return this.createErrorResponse(new ResponseContextException(500, (Throwable)e));
        }
        if (document == null) {
            return null;
        }
        Element element = (Element)((Object)document.getOMDocumentElement());
        QueryElement q = new QueryElement(element);
        this.statement = q.getStatement();
        this.searchAllVersions = q.getSearchAllVersions();
        this.maxItems = q.getMaxItems();
        this.skipCount = q.getSkipCount();
        this.renditions = q.getRenditionFilter();
        this.relationships = q.getIncludeRelationships();
        this.allowableActions = q.getIncludeAllowableActions();
        this.policies = q.getIncludePolicyIds();
        this.acls = q.getIncludeACL();
        return this.doSearch(request);
    }

    @Override
    public ResponseContext getEntry(RequestContext request) {
        Target target = request.getTarget();
        this.statement = target.getParameter("q");
        this.searchAllVersions = CMISQueryFeed.getParameter(request, "searchAllVersions", false);
        this.maxItems = CMISQueryFeed.getParameter(request, "maxItems", -1);
        this.skipCount = CMISQueryFeed.getParameter(request, "skipCount", 0);
        this.renditions = target.getParameter("renditionFilter");
        String rel = target.getParameter("includeRelationships");
        this.relationships = RelationshipDirection.fromInclusion(rel);
        this.allowableActions = CMISQueryFeed.getParameter(request, "includeAllowableActions", false);
        this.policies = CMISQueryFeed.getParameter(request, "includePolicyIds", false);
        this.acls = CMISQueryFeed.getParameter(request, "includeACL", false);
        return this.doSearch(request);
    }

    protected ResponseContext doSearch(RequestContext request) {
        ResponseContext res = this.getFeed(request);
        if (res.getStatus() == 200 && request.getMethod().equalsIgnoreCase("POST")) {
            res.setStatus(201);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<ObjectEntry> getEntries(RequestContext request) throws ResponseContextException {
        SPI spi = this.getSPI(request);
        try {
            ListPage<ObjectEntry> results;
            Paging paging = new Paging(this.maxItems == -1 ? 0 : this.maxItems, this.skipCount);
            Inclusion inclusion = new Inclusion(null, this.renditions, this.relationships, this.allowableActions, this.policies, this.acls);
            ListPage<ObjectEntry> listPage = results = spi.query(this.statement, this.searchAllVersions, inclusion, paging);
            return listPage;
        }
        finally {
            spi.close();
        }
    }
}

