/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Folder;
import org.apache.chemistry.NameConstraintViolationException;
import org.apache.chemistry.Policy;
import org.apache.chemistry.Property;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Relationship;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.Type;
import org.apache.chemistry.UpdateConflictException;
import org.apache.chemistry.impl.base.BaseObject;
import org.apache.chemistry.impl.simple.SimpleConnection;
import org.apache.chemistry.impl.simple.SimpleData;
import org.apache.chemistry.impl.simple.SimpleDocument;
import org.apache.chemistry.impl.simple.SimpleFolder;
import org.apache.chemistry.impl.simple.SimpleObjectEntry;
import org.apache.chemistry.impl.simple.SimplePolicy;
import org.apache.chemistry.impl.simple.SimpleProperty;
import org.apache.chemistry.impl.simple.SimpleRelationship;
import org.apache.chemistry.impl.simple.SimpleRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleObject
extends BaseObject {
    protected final SimpleObjectEntry entry;
    protected final Connection connection;
    private final Type type;

    protected SimpleObject(SimpleObjectEntry entry, Connection connection) {
        this.entry = entry;
        this.connection = connection;
        this.type = connection.getRepository().getType(entry.getTypeId());
    }

    protected static SimpleObject construct(SimpleObjectEntry entry, Connection connection) {
        BaseType baseType = connection.getRepository().getType(entry.getTypeId()).getBaseType();
        switch (baseType) {
            case DOCUMENT: {
                return new SimpleDocument(entry, connection);
            }
            case FOLDER: {
                return new SimpleFolder(entry, connection);
            }
            case POLICY: {
                return new SimplePolicy(entry, connection);
            }
            case RELATIONSHIP: {
                return new SimpleRelationship(entry, connection);
            }
        }
        throw new AssertionError();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void move(Folder targetFolder, Folder sourceFolder) throws NameConstraintViolationException, UpdateConflictException {
        this.connection.getSPI().moveObject(this, targetFolder, sourceFolder);
    }

    @Override
    public void delete() throws UpdateConflictException {
        this.connection.getSPI().deleteObject(this, false);
    }

    @Override
    public void unfile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Folder getParent() {
        SimpleConnection connection = (SimpleConnection)this.connection;
        Set<String> parents = connection.repository.parents.get(this.getId());
        if (parents == SimpleRepository.NO_PARENT) {
            return null;
        }
        if (parents.size() != 1) {
            throw new RuntimeException("Several parents for: " + this.getId());
        }
        String pid = parents.iterator().next();
        SimpleData data = connection.repository.datas.get(pid);
        return new SimpleFolder(new SimpleObjectEntry(data, connection), connection);
    }

    @Override
    public Collection<Folder> getParents() {
        SimpleConnection connection = (SimpleConnection)this.connection;
        Set<String> parents = connection.repository.parents.get(this.getId());
        if (parents == SimpleRepository.NO_PARENT) {
            return Collections.emptyList();
        }
        ArrayList<Folder> list = new ArrayList<Folder>(parents.size());
        for (String pid : parents) {
            SimpleData data = connection.repository.datas.get(pid);
            list.add(new SimpleFolder(new SimpleObjectEntry(data, connection), connection));
        }
        return list;
    }

    @Override
    public List<Relationship> getRelationships(RelationshipDirection direction, String typeId, boolean includeSubRelationshipTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyPolicy(Policy policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePolicy(Policy policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Policy> getPolicies() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public BaseType getBaseType() {
        return this.type.getBaseType();
    }

    @Override
    public Serializable getValue(String id) {
        PropertyDefinition pd = this.getType().getPropertyDefinition(id);
        if (pd == null) {
            throw new IllegalArgumentException(id);
        }
        Serializable value = this.entry.getValue(id);
        if (value == null) {
            value = pd.getDefaultValue();
        }
        return value;
    }

    @Override
    public Property getProperty(String id) {
        PropertyDefinition propertyDefinition = this.getType().getPropertyDefinition(id);
        if (propertyDefinition == null) {
            throw new IllegalArgumentException(id);
        }
        return new SimpleProperty(this.entry, id, propertyDefinition);
    }

    @Override
    public ContentStream getContentStream(String contentStreamId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        if (this.getId() == null) {
            ((SimpleConnection)this.connection).saveObject(this);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getTypeId() + ',' + this.getId() + ')';
    }
}

