/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Property;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.Updatability;

public class SimpleProperty
implements Property {
    protected static final String CONTENT_BYTES_KEY = "__content__";
    protected final ObjectEntry entry;
    protected final String id;
    private final PropertyDefinition propertyDefinition;

    public SimpleProperty(ObjectEntry entry, String id, PropertyDefinition propertyDefinition) {
        this.entry = entry;
        this.id = id;
        this.propertyDefinition = propertyDefinition;
    }

    public PropertyDefinition getDefinition() {
        return this.propertyDefinition;
    }

    public Serializable getValue() {
        return this.entry.getValue(this.id);
    }

    public void setValue(Serializable value) {
        if (this.propertyDefinition.getUpdatability() == Updatability.READ_ONLY) {
            throw new RuntimeException("Read-only property: " + this.id);
        }
        this.entry.setValue(this.id, value);
    }
}

