/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.test;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.apache.chemistry.AllowableAction;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.CapabilityACL;
import org.apache.chemistry.CapabilityChange;
import org.apache.chemistry.CapabilityJoin;
import org.apache.chemistry.CapabilityQuery;
import org.apache.chemistry.CapabilityRendition;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ConstraintViolationException;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.ListPage;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.ObjectId;
import org.apache.chemistry.ObjectNotFoundException;
import org.apache.chemistry.Paging;
import org.apache.chemistry.Property;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryCapabilities;
import org.apache.chemistry.RepositoryInfo;
import org.apache.chemistry.SPI;
import org.apache.chemistry.Tree;
import org.apache.chemistry.Type;
import org.apache.chemistry.atompub.client.APPObjectEntry;
import org.apache.chemistry.impl.simple.SimpleContentStream;
import org.apache.chemistry.impl.simple.SimpleObjectId;
import org.apache.chemistry.util.GregorianCalendar;
import org.apache.commons.io.IOUtils;

public abstract class BasicTestCase
extends TestCase {
    public Repository repository;
    public Connection conn;
    public SPI spi;
    public String rootFolderName = "";
    public String expectedRepositoryId = "test";
    public String expectedRepositoryName = "test";
    public String expectedRepositoryDescription = "Repository test";
    public String expectedRepositoryVendor = "Apache";
    public String expectedRepositoryProductName = "Chemistry Simple Repository";
    public String expectedRepositoryProductVersion = "0.5-NX";
    public boolean expectedCapabilityHasGetDescendants = true;
    public boolean expectedCapabilityHasGetFolderTree = true;
    public boolean expectedCapabilityHasMultifiling = false;
    public CapabilityQuery expectedCapabilityQuery = CapabilityQuery.BOTH_COMBINED;
    public boolean expectedCapabilityHasUnfiling = false;
    public String expectedRootTypeId = "chemistry:root";

    public abstract Repository makeRepository() throws Exception;

    public void setUp() throws Exception {
        this.repository = this.makeRepository();
        this.openConn();
    }

    public void tearDown() throws Exception {
        this.closeConn();
        super.tearDown();
    }

    protected void openConn() {
        this.conn = this.repository.getConnection(null);
        this.spi = this.conn.getSPI();
    }

    protected void closeConn() {
        this.conn.close();
        this.conn = null;
        this.spi = null;
    }

    public static Folder getFolderChild(Folder folder) {
        for (CMISObject child : folder.getChildren()) {
            if (child.getBaseType() != BaseType.FOLDER) continue;
            return (Folder)child;
        }
        return null;
    }

    public static Document getDocumentChild(Folder folder) {
        for (CMISObject child : folder.getChildren()) {
            if (child.getBaseType() != BaseType.DOCUMENT) continue;
            return (Document)child;
        }
        return null;
    }

    public void testRepository() {
        BasicTestCase.assertNotNull(this.repository);
        BasicTestCase.assertEquals(this.expectedRepositoryId, this.repository.getId());
        BasicTestCase.assertEquals(this.expectedRepositoryName, this.repository.getName());
        RepositoryInfo info = this.repository.getInfo();
        BasicTestCase.assertEquals(this.expectedRepositoryDescription, info.getDescription());
        BasicTestCase.assertEquals(this.expectedRepositoryVendor, info.getVendorName());
        BasicTestCase.assertEquals(this.expectedRepositoryProductName, info.getProductName());
        BasicTestCase.assertEquals(this.expectedRepositoryProductVersion, info.getProductVersion());
        BasicTestCase.assertEquals("1.0", info.getVersionSupported());
        BasicTestCase.assertFalse(info.isChangeLogIncomplete());
        Set<BaseType> clbt = info.getChangeLogBaseTypes();
        HashSet<BaseType> clbtExpected = new HashSet<BaseType>(Arrays.asList(BaseType.FOLDER, BaseType.DOCUMENT, BaseType.RELATIONSHIP, BaseType.POLICY));
        BasicTestCase.assertEquals(clbtExpected, clbt);
        RepositoryCapabilities cap = info.getCapabilities();
        BasicTestCase.assertEquals((Object)CapabilityACL.NONE, (Object)cap.getACLCapability());
        BasicTestCase.assertFalse(cap.isAllVersionsSearchable());
        BasicTestCase.assertEquals((Object)CapabilityChange.NONE, (Object)cap.getChangeCapability());
        BasicTestCase.assertTrue(cap.isContentStreamUpdatableAnytime());
        BasicTestCase.assertEquals(this.expectedCapabilityHasGetDescendants, cap.hasGetDescendants());
        BasicTestCase.assertEquals(this.expectedCapabilityHasGetFolderTree, cap.hasGetFolderTree());
        BasicTestCase.assertEquals(this.expectedCapabilityHasMultifiling, cap.hasMultifiling());
        BasicTestCase.assertFalse(cap.isPWCSearchable());
        BasicTestCase.assertFalse(cap.isPWCUpdatable());
        BasicTestCase.assertEquals((Object)this.expectedCapabilityQuery, (Object)cap.getQueryCapability());
        BasicTestCase.assertEquals((Object)CapabilityRendition.NONE, (Object)cap.getRenditionCapability());
        BasicTestCase.assertEquals(this.expectedCapabilityHasUnfiling, cap.hasUnfiling());
        BasicTestCase.assertFalse(cap.hasVersionSpecificFiling());
        BasicTestCase.assertEquals((Object)CapabilityJoin.NONE, (Object)cap.getJoinCapability());
    }

    public void testBasic() {
        BasicTestCase.assertNotNull(this.repository);
        BasicTestCase.assertNotNull(this.conn);
        Folder root = this.conn.getRootFolder();
        BasicTestCase.assertNotNull(root);
        Type rootType = root.getType();
        BasicTestCase.assertNotNull(rootType);
        BasicTestCase.assertEquals(this.expectedRootTypeId, rootType.getId());
        BasicTestCase.assertEquals(this.expectedRootTypeId, root.getTypeId());
        BasicTestCase.assertEquals(this.rootFolderName, root.getName());
        BasicTestCase.assertNull(root.getParent());
        Map<String, Property> props = root.getProperties();
        BasicTestCase.assertNotNull(props);
        BasicTestCase.assertTrue(props.size() > 0);
        List<CMISObject> entries = root.getChildren();
        BasicTestCase.assertEquals(1, entries.size());
        Folder f1 = (Folder)entries.get(0);
        Folder fold = f1.getParent();
        BasicTestCase.assertEquals(root.getId(), fold.getId());
    }

    public void testTypes() {
        Collection<Type> types = this.repository.getTypes();
        BasicTestCase.assertEquals(7, types.size());
    }

    public void testDefaultValues() {
        Folder root = this.conn.getRootFolder();
        Folder f1 = (Folder)root.getChildren().get(0);
        Folder f2 = BasicTestCase.getFolderChild(f1);
        List<CMISObject> children = f2.getChildren();
        BasicTestCase.assertEquals(3, children.size());
        for (CMISObject child : children) {
            String name = child.getName();
            String title = child.getString("title");
            String descr = child.getString("description");
            Calendar date = child.getDateTime("date");
            if (name.equals("doc 3")) {
                BasicTestCase.assertEquals("(no title)", title);
                BasicTestCase.assertEquals("", descr);
            } else {
                BasicTestCase.assertNotSame("", title);
                BasicTestCase.assertNotNull(descr);
            }
            BasicTestCase.assertNull(date);
            BasicTestCase.assertNotNull(child.getProperty("date"));
        }
    }

    public void testCreateSPI() throws Exception {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("cmis:objectTypeId", (Serializable)((Object)"fold"));
        properties.put("description", (Serializable)((Object)"some descr"));
        ObjectId folderId = this.spi.createFolder(properties, this.repository.getInfo().getRootFolderId());
        BasicTestCase.assertNotNull(folderId);
        Folder folder = (Folder)this.conn.getObject(folderId);
        BasicTestCase.assertEquals((Object)"some descr", folder.getValue("description"));
        properties = new HashMap();
        properties.put("cmis:objectTypeId", (Serializable)((Object)"doc"));
        properties.put("title", (Serializable)((Object)"some title"));
        ObjectId docId = this.spi.createDocument(properties, this.repository.getInfo().getRootFolderId(), null, null);
        BasicTestCase.assertNotNull(docId);
        Document doc = (Document)this.conn.getObject(docId);
        BasicTestCase.assertEquals((Object)"some title", doc.getValue("title"));
    }

    public void testCopySPI() throws Exception {
        ObjectEntry doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("title", (Serializable)((Object)"new title"));
        try {
            ObjectId id = this.spi.createDocumentFromSource(doc1, this.repository.getInfo().getRootFolderId(), properties, null);
            BasicTestCase.assertNotNull(id);
            BasicTestCase.assertNotSame(id, doc1.getId());
        }
        catch (CMISRuntimeException e) {
            BasicTestCase.assertTrue(e.getMessage().contains("AtomPub bindings do not support"));
            return;
        }
        ObjectEntry doc = this.spi.getObjectByPath("/doc 1", null);
        BasicTestCase.assertNotNull(doc);
        BasicTestCase.assertEquals((Object)"new title", doc.getValue("title"));
    }

    public void testCopy() throws Exception {
        ObjectEntry foldid = this.spi.getObjectByPath("/folder 1", null);
        Folder fold = (Folder)this.conn.getObject(foldid);
        ObjectEntry docid = this.spi.getObjectByPath("/folder 1/folder 2/doc 2", null);
        Document doc = (Document)this.conn.getObject(docid);
        try {
            Document newdoc = doc.copy(fold);
            BasicTestCase.assertNotSame(doc.getId(), newdoc.getId());
        }
        catch (CMISRuntimeException e) {
            BasicTestCase.assertTrue(e.getMessage().contains("AtomPub bindings do not support"));
            return;
        }
        ObjectEntry d = this.spi.getObjectByPath("/folder 1/doc 2", null);
        BasicTestCase.assertNotNull(d);
        BasicTestCase.assertEquals((Object)"doc 2 title", d.getValue("title"));
    }

    public void testQuery() {
        String rootId = this.spi.getRepository().getInfo().getRootFolderId().getId();
        String folder1Id = this.spi.getObjectByPath("/folder 1", null).getId();
        String folder2Id = this.spi.getObjectByPath("/folder 1/folder 2", null).getId();
        Collection<CMISObject> res = this.conn.query("SELECT * FROM doc", false);
        BasicTestCase.assertNotNull(res);
        BasicTestCase.assertEquals(4, res.size());
        res = this.conn.query("SELECT * FROM cmis:document", false);
        BasicTestCase.assertNotNull(res);
        BasicTestCase.assertEquals(4, res.size());
        ObjectEntry doc = this.spi.getObjectByPath("/folder 1/folder 2/doc 2", null);
        res = this.conn.query(String.format("SELECT * FROM cmis:document WHERE cmis:objectId = '%s'", doc.getId()), false);
        BasicTestCase.assertEquals(1, res.size());
        res = this.conn.query("SELECT * FROM fold", false);
        BasicTestCase.assertEquals(2, res.size());
        res = this.conn.query("SELECT * FROM cmis:folder", false);
        BasicTestCase.assertEquals(3, res.size());
        res = this.conn.query(String.format("SELECT * FROM cmis:folder WHERE cmis:objectId = '%s'", folder2Id), false);
        BasicTestCase.assertEquals(1, res.size());
        res = this.conn.query(String.format("SELECT * FROM cmis:folder WHERE cmis:objectId = '%s' AND cmis:name = 'folder 2' AND title <> 'blarg'", folder2Id), false);
        BasicTestCase.assertEquals(1, res.size());
        String sqlpat = "SELECT * FROM cmis:document WHERE IN_FOLDER('%s')";
        res = this.conn.query(String.format(sqlpat, folder2Id), false);
        BasicTestCase.assertEquals(3, res.size());
        sqlpat = "SELECT * FROM cmis:folder WHERE IN_FOLDER('%s')";
        res = this.conn.query(String.format(sqlpat, folder1Id), false);
        BasicTestCase.assertEquals(1, res.size());
        sqlpat = "SELECT * FROM cmis:document WHERE IN_TREE('%s')";
        res = this.conn.query(String.format(sqlpat, folder2Id), false);
        BasicTestCase.assertEquals(3, res.size());
        sqlpat = "SELECT * FROM cmis:document WHERE IN_TREE('%s')";
        res = this.conn.query(String.format(sqlpat, folder1Id), false);
        BasicTestCase.assertEquals(4, res.size());
        sqlpat = "SELECT * FROM cmis:folder WHERE IN_TREE('%s')";
        res = this.conn.query(String.format(sqlpat, rootId), false);
        BasicTestCase.assertEquals(2, res.size());
        res = this.conn.query("SELECT * FROM cmis:folder WHERE CONTAINS('description')", false);
        BasicTestCase.assertEquals(2, res.size());
        res = this.conn.query("SELECT * FROM cmis:document WHERE CONTAINS('small')", false);
        BasicTestCase.assertEquals(1, res.size());
        res = this.conn.query("SELECT cmis:name, SCORE() FROM cmis:document WHERE CONTAINS('small')", false);
        BasicTestCase.assertEquals(1, res.size());
    }

    public void testGetObjectByPath() {
        Folder root = this.conn.getRootFolder();
        BasicTestCase.assertEquals(this.rootFolderName, root.getName());
        BasicTestCase.assertNotNull(this.spi.getObjectByPath("/", null));
        BasicTestCase.assertNotNull(this.spi.getObjectByPath("/folder 1", null));
        BasicTestCase.assertNotNull(this.spi.getObjectByPath("/folder 1/doc 1", null));
        BasicTestCase.assertNotNull(this.spi.getObjectByPath("/folder 1/folder 2", null));
        BasicTestCase.assertNotNull(this.spi.getObjectByPath("/folder 1/folder 2/doc 2", null));
        BasicTestCase.assertNotNull(this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null));
        BasicTestCase.assertNull(this.spi.getObjectByPath("/nosuchname", null));
        BasicTestCase.assertNull(this.spi.getObjectByPath("/nosuchname/foo", null));
        BasicTestCase.assertNull(this.spi.getObjectByPath("/folder 1/nosuchname", null));
        BasicTestCase.assertNull(this.spi.getObjectByPath("/folder 1/doc 1/nosuchname", null));
        BasicTestCase.assertNotNull(this.conn.getFolder("/"));
        BasicTestCase.assertNotNull(this.conn.getFolder("/folder 1"));
        BasicTestCase.assertNotNull(this.conn.getFolder("/folder 1/folder 2"));
        try {
            this.conn.getFolder("/folder 1/doc 1");
            BasicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        BasicTestCase.assertNull(this.conn.getFolder("/notsuchname"));
    }

    public void testGetChildren() {
        Folder root = this.conn.getRootFolder();
        ListPage<ObjectEntry> page = this.spi.getChildren(root, null, null, new Paging(20, 0));
        BasicTestCase.assertEquals(1, page.size());
        BasicTestCase.assertFalse(page.getHasMoreItems());
        BasicTestCase.assertEquals(1, page.getNumItems());
        ObjectId folder1 = root.getChildren().get(0);
        page = this.spi.getChildren(folder1, null, null, new Paging(20, 0));
        BasicTestCase.assertEquals(2, page.size());
        BasicTestCase.assertFalse(page.getHasMoreItems());
        BasicTestCase.assertEquals(2, page.getNumItems());
        page = this.spi.getChildren(folder1, null, null, new Paging(1, 0));
        BasicTestCase.assertEquals(1, page.size());
        BasicTestCase.assertTrue(page.getHasMoreItems());
        BasicTestCase.assertEquals(2, page.getNumItems());
        page = this.spi.getChildren(folder1, null, null, new Paging(1, 1));
        BasicTestCase.assertEquals(1, page.size());
        BasicTestCase.assertFalse(page.getHasMoreItems());
        BasicTestCase.assertEquals(2, page.getNumItems());
        page = this.spi.getChildren(folder1, null, null, new Paging(2, 0));
        ObjectEntry folder2 = ((ObjectEntry)page.get(0)).getTypeId().equals("fold") ? (ObjectEntry)page.get(0) : (ObjectEntry)page.get(1);
        page = this.spi.getChildren(folder2, null, null, new Paging(1, 1));
        BasicTestCase.assertEquals(1, page.size());
        BasicTestCase.assertTrue(page.getHasMoreItems());
        BasicTestCase.assertEquals(3, page.getNumItems());
        page = this.spi.getChildren(folder2, null, null, new Paging(2, 0));
        BasicTestCase.assertEquals(2, page.size());
        BasicTestCase.assertTrue(page.getHasMoreItems());
        BasicTestCase.assertEquals(3, page.getNumItems());
        ObjectEntry doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        try {
            this.spi.getChildren(doc1, null, null, null);
            BasicTestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.spi.getChildren(this.spi.newObjectId("no-such-id"), null, null, null);
            BasicTestCase.fail();
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
    }

    public void testGetFolderTree() {
        RepositoryInfo info = this.repository.getInfo();
        if (!info.getCapabilities().hasGetFolderTree()) {
            return;
        }
        Folder root = this.conn.getRootFolder();
        Tree<ObjectEntry> desc = this.spi.getFolderTree(root, 4, null);
        BasicTestCase.assertEquals(2, desc.size());
        ObjectEntry doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        try {
            this.spi.getFolderTree(doc1, -1, null);
            BasicTestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.spi.getFolderTree(this.spi.newObjectId("no-such-id"), -1, null);
            BasicTestCase.fail();
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
    }

    public void testGetDescendants() {
        RepositoryInfo info = this.repository.getInfo();
        if (!info.getCapabilities().hasGetDescendants()) {
            return;
        }
        Folder root = this.conn.getRootFolder();
        Tree<ObjectEntry> desc = this.spi.getDescendants(root, 4, null, null);
        BasicTestCase.assertEquals(6, desc.size());
        ObjectEntry doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        try {
            this.spi.getDescendants(doc1, -1, null, null);
            BasicTestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.spi.getDescendants(this.spi.newObjectId("no-such-id"), -1, null, null);
            BasicTestCase.fail();
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
    }

    public void testTrees() throws Exception {
        RepositoryInfo info = this.repository.getInfo();
        if (!info.getCapabilities().hasGetDescendants()) {
            return;
        }
        Folder root = this.conn.getRootFolder();
        Tree<ObjectEntry> desc = this.spi.getDescendants(root, -1, null, null);
        BasicTestCase.assertEquals(6, desc.size());
        desc = this.spi.getDescendants(root, 1, null, null);
        BasicTestCase.assertEquals(1, desc.size());
        desc = this.spi.getDescendants(root, 2, null, null);
        BasicTestCase.assertEquals(3, desc.size());
        desc = this.spi.getDescendants(root, 3, null, null);
        BasicTestCase.assertEquals(6, desc.size());
        desc = this.spi.getDescendants(root, 4, null, null);
        BasicTestCase.assertEquals(6, desc.size());
        ObjectEntry fold1 = this.spi.getObjectByPath("/folder 1", null);
        desc = this.spi.getDescendants(fold1, -1, null, null);
        BasicTestCase.assertEquals(5, desc.size());
        desc = this.spi.getDescendants(fold1, 1, null, null);
        BasicTestCase.assertEquals(2, desc.size());
        desc = this.spi.getDescendants(fold1, 2, null, null);
        BasicTestCase.assertEquals(5, desc.size());
        desc = this.spi.getDescendants(fold1, 3, null, null);
        BasicTestCase.assertEquals(5, desc.size());
    }

    public void testGetFolderParent() {
        Folder root = this.conn.getRootFolder();
        BasicTestCase.assertNull(this.spi.getFolderParent(root, null));
        ObjectId folder1 = root.getChildren().get(0);
        ObjectEntry p1 = this.spi.getFolderParent(folder1, null);
        BasicTestCase.assertNotNull(p1);
        BasicTestCase.assertEquals(root.getId(), p1.getId());
    }

    public void testGetObjectParents() {
        Folder root = this.conn.getRootFolder();
        ObjectId folder1Id = root.getChildren().get(0);
        Folder folder1 = (Folder)this.conn.getObject(folder1Id);
        Document doc = BasicTestCase.getDocumentChild(folder1);
        Collection<ObjectEntry> parents = this.spi.getObjectParents(doc, null);
        BasicTestCase.assertEquals(1, parents.size());
    }

    public void testGetStream() throws Exception {
        Folder f1 = (Folder)this.conn.getRootFolder().getChildren().get(0);
        Folder f2 = BasicTestCase.getFolderChild(f1);
        Document other = null;
        Document dog = null;
        for (CMISObject child : f2.getChildren()) {
            String name = child.getName();
            if (name.equals("doc 2")) {
                other = (Document)child;
                continue;
            }
            if (!name.equals("dog.jpg")) continue;
            dog = (Document)child;
        }
        BasicTestCase.assertNotNull("doc 2 not found", other);
        BasicTestCase.assertNull(other.getContentStream());
        BasicTestCase.assertNotNull("dog not found", dog);
        ContentStream cs = dog.getContentStream();
        BasicTestCase.assertNotNull(cs);
        BasicTestCase.assertTrue(cs.getLength() != 0L);
        BasicTestCase.assertEquals("dog.jpg", cs.getFileName());
        BasicTestCase.assertEquals("image/jpeg", cs.getMimeType());
        BasicTestCase.assertNotNull(cs.getStream());
        InputStream in = dog.getContentStream().getStream();
        BasicTestCase.assertNotNull(in);
        byte[] array = IOUtils.toByteArray(in);
        BasicTestCase.assertTrue(array.length != 0);
        BasicTestCase.assertEquals((long)array.length, cs.getLength());
    }

    public void testContentStreamSPI() throws Exception {
        ObjectEntry ob = this.spi.getObjectByPath("/folder 1/doc 1", null);
        SimpleObjectId id = new SimpleObjectId(ob.getId());
        BasicTestCase.assertFalse(this.spi.hasContentStream(id));
        BasicTestCase.assertFalse(this.spi.hasContentStream(ob));
        byte[] blobBytes = "A file...\n".getBytes("UTF-8");
        String filename = "doc.txt";
        ContentStream cs = new SimpleContentStream(blobBytes, "text/plain;charset=UTF-8", filename);
        this.spi.setContentStream(ob, cs, true);
        BasicTestCase.assertTrue(this.spi.hasContentStream(id));
        cs = this.spi.getContentStream(id, null);
        BasicTestCase.assertNotNull(cs);
        BasicTestCase.assertEquals(filename, cs.getFileName());
        BasicTestCase.assertEquals("text/plain;charset=UTF-8", cs.getMimeType().replace(" ", ""));
        InputStream in = cs.getStream();
        BasicTestCase.assertNotNull(in);
        byte[] array = IOUtils.toByteArray(in);
        BasicTestCase.assertEquals(blobBytes.length, array.length);
        BasicTestCase.assertEquals((long)blobBytes.length, cs.getLength());
        this.spi.deleteContentStream(id);
        BasicTestCase.assertFalse(this.spi.hasContentStream(id));
    }

    public void testContentStream() throws Exception {
        ObjectEntry docId = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        Document doc = (Document)this.conn.getObject(docId);
        ContentStream cs = doc.getContentStream();
        BasicTestCase.assertNotNull(cs);
        InputStream in = cs.getStream();
        BasicTestCase.assertNotNull(in);
        String s = new String(IOUtils.toByteArray(in), "UTF-8");
        BasicTestCase.assertEquals("This is a test file.\nTesting, testing...\n", s);
    }

    public void testDeleteSPI() throws Exception {
        ObjectEntry doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        this.spi.deleteObject(doc1, false);
        doc1 = this.spi.getObjectByPath("/folder 1/doc 1", null);
        BasicTestCase.assertNull(doc1);
        try {
            this.spi.deleteObject(this.spi.newObjectId("nosuchid"), false);
            BasicTestCase.fail();
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        ObjectEntry folder1 = this.spi.getObjectByPath("/folder 1", null);
        try {
            this.spi.deleteObject(folder1, false);
            BasicTestCase.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testDeleteTreeSPI() throws Exception {
        ObjectEntry fold2 = this.spi.getObjectByPath("/folder 1/folder 2", null);
        this.spi.deleteTree(fold2, null, true);
        ObjectEntry oe = this.spi.getObjectByPath("/folder 1/doc 1", null);
        BasicTestCase.assertNotNull(oe);
        oe = this.spi.getObjectByPath("/folder 1/folder 2", null);
        BasicTestCase.assertNull(oe);
    }

    public void testNewDocument() throws Exception {
        Folder root = this.conn.getRootFolder();
        BasicTestCase.assertNull(BasicTestCase.getDocumentChild(root));
        Document doc = root.newDocument("doc");
        doc.setName("mydoc");
        doc.setValue("title", (Serializable)((Object)"mytitle"));
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT+05:00"));
        cal.clear();
        cal.set(2009, 6, 14, 12, 0, 0);
        cal.set(14, 0);
        BasicTestCase.assertEquals("GregorianCalendar(2009-07-14T12:00:00.000+05:00)", cal.toString());
        doc.setValue("date", cal);
        String blobText = "Another file...\n";
        byte[] blobBytes = blobText.getBytes("UTF-8");
        ContentStream cs = new SimpleContentStream(blobBytes, "text/plain;charset=UTF-8", "mydoc.txt");
        doc.setContentStream(cs);
        BasicTestCase.assertNull(doc.getId());
        doc.save();
        String id = doc.getId();
        BasicTestCase.assertNotNull(id);
        this.closeConn();
        this.openConn();
        root = this.conn.getRootFolder();
        doc = BasicTestCase.getDocumentChild(root);
        BasicTestCase.assertNotNull(doc);
        BasicTestCase.assertEquals(id, doc.getId());
        BasicTestCase.assertEquals("mydoc", doc.getName());
        BasicTestCase.assertEquals("mytitle", doc.getString("title"));
        Calendar cal2 = doc.getDateTime("date");
        BasicTestCase.assertEquals(cal.toString(), cal2.toString());
        cs = doc.getContentStream();
        BasicTestCase.assertNotNull(cs);
        BasicTestCase.assertTrue(cs.getLength() != 0L);
        BasicTestCase.assertEquals("mydoc.txt", cs.getFileName());
        BasicTestCase.assertEquals("text/plain;charset=UTF-8", cs.getMimeType());
        BasicTestCase.assertNotNull(cs.getStream());
        InputStream in = doc.getContentStream().getStream();
        BasicTestCase.assertNotNull(in);
        byte[] array = IOUtils.toByteArray(in);
        BasicTestCase.assertEquals(blobBytes.length, array.length);
        BasicTestCase.assertEquals((long)blobBytes.length, cs.getLength());
    }

    public void testNewFolder() throws Exception {
        Folder root = this.conn.getRootFolder();
        BasicTestCase.assertNull(BasicTestCase.getDocumentChild(root));
        Folder fold = root.newFolder("fold");
        fold.setName("myfold");
        fold.setValue("title", (Serializable)((Object)"mytitle"));
        BasicTestCase.assertNull(fold.getId());
        fold.save();
        String id = fold.getId();
        BasicTestCase.assertNotNull(id);
        this.closeConn();
        this.openConn();
        root = this.conn.getRootFolder();
        fold = null;
        for (CMISObject child : root.getChildren()) {
            if (!child.getName().equals("myfold")) continue;
            fold = (Folder)child;
            break;
        }
        BasicTestCase.assertNotNull(fold);
        BasicTestCase.assertEquals(id, fold.getId());
        BasicTestCase.assertEquals("myfold", fold.getName());
        BasicTestCase.assertEquals("mytitle", fold.getString("title"));
    }

    public void testUpdateSPI() throws Exception {
        ObjectEntry ob = this.spi.getObjectByPath("/folder 1/doc 1", null);
        BasicTestCase.assertEquals((Object)"doc 1 title", ob.getValue("title"));
        BasicTestCase.assertEquals((Object)"The doc 1 descr", ob.getValue("description"));
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("description", (Serializable)((Object)"new descr"));
        this.spi.updateProperties(ob, null, properties);
        ob = this.spi.getProperties(ob, null);
        BasicTestCase.assertEquals((Object)"doc 1 title", ob.getValue("title"));
        BasicTestCase.assertEquals((Object)"new descr", ob.getValue("description"));
    }

    public void testUpdate() throws Exception {
        String string = "A file...\n";
        byte[] blobBytes = string.getBytes("UTF-8");
        String filename = "doc.gif";
        SimpleContentStream cs = new SimpleContentStream(blobBytes, "image/gif", filename);
        ObjectEntry ob = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        Document doc = (Document)this.conn.getObject(ob);
        doc.setContentStream(cs);
        doc.setValue("title", (Serializable)((Object)"my doc 3"));
        doc.save();
        doc = (Document)this.conn.getObject(this.spi.newObjectId(ob.getId()));
        ContentStream cs2 = doc.getContentStream();
        BasicTestCase.assertEquals("doc.gif", cs2.getFileName());
        BasicTestCase.assertEquals("image/gif", cs2.getMimeType());
        BasicTestCase.assertEquals((long)blobBytes.length, cs2.getLength());
        byte[] array = IOUtils.toByteArray(cs2.getStream());
        BasicTestCase.assertEquals(string, new String(array, "UTF-8"));
        ob = this.spi.getObjectByPath("/folder 1/doc 1", null);
        doc = (Document)this.conn.getObject(ob);
        doc.setContentStream(cs);
        doc.setValue("title", (Serializable)((Object)"my doc 1"));
        doc.save();
    }

    public void testMoveSPI() throws Exception {
        ObjectEntry fold = this.spi.getObjectByPath("/folder 1", null);
        ObjectEntry doc = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        ObjectId res = this.spi.moveObject(doc, fold, null);
        BasicTestCase.assertEquals(doc.getId(), res.getId());
        doc = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        BasicTestCase.assertNull(doc);
        doc = this.spi.getObjectByPath("/folder 1/doc 3", null);
        BasicTestCase.assertNotNull(doc);
    }

    public void testMove() throws Exception {
        ObjectEntry foldid = this.spi.getObjectByPath("/folder 1", null);
        Folder fold = (Folder)this.conn.getObject(foldid);
        ObjectEntry docid = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        Document doc = (Document)this.conn.getObject(docid);
        doc.move(fold, null);
        BasicTestCase.assertEquals(docid.getId(), doc.getId());
        ObjectEntry d = this.spi.getObjectByPath("/folder 1/folder 2/doc 3", null);
        BasicTestCase.assertNull(d);
        d = this.spi.getObjectByPath("/folder 1/doc 3", null);
        BasicTestCase.assertNotNull(d);
    }

    public void testObjectAllowableActions() throws Exception {
        ObjectEntry fold = this.spi.getObjectByPath("/folder 1", null);
        Set<QName> aa = fold.getAllowableActions();
        BasicTestCase.assertNotNull(aa);
        BasicTestCase.assertTrue(aa.contains(AllowableAction.CAN_UPDATE_PROPERTIES));
    }

    public void testAllowableActionsSPI() throws Exception {
        ObjectEntry foldentry = this.spi.getObjectByPath("/folder 1", null);
        BasicTestCase.assertNotNull(foldentry.getAllowableActions());
        Set<QName> aa = this.spi.getAllowableActions(foldentry);
        BasicTestCase.assertNotNull(aa);
        BasicTestCase.assertTrue(aa.contains(AllowableAction.CAN_UPDATE_PROPERTIES));
        if (foldentry instanceof APPObjectEntry) {
            ((APPObjectEntry)foldentry).setAllowableActions(null);
            aa = this.spi.getAllowableActions(foldentry);
            BasicTestCase.assertNotNull(aa);
            BasicTestCase.assertTrue(aa.contains(AllowableAction.CAN_UPDATE_PROPERTIES));
            BasicTestCase.assertNotNull(foldentry.getAllowableActions());
        }
        ObjectId foldid = this.spi.newObjectId(foldentry.getId());
        aa = this.spi.getAllowableActions(foldid);
        BasicTestCase.assertNotNull(aa);
        BasicTestCase.assertTrue(aa.contains(AllowableAction.CAN_UPDATE_PROPERTIES));
    }

    public void testUpdateReadOnlyProperty() throws Exception {
        ObjectEntry ob = this.spi.getObjectByPath("/folder 1", null);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("description", (Serializable)((Object)"new descr"));
        properties.put("cmis:path", ob.getValue("cmis:path"));
        this.spi.updateProperties(ob, null, properties);
        ob = this.spi.getProperties(ob, null);
        BasicTestCase.assertEquals((Object)"new descr", ob.getValue("description"));
        ob = this.spi.getObjectByPath("/folder 1/doc 1", null);
        BasicTestCase.assertEquals((Object)"doc 1 title", ob.getValue("title"));
        BasicTestCase.assertEquals((Object)"The doc 1 descr", ob.getValue("description"));
        properties = new HashMap();
        properties.put("description", (Serializable)((Object)"new descr"));
        properties.put("cmis:lastModificationDate", Calendar.getInstance());
        this.spi.updateProperties(ob, null, properties);
        ob = this.spi.getProperties(ob, null);
        BasicTestCase.assertEquals((Object)"doc 1 title", ob.getValue("title"));
        BasicTestCase.assertEquals((Object)"new descr", ob.getValue("description"));
    }
}

