/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.chemistry.Repository;
import org.apache.chemistry.RepositoryManager;
import org.apache.chemistry.atompub.server.jaxrs.AbderaResource;
import org.apache.chemistry.atompub.server.servlet.CMISServlet;
import org.apache.chemistry.impl.simple.SimpleRepositoryService;
import org.apache.chemistry.test.BasicHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;

public class MainServlet {
    private static final Log log = LogFactory.getLog(MainServlet.class);
    public static final String ROOT_ID = "b7666828-f1aa-41e1-9d0a-94a7898ae569";
    private static final int DEFAULT_MINUTES = 60;
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_PORT = 8082;
    protected File tmpDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SimpleRepositoryService repositoryService = new SimpleRepositoryService(BasicHelper.makeSimpleRepository(ROOT_ID));
        RepositoryManager.getInstance().registerService(repositoryService);
        try {
            new MainServlet().run(args, "/cmis", "/repository");
        }
        finally {
            RepositoryManager.getInstance().unregisterService(repositoryService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args, String contextPath, String cmisService) throws Exception {
        String host = DEFAULT_HOST;
        int port = 8082;
        int minutes = 60;
        boolean jaxrs = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("--help".equals(arg)) {
                System.err.println("Usage: ... [--jaxrs] [-h HOST] [-p PORT] [-t TIME (minutes)]");
                System.exit(0);
            } else if ("--jaxrs".equals(arg)) {
                jaxrs = true;
            }
            if (i == args.length - 1) continue;
            if ("--host".equals(arg) || "-h".equals(arg)) {
                host = args[++i];
                continue;
            }
            if ("--port".equals(arg) || "-p".equals(arg)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (!"--time".equals(arg) && !"-t".equals(arg)) continue;
            minutes = Integer.parseInt(args[++i]);
        }
        Server server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setHost(host);
        connector.setPort(port);
        server.setConnectors(new Connector[]{connector});
        if (jaxrs) {
            this.setUpJAXRS(server, contextPath);
        } else {
            this.setUpAbderaServlet(server, contextPath);
        }
        server.start();
        String url = "http://" + host + ':' + port + contextPath + cmisService;
        log.warn("CMIS repository started, AtomPub service url: " + url);
        try {
            Thread.sleep(60000 * minutes);
            server.stop();
        }
        finally {
            if (jaxrs) {
                this.tearDownJAXRS();
            } else {
                this.tearDownAbderaServlet();
            }
        }
        log.warn("CMIS repository stopped");
    }

    protected void setUpAbderaServlet(Server server, String contextPath) throws Exception {
        Repository repository = RepositoryManager.getInstance().getDefaultRepository();
        CMISServlet servlet = new CMISServlet(repository);
        Context context = new Context(server, contextPath, 1);
        context.addServlet(new ServletHolder(servlet), "/*");
    }

    protected void tearDownAbderaServlet() {
    }

    protected void setUpJAXRS(Server server, String contextPath) throws Exception {
        if (!"/cmis".equals(contextPath)) {
            throw new RuntimeException("AbderaResource implies a context of /cmis");
        }
        AbderaResource.pathMunger = null;
        this.tmpDir = MainServlet.makeTmpDir();
        String webApp = MainServlet.makeWebApp(this.tmpDir);
        WebAppContext context = new WebAppContext((HandlerContainer)server, webApp, "");
        server.setHandler(context);
    }

    protected void tearDownJAXRS() throws IOException {
        FileUtils.forceDelete(this.tmpDir);
    }

    protected static File makeTmpDir() throws IOException {
        File tmpDir = File.createTempFile("test-chemistry-", null);
        tmpDir.delete();
        tmpDir.mkdir();
        return tmpDir;
    }

    protected static String makeWebApp(File tmpDir) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("jaxrs/web.xml");
        File war = new File(tmpDir, "war");
        File webinf = new File(war, "WEB-INF");
        webinf.mkdirs();
        File web = new File(webinf, "web.xml");
        FileOutputStream os = new FileOutputStream(web);
        IOUtils.copy(is, (OutputStream)os);
        return war.getAbsolutePath();
    }
}

