/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.cookies.CmisCookieManager;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final long serialVersionUID = 1L;
    private static final String WSSE_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSU_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private boolean sendBasicAuth;
    private boolean sendUsernameToken;
    private CmisCookieManager cookieManager;
    private Map<String, List<String>> fixedHeaders = new HashMap<String, List<String>>();

    @Override
    public void setSession(BindingSession session) {
        Object headerParam;
        super.setSession(session);
        this.sendBasicAuth = this.isTrue("org.apache.chemistry.opencmis.binding.auth.http.basic");
        this.sendUsernameToken = this.isTrue("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken");
        if (this.isTrue("org.apache.chemistry.opencmis.binding.cookies")) {
            this.cookieManager = new CmisCookieManager();
        }
        if (this.sendBasicAuth) {
            String user = this.getUser();
            String password = this.getPassword();
            if (user != null) {
                this.fixedHeaders.put("Authorization", this.createBasicAuthHeaderValue(user, password));
            }
            String proxyUser = this.getProxyUser();
            String proxyPassword = this.getProxyPassword();
            if (proxyUser != null) {
                this.fixedHeaders.put("Proxy-Authorization", this.createBasicAuthHeaderValue(proxyUser, proxyPassword));
            }
        }
        int x = 0;
        while ((headerParam = this.getSession().get("org.apache.chemistry.opencmis.binding.header." + x)) != null) {
            String key;
            String header = headerParam.toString();
            int colon = header.indexOf(58);
            if (colon > -1 && (key = header.substring(0, colon).trim()).length() > 0) {
                String value = header.substring(colon + 1).trim();
                List<String> values = this.fixedHeaders.get(key);
                if (values == null) {
                    this.fixedHeaders.put(key, Collections.singletonList(value));
                } else {
                    ArrayList<String> newValues = new ArrayList<String>(values);
                    newValues.add(value);
                    this.fixedHeaders.put(key, newValues);
                }
            }
            ++x;
        }
    }

    @Override
    public Map<String, List<String>> getHTTPHeaders(String url) {
        Map<String, List<String>> cookies;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(this.fixedHeaders);
        if (this.cookieManager != null && !(cookies = this.cookieManager.get(url, result)).isEmpty()) {
            result.putAll(cookies);
        }
        return result.isEmpty() ? null : result;
    }

    @Override
    public void putResponseHeaders(String url, int statusCode, Map<String, List<String>> headers) {
        if (this.cookieManager != null) {
            this.cookieManager.put(url, headers);
        }
    }

    @Override
    public Element getSOAPHeaders(Object portObject) {
        if (!this.sendUsernameToken) {
            return null;
        }
        String user = this.getUser();
        String password = this.getPassword();
        if (user == null) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        long created = System.currentTimeMillis();
        long expires = created + 86400000L;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element wsseSecurityElement = document.createElementNS(WSSE_NAMESPACE, "Security");
            Element wsuTimestampElement = document.createElementNS(WSU_NAMESPACE, "Timestamp");
            wsseSecurityElement.appendChild(wsuTimestampElement);
            Element tsCreatedElement = document.createElementNS(WSU_NAMESPACE, "Created");
            tsCreatedElement.appendChild(document.createTextNode(sdf.format(created)));
            wsuTimestampElement.appendChild(tsCreatedElement);
            Element tsExpiresElement = document.createElementNS(WSU_NAMESPACE, "Expires");
            tsExpiresElement.appendChild(document.createTextNode(sdf.format(expires)));
            wsuTimestampElement.appendChild(tsExpiresElement);
            Element usernameTokenElement = document.createElementNS(WSSE_NAMESPACE, "UsernameToken");
            wsseSecurityElement.appendChild(usernameTokenElement);
            Element usernameElement = document.createElementNS(WSSE_NAMESPACE, "Username");
            usernameElement.appendChild(document.createTextNode(user));
            usernameTokenElement.appendChild(usernameElement);
            Element passwordElement = document.createElementNS(WSSE_NAMESPACE, "Password");
            passwordElement.appendChild(document.createTextNode(password));
            passwordElement.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            usernameTokenElement.appendChild(passwordElement);
            Element createdElement = document.createElementNS(WSU_NAMESPACE, "Created");
            createdElement.appendChild(document.createTextNode(sdf.format(created)));
            usernameTokenElement.appendChild(createdElement);
            return wsseSecurityElement;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Map<String, List<String>> getFixedHeaders() {
        return this.fixedHeaders;
    }

    protected List<String> createBasicAuthHeaderValue(String username, String password) {
        if (password == null) {
            password = "";
        }
        try {
            return Collections.singletonList("Basic " + Base64.encodeBytes((byte[])(username + ":" + password).getBytes("ISO-8859-1")));
        }
        catch (UnsupportedEncodingException e) {
            return Collections.emptyList();
        }
    }

    protected boolean isTrue(String parameterName) {
        Object value = this.getSession().get(parameterName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }
}

