/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.cookies;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.chemistry.opencmis.client.bindings.spi.cookies.CmisHttpCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisCookieStoreImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String IP_ADDRESS_PATTERN_STR = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private final Map<URI, ArrayList<CmisHttpCookie>> storeMap;

    public CmisCookieStoreImpl() {
        this(1000);
    }

    public CmisCookieStoreImpl(final int maxUrls) {
        this.storeMap = new LinkedHashMap<URI, ArrayList<CmisHttpCookie>>(maxUrls + 1, 0.7f, true){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean removeEldestEntry(Map.Entry<URI, ArrayList<CmisHttpCookie>> eldest) {
                return this.size() > maxUrls;
            }
        };
    }

    public void add(URI uri, CmisHttpCookie cookie) {
        if (uri == null || cookie == null) {
            throw new NullPointerException();
        }
        ArrayList<Object> cookies = null;
        if (this.storeMap.containsKey(uri)) {
            cookies = this.storeMap.get(uri);
            cookies.remove(cookie);
            cookies.add(cookie);
            if (cookies.size() > 1) {
                this.cleanCookieList(cookies);
            }
        } else {
            cookies = new ArrayList<CmisHttpCookie>();
            cookies.add(cookie);
            this.storeMap.put(uri, cookies);
        }
    }

    public List<CmisHttpCookie> get(URI uri) {
        if (uri == null) {
            throw new NullPointerException("URI is null!");
        }
        ArrayList<CmisHttpCookie> cookies = this.storeMap.get(uri);
        if (cookies == null) {
            cookies = new ArrayList<CmisHttpCookie>();
        } else {
            this.cleanCookieList((List<CmisHttpCookie>)cookies);
        }
        ArrayList<URI> uris = new ArrayList<URI>(this.storeMap.keySet());
        for (URI u : uris) {
            if (u.equals(uri)) continue;
            boolean secure = false;
            String scheme = u.getScheme();
            if (scheme != null) {
                secure = scheme.toLowerCase().startsWith("https");
            }
            String newHost = uri.getHost().toLowerCase();
            List listCookie = this.storeMap.get(u);
            Iterator iter = listCookie.iterator();
            while (iter.hasNext()) {
                CmisHttpCookie cookie = (CmisHttpCookie)iter.next();
                if (cookie.hasExpired()) {
                    iter.remove();
                    if (!listCookie.isEmpty()) continue;
                    this.storeMap.remove(u);
                    continue;
                }
                if (cookies.contains(cookie) || cookie.getSecure() && !secure || cookie.getDomain() == null) continue;
                String newDomain = cookie.getDomain().toLowerCase();
                if (this.isIPAddress(newHost)) {
                    if (!newHost.equals(newDomain)) continue;
                    cookies.add(cookie);
                    continue;
                }
                if (cookie.getVersion() == 0) {
                    if (!newHost.endsWith(newDomain)) continue;
                    if (newHost.length() == newDomain.length()) {
                        cookies.add(cookie);
                        continue;
                    }
                    if (!newDomain.startsWith(".")) continue;
                    cookies.add(cookie);
                    continue;
                }
                if (cookie.getVersion() != 1 || !CmisHttpCookie.domainMatches(cookie.getDomain(), newHost)) continue;
                cookies.add(cookie);
            }
        }
        return cookies;
    }

    private boolean isIPAddress(String s) {
        if (s.startsWith("[")) {
            return true;
        }
        return IP_ADDRESS_PATTERN.matcher(s).matches();
    }

    private void cleanCookieList(List<CmisHttpCookie> cookies) {
        Iterator<CmisHttpCookie> iter = cookies.iterator();
        while (iter.hasNext()) {
            CmisHttpCookie cookie = iter.next();
            if (!cookie.hasExpired()) continue;
            iter.remove();
        }
    }

    public List<CmisHttpCookie> getCookies() {
        ArrayList<CmisHttpCookie> cookies = new ArrayList<CmisHttpCookie>();
        Collection<ArrayList<CmisHttpCookie>> values = this.storeMap.values();
        for (ArrayList<CmisHttpCookie> list : values) {
            Iterator<CmisHttpCookie> iter = list.iterator();
            while (iter.hasNext()) {
                CmisHttpCookie cookie = iter.next();
                if (cookie.hasExpired()) {
                    iter.remove();
                    continue;
                }
                if (cookies.contains(cookie)) continue;
                cookies.add(cookie);
            }
        }
        return Collections.unmodifiableList(cookies);
    }

    public List<URI> getURIs() {
        return new ArrayList<URI>(this.storeMap.keySet());
    }

    public boolean remove(URI uri, CmisHttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("Cookie is null!");
        }
        boolean success = false;
        Collection<ArrayList<CmisHttpCookie>> values = this.storeMap.values();
        for (ArrayList<CmisHttpCookie> list : values) {
            if (!list.remove(cookie)) continue;
            success = true;
        }
        return success;
    }

    public boolean removeAll() {
        if (!this.storeMap.isEmpty()) {
            this.storeMap.clear();
        }
        return true;
    }
}

