/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.server.impl.atompub.XMLDocumentBase;

public abstract class AtomDocumentBase
extends XMLDocumentBase {
    private static final String ID_PREFIX = "http://chemistry.apache.org/";
    private static final String ID_DUMMY = "http://chemistry.apache.org/no-id";
    private SimpleDateFormat dateFormater;

    public String formatDate(long millis) {
        if (this.dateFormater == null) {
            this.dateFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
            this.dateFormater.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return this.dateFormater.format(millis);
    }

    public String generateAtomId(String input) {
        if (input == null) {
            return ID_DUMMY;
        }
        try {
            return ID_PREFIX + Base64.encodeBytes((byte[])input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return ID_DUMMY;
        }
    }

    public void writeSimpleTag(String namespace, String name, String value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement(namespace, name);
        xsw.writeCharacters(value);
        xsw.writeEndElement();
    }

    public void writeSimpleDate(String namespace, String name, GregorianCalendar value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        this.writeSimpleTag(namespace, name, this.formatDate(value.getTimeInMillis()));
    }

    public void writeSimpleDate(String namespace, String name, long millis) throws XMLStreamException {
        this.writeSimpleTag(namespace, name, this.formatDate(millis));
    }

    public void writeId(String id) throws XMLStreamException {
        this.writeSimpleTag("http://www.w3.org/2005/Atom", "id", id);
    }

    public void writeTitle(String title) throws XMLStreamException {
        this.writeSimpleTag("http://www.w3.org/2005/Atom", "title", title);
    }

    public void writeAuthor(String author) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("http://www.w3.org/2005/Atom", "author");
        this.writeSimpleTag("http://www.w3.org/2005/Atom", "name", author);
        xsw.writeEndElement();
    }

    public void writeUpdated(GregorianCalendar updated) throws XMLStreamException {
        this.writeSimpleDate("http://www.w3.org/2007/app", "edited", updated);
        this.writeSimpleDate("http://www.w3.org/2005/Atom", "updated", updated);
    }

    public void writeUpdated(long updated) throws XMLStreamException {
        this.writeSimpleDate("http://www.w3.org/2007/app", "edited", updated);
        this.writeSimpleDate("http://www.w3.org/2005/Atom", "updated", updated);
    }

    public void writePublished(GregorianCalendar published) throws XMLStreamException {
        this.writeSimpleDate("http://www.w3.org/2005/Atom", "published", published);
    }

    public void writePublished(long published) throws XMLStreamException {
        this.writeSimpleDate("http://www.w3.org/2005/Atom", "published", published);
    }

    public void writePathSegment(String pathSegment) throws XMLStreamException {
        this.writeSimpleTag("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "pathSegment", pathSegment);
    }

    public void writeRelativePathSegment(String relativePathSegment) throws XMLStreamException {
        this.writeSimpleTag("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "relativePathSegment", relativePathSegment);
    }

    public void writeCollection(String href, String collectionType, String text, String ... accept) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("http://www.w3.org/2007/app", "collection");
        xsw.writeAttribute("href", href);
        if (collectionType != null) {
            xsw.writeStartElement("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "collectionType");
            xsw.writeCharacters(collectionType);
            xsw.writeEndElement();
        }
        xsw.writeStartElement("http://www.w3.org/2005/Atom", "title");
        xsw.writeAttribute("type", "text");
        xsw.writeCharacters(text);
        xsw.writeEndElement();
        for (String ct : accept) {
            xsw.writeStartElement("http://www.w3.org/2007/app", "accept");
            xsw.writeCharacters(ct);
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
    }

    public void writeLink(String rel, String href, String type, String id) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("http://www.w3.org/2005/Atom", "link");
        xsw.writeAttribute("rel", rel);
        xsw.writeAttribute("href", href);
        if (type != null) {
            xsw.writeAttribute("type", type);
        }
        if (id != null) {
            xsw.writeAttribute("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "id", id);
        }
        xsw.writeEndElement();
    }

    public void writeServiceLink(String href, String repositoryId) throws XMLStreamException {
        try {
            this.writeLink("service", href + "?repositoryId=" + URLEncoder.encode(repositoryId, "UTF-8"), "application/atomsvc+xml", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void writeSelfLink(String href, String id) throws XMLStreamException {
        this.writeLink("self", href, "application/atom+xml;type=entry", id);
    }

    public void writeEnclosureLink(String href) throws XMLStreamException {
        this.writeLink("enclosure", href, "application/atom+xml;type=entry", null);
    }

    public void writeEditLink(String href) throws XMLStreamException {
        this.writeLink("edit", href, "application/atom+xml;type=entry", null);
    }

    public void writeAlternateLink(String href, String type, String kind, String title, BigInteger length) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("http://www.w3.org/2005/Atom", "link");
        xsw.writeAttribute("rel", "alternate");
        xsw.writeAttribute("href", href);
        if (type != null) {
            xsw.writeAttribute("type", type);
        }
        if (kind != null) {
            xsw.writeAttribute("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "renditionKind", kind);
        }
        if (title != null) {
            xsw.writeAttribute("title", title);
        }
        if (length != null) {
            xsw.writeAttribute("length", length.toString());
        }
        xsw.writeEndElement();
    }

    public void writeWorkingCopyLink(String href) throws XMLStreamException {
        this.writeLink("working-copy", href, "application/atom+xml;type=entry", null);
    }

    public void writeUpLink(String href, String type) throws XMLStreamException {
        this.writeLink("up", href, type, null);
    }

    public void writeDownLink(String href, String type) throws XMLStreamException {
        this.writeLink("down", href, type, null);
    }

    public void writeVersionHistoryLink(String href) throws XMLStreamException {
        this.writeLink("version-history", href, "application/atom+xml;type=feed", null);
    }

    public void writeCurrentVerionsLink(String href) throws XMLStreamException {
        this.writeLink("current-version", href, "application/atom+xml;type=entry", null);
    }

    public void writeEditMediaLink(String href, String type) throws XMLStreamException {
        this.writeLink("edit-media", href, type, null);
    }

    public void writeDescribedByLink(String href) throws XMLStreamException {
        this.writeLink("describedby", href, "application/atom+xml;type=entry", null);
    }

    public void writeAllowableActionsLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/allowableactions", href, "application/cmisallowableactions+xml", null);
    }

    public void writeAclLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/acl", href, "application/cmisacl+xml", null);
    }

    public void writePoliciesLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/policies", href, "application/atom+xml;type=feed", null);
    }

    public void writeRelationshipsLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/relationships", href, "application/atom+xml;type=feed", null);
    }

    public void writeRelationshipSourceLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/source", href, "application/atom+xml;type=entry", null);
    }

    public void writeRelationshipTargetLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/target", href, "application/atom+xml;type=entry", null);
    }

    public void writeFolderTreeLink(String href) throws XMLStreamException {
        this.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", href, "application/atom+xml;type=feed", null);
    }

    public void writeTypeUpLink(String href, String type) throws XMLStreamException {
        this.writeLink("up", href, type, null);
    }

    public void writeTypeDownLink(String href, String type) throws XMLStreamException {
        this.writeLink("down", href, type, null);
    }

    public void writeViaLink(String href) throws XMLStreamException {
        this.writeLink("via", href, "application/atom+xml;type=entry", null);
    }

    public void writeFirstLink(String href) throws XMLStreamException {
        this.writeLink("first", href, "application/atom+xml;type=feed", null);
    }

    public void writeLastLink(String href) throws XMLStreamException {
        this.writeLink("last", href, "application/atom+xml;type=feed", null);
    }

    public void writePreviousLink(String href) throws XMLStreamException {
        this.writeLink("previous", href, "application/atom+xml;type=feed", null);
    }

    public void writeNextLink(String href) throws XMLStreamException {
        this.writeLink("next", href, "application/atom+xml;type=feed", null);
    }
}

