/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisQueryType;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public class DiscoveryService {
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";

    private DiscoveryService() {
    }

    public static void query(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String statement = null;
        Boolean searchAllVersions = null;
        Boolean includeAllowableActions = null;
        IncludeRelationships includeRelationships = null;
        String renditionFilter = null;
        BigInteger maxItems = null;
        BigInteger skipCount = null;
        int statusCode = 0;
        if (METHOD_POST.equals(request.getMethod())) {
            Object queryRequest = null;
            try {
                Unmarshaller u = JaxBHelper.createUnmarshaller();
                queryRequest = u.unmarshal((InputStream)request.getInputStream());
            }
            catch (Exception e) {
                throw new CmisInvalidArgumentException("Invalid query request: " + e, (Throwable)e);
            }
            if (!(queryRequest instanceof JAXBElement)) {
                throw new CmisInvalidArgumentException("Not a query document!");
            }
            if (!(((JAXBElement)queryRequest).getValue() instanceof CmisQueryType)) {
                throw new CmisInvalidArgumentException("Not a query document!");
            }
            CmisQueryType queryType = (CmisQueryType)((JAXBElement)queryRequest).getValue();
            statement = queryType.getStatement();
            searchAllVersions = queryType.isSearchAllVersions();
            includeAllowableActions = queryType.isIncludeAllowableActions();
            includeRelationships = (IncludeRelationships)Converter.convert(IncludeRelationships.class, (Enum)queryType.getIncludeRelationships());
            renditionFilter = queryType.getRenditionFilter();
            maxItems = queryType.getMaxItems();
            skipCount = queryType.getSkipCount();
            statusCode = 201;
        } else if (METHOD_GET.equals(request.getMethod())) {
            statement = HttpUtils.getStringParameter(request, "q");
            searchAllVersions = HttpUtils.getBooleanParameter(request, "searchAllVersions");
            includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
            includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            renditionFilter = null;
            maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
            skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount");
            statusCode = 200;
        } else {
            throw new CmisRuntimeException("Invalid HTTP method!");
        }
        ObjectList results = service.query(repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, null);
        if (results == null) {
            throw new CmisRuntimeException("Results are null!");
        }
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        UrlBuilder pagingUrl = AtomPubUtils.compileUrlBuilder(baseUrl, "query", null);
        pagingUrl.addParameter("q", (Object)statement);
        pagingUrl.addParameter("searchAllVersions", (Object)searchAllVersions);
        pagingUrl.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        pagingUrl.addParameter("includeRelationships", (Object)includeRelationships);
        UrlBuilder location = new UrlBuilder(pagingUrl);
        location.addParameter("maxItems", (Object)maxItems);
        location.addParameter("skipCount", (Object)skipCount);
        response.setStatus(statusCode);
        response.setContentType("application/atom+xml;type=feed");
        response.setHeader("Location", location.toString());
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        feed.startFeed(true);
        GregorianCalendar now = new GregorianCalendar();
        feed.writeFeedElements("query", null, "", "Query", now, null, results.getNumItems());
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        feed.writePagingLinks(pagingUrl, maxItems, skipCount, results.getNumItems(), results.hasMoreItems(), AtomPubUtils.PAGE_SIZE);
        if (results.getObjects() != null) {
            AtomEntry entry = new AtomEntry(feed.getWriter());
            int idCounter = 0;
            for (ObjectData result : results.getObjects()) {
                if (result == null) continue;
                DiscoveryService.writeQueryResultEntry(entry, result, "id-" + ++idCounter, now);
            }
        }
        feed.endFeed();
        feed.endDocument();
    }

    private static void writeQueryResultEntry(AtomEntry entry, ObjectData result, String id, GregorianCalendar now) throws Exception {
        CmisObjectType resultJaxb = Converter.convert((ObjectData)result);
        if (resultJaxb == null) {
            return;
        }
        entry.startEntry(false);
        entry.writeAuthor("");
        entry.writeId(entry.generateAtomId(id));
        entry.writePublished(now);
        entry.writeTitle("Query Result " + id);
        entry.writeUpdated(now);
        JaxBHelper.marshal((Object)JaxBHelper.CMIS_EXTRA_OBJECT_FACTORY.createObject(resultJaxb), (XMLStreamWriter)entry.getWriter(), (boolean)true);
        entry.endEntry();
    }

    public static void getContentChanges(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigInteger maxItems;
        Boolean includeAcl;
        Boolean includePolicyIds;
        String filter;
        Boolean includeProperties;
        String changeLogToken = HttpUtils.getStringParameter(request, "changeLogToken");
        Holder changeLogTokenHolder = new Holder((Object)changeLogToken);
        ObjectList changes = service.getContentChanges(repositoryId, changeLogTokenHolder, includeProperties = HttpUtils.getBooleanParameter(request, "includeProperties"), filter = HttpUtils.getStringParameter(request, "filter"), includePolicyIds = HttpUtils.getBooleanParameter(request, "includePolicyIds"), includeAcl = HttpUtils.getBooleanParameter(request, "includeACL"), maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems"), null);
        if (changes == null) {
            throw new CmisRuntimeException("Changes are null!");
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=feed");
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        feed.startFeed(true);
        GregorianCalendar now = new GregorianCalendar();
        feed.writeFeedElements("contentChanges", null, "", "Content Change", now, null, changes.getNumItems());
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        if (changeLogTokenHolder.getValue() != null) {
            UrlBuilder nextLink = AtomPubUtils.compileUrlBuilder(baseUrl, "changes", null);
            nextLink.addParameter("changeLogToken", changeLogTokenHolder.getValue());
            nextLink.addParameter("includeProperties", (Object)includeProperties);
            nextLink.addParameter("filter", (Object)filter);
            nextLink.addParameter("includePolicyIds", (Object)includePolicyIds);
            nextLink.addParameter("includeACL", (Object)includeAcl);
            nextLink.addParameter("maxItems", (Object)maxItems);
            feed.writeNextLink(nextLink.toString());
        }
        if (changes.getObjects() != null) {
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (ObjectData object : changes.getObjects()) {
                if (object == null) continue;
                AtomPubUtils.writeContentChangesObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, false);
            }
        }
        feed.endFeed();
        feed.endDocument();
    }
}

