/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.OutputStream;
import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public class RelationshipService {
    private RelationshipService() {
    }

    public static void getObjectRelationships(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigInteger skipCount;
        BigInteger maxItems;
        Boolean includeAllowableActions;
        String filter;
        String typeId;
        RelationshipDirection relationshipDirection;
        Boolean includeSubRelationshipTypes;
        String objectId = HttpUtils.getStringParameter(request, "id");
        ObjectList relationships = service.getObjectRelationships(repositoryId, objectId, includeSubRelationshipTypes = HttpUtils.getBooleanParameter(request, "includeSubRelationshipTypes"), relationshipDirection = HttpUtils.getEnumParameter(request, "relationshipDirection", RelationshipDirection.class), typeId = HttpUtils.getStringParameter(request, "typeId"), filter = HttpUtils.getStringParameter(request, "filter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems"), skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount"), null);
        if (relationships == null) {
            throw new CmisRuntimeException("Relationships are null!");
        }
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, objectId);
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=feed");
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        feed.startFeed(true);
        feed.writeFeedElements(objectInfo.getId(), objectInfo.getAtomId(), objectInfo.getCreatedBy(), objectInfo.getName(), objectInfo.getLastModificationDate(), null, relationships.getNumItems());
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        feed.writeSelfLink(AtomPubUtils.compileUrl(baseUrl, "relationships", objectInfo.getId()), null);
        UrlBuilder pagingUrl = new UrlBuilder(AtomPubUtils.compileUrlBuilder(baseUrl, "relationships", objectInfo.getId()));
        pagingUrl.addParameter("includeSubRelationshipTypes", (Object)includeSubRelationshipTypes);
        pagingUrl.addParameter("relationshipDirection", (Object)relationshipDirection);
        pagingUrl.addParameter("typeId", (Object)typeId);
        pagingUrl.addParameter("filter", (Object)filter);
        pagingUrl.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        feed.writePagingLinks(pagingUrl, maxItems, skipCount, relationships.getNumItems(), relationships.hasMoreItems(), AtomPubUtils.PAGE_SIZE);
        AtomEntry entry = new AtomEntry(feed.getWriter());
        for (ObjectData object : relationships.getObjects()) {
            if (object == null) continue;
            AtomPubUtils.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, false);
        }
        feed.endFeed();
        feed.endDocument();
    }
}

