/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public class DiscoveryService {
    private DiscoveryService() {
    }

    public static void query(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String statement = HttpUtils.getStringParameter(request, "statement");
        if (statement == null || statement.length() == 0) {
            statement = HttpUtils.getStringParameter(request, "q");
        }
        Boolean searchAllVersions = HttpUtils.getBooleanParameter(request, "searchAllVersions");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        IncludeRelationships includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        BigInteger skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ObjectList results = service.query(repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, null);
        if (results == null) {
            throw new CmisRuntimeException("Results are null!");
        }
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonResults = JSONConverter.convert((ObjectList)results, (TypeCache)typeCache, (boolean)true, (boolean)succinct);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonResults, request, response);
    }

    public static void getContentChanges(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String changeLogToken = HttpUtils.getStringParameter(request, "changeLogToken");
        Boolean includeProperties = HttpUtils.getBooleanParameter(request, "includeProperties");
        String filter = HttpUtils.getStringParameter(request, "filter");
        Boolean includePolicyIds = HttpUtils.getBooleanParameter(request, "includePolicyIds");
        Boolean includeAcl = HttpUtils.getBooleanParameter(request, "includeACL");
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        Holder changeLogTokenHolder = new Holder((Object)changeLogToken);
        ObjectList changes = service.getContentChanges(repositoryId, changeLogTokenHolder, includeProperties, filter, includePolicyIds, includeAcl, maxItems, null);
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonChanges = JSONConverter.convert((ObjectList)changes, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        jsonChanges.put((Object)"changeLogToken", changeLogTokenHolder.getValue());
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonChanges, request, response);
    }
}

