/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStream;

public class MultipartParser {
    public static final String MULTIPART = "multipart/";
    private static final int MAX_FIELD_BYTES = 0xA00000;
    private static final int BUFFER_SIZE = 65536;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte DASH = 45;
    private static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private final HttpServletRequest request;
    private final File tempDir;
    private final int memoryThreshold;
    private final long maxContentSize;
    private final InputStream requestStream;
    private byte[] boundary;
    private int[] badCharacters;
    private int[] goodSuffixes;
    private byte[] buffer;
    private byte[] buffer2;
    private int bufferPosition;
    private int bufferCount;
    private boolean eof;
    private int fieldBytes;
    private boolean hasContent;
    private Map<String, String> headers;
    private boolean isContent;
    private String name;
    private String filename;
    private String contentType;
    private BigInteger contentSize;
    private InputStream contentStream;
    private String value;

    public MultipartParser(HttpServletRequest request, File tempDir, int memoryThreshold, long maxContentSize) throws IOException {
        this.request = request;
        this.tempDir = tempDir;
        this.memoryThreshold = memoryThreshold;
        this.maxContentSize = maxContentSize;
        this.requestStream = request.getInputStream();
        this.extractBoundary();
        this.buffer = new byte[65536 + this.boundary.length];
        this.buffer2 = new byte[this.buffer.length];
        this.bufferPosition = 0;
        this.bufferCount = 0;
        this.eof = false;
        this.hasContent = false;
        this.fieldBytes = 0;
        this.skipPreamble();
    }

    private void extractBoundary() {
        int j;
        String contentType = this.request.getContentType();
        byte[] extractedBoundary = MimeHelper.getBoundaryFromMultiPart((String)contentType);
        if (extractedBoundary == null) {
            throw new CmisInvalidArgumentException("Invalid multipart request!");
        }
        this.boundary = new byte[BOUNDARY_PREFIX.length + extractedBoundary.length];
        System.arraycopy(BOUNDARY_PREFIX, 0, this.boundary, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(extractedBoundary, 0, this.boundary, BOUNDARY_PREFIX.length, extractedBoundary.length);
        int m = this.boundary.length;
        this.badCharacters = new int[256];
        Arrays.fill(this.badCharacters, -1);
        for (int j2 = 0; j2 < m; ++j2) {
            this.badCharacters[this.boundary[j2] & 0xFF] = j2;
        }
        int[] f = new int[m + 1];
        this.goodSuffixes = new int[m + 1];
        int i = m;
        f[i] = j = m + 1;
        while (i > 0) {
            while (j <= m && this.boundary[i - 1] != this.boundary[j - 1]) {
                if (this.goodSuffixes[j] == 0) {
                    this.goodSuffixes[j] = j - i;
                }
                j = f[j];
            }
            f[--i] = --j;
        }
        j = f[0];
        for (i = 0; i <= m; ++i) {
            if (this.goodSuffixes[i] == 0) {
                this.goodSuffixes[i] = j;
            }
            if (i != j) continue;
            j = f[j];
        }
    }

    private int findBoundary() {
        int j;
        if (this.bufferCount < this.boundary.length) {
            if (this.eof) {
                throw new CmisInvalidArgumentException("Unexpected end of stream!");
            }
            return -1;
        }
        int m = this.boundary.length;
        for (int i = 0; i <= this.bufferCount - m; i += Math.max(this.goodSuffixes[j + 1], j - this.badCharacters[this.buffer[i + j] & 0xFF])) {
            for (j = m - 1; j >= 0 && this.boundary[j] == this.buffer[i + j]; --j) {
            }
            if (j >= 0) continue;
            return i;
        }
        return -1;
    }

    private void readBuffer() throws IOException {
        if (this.bufferPosition < this.bufferCount) {
            System.arraycopy(this.buffer, this.bufferPosition, this.buffer2, 0, this.bufferCount - this.bufferPosition);
            this.bufferCount -= this.bufferPosition;
            byte[] tmpBuffer = this.buffer2;
            this.buffer2 = this.buffer;
            this.buffer = tmpBuffer;
        } else {
            this.bufferCount = 0;
        }
        this.bufferPosition = 0;
        if (this.eof) {
            return;
        }
        do {
            int r;
            if ((r = this.requestStream.read(this.buffer, this.bufferCount, this.buffer.length - this.bufferCount)) == -1) {
                this.eof = true;
                break;
            }
            this.bufferCount += r;
        } while (this.buffer.length != this.bufferCount);
    }

    private int nextByte() throws IOException {
        if (this.bufferCount == 0) {
            if (this.eof) {
                return -1;
            }
            this.readBuffer();
            return this.nextByte();
        }
        if (this.bufferCount > this.bufferPosition) {
            return this.buffer[this.bufferPosition++];
        }
        this.readBuffer();
        return this.nextByte();
    }

    private String readLine() throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        while ((r = this.nextByte()) > -1) {
            if (r == 13) {
                if (this.nextByte() == 10) break;
                throw new CmisInvalidArgumentException("Invalid multipart request!");
            }
            sb.append((char)r);
        }
        return sb.toString();
    }

    private void readHeaders() throws IOException {
        int b = this.nextByte();
        if (b == -1) {
            throw new CmisInvalidArgumentException("Unexpected end of stream!");
        }
        if (b == 45) {
            b = this.nextByte();
            if (b == 45) {
                this.headers = null;
                return;
            }
        } else if (b == 13 && (b = this.nextByte()) == 10) {
            this.parseHeaders();
            return;
        }
        throw new CmisInvalidArgumentException("Invalid multipart request!");
    }

    private void parseHeaders() throws IOException {
        String line;
        this.headers = new HashMap<String, String>();
        while ((line = this.readLine()).length() > 0) {
            int x = line.indexOf(58);
            if (x <= 0) continue;
            this.headers.put(line.substring(0, x).toLowerCase(Locale.ENGLISH).trim(), line.substring(x + 1).trim());
        }
    }

    public void readBodyAsString(String charset) throws IOException {
        int boundaryPosition;
        ByteArrayOutputStream bos;
        block3: {
            bos = new ByteArrayOutputStream();
            do {
                this.readBuffer();
                boundaryPosition = this.findBoundary();
                if (boundaryPosition > -1) break block3;
                int len = Math.min(65536, this.bufferCount) - this.bufferPosition;
                bos.write(this.buffer, this.bufferPosition, len);
                this.bufferPosition += len;
                this.fieldBytes += bos.size();
            } while (this.fieldBytes <= 0xA00000);
            throw new CmisInvalidArgumentException("Limit exceeded!");
        }
        bos.write(this.buffer, this.bufferPosition, boundaryPosition - this.bufferPosition);
        this.bufferPosition = boundaryPosition + this.boundary.length;
        try {
            this.value = bos.toString(charset);
        }
        catch (UnsupportedEncodingException uee) {
            throw new CmisInvalidArgumentException("Unknown endcoding!");
        }
    }

    public void readBodyAsStream() throws Exception {
        ThresholdOutputStream stream = new ThresholdOutputStream(this.tempDir, this.memoryThreshold, this.maxContentSize);
        try {
            int boundaryPosition;
            while (true) {
                this.readBuffer();
                boundaryPosition = this.findBoundary();
                if (boundaryPosition > -1) break;
                int len = Math.min(65536, this.bufferCount) - this.bufferPosition;
                stream.write(this.buffer, this.bufferPosition, len);
                this.bufferPosition += len;
            }
            stream.write(this.buffer, this.bufferPosition, boundaryPosition - this.bufferPosition);
            this.bufferPosition = boundaryPosition + this.boundary.length;
            stream.close();
            this.contentSize = BigInteger.valueOf(stream.getSize());
            this.contentStream = stream.getInputStream();
        }
        catch (Exception e) {
            stream.destroy();
            throw e;
        }
    }

    private void readBody() throws Exception {
        String contentDisposition = this.headers.get("content-disposition");
        if (contentDisposition == null) {
            throw new CmisInvalidArgumentException("Invalid multipart request!");
        }
        HashMap params = new HashMap();
        MimeHelper.decodeContentDisposition((String)contentDisposition, params);
        this.name = (String)params.get("name");
        this.filename = (String)params.get("filename");
        this.isContent = this.filename != null;
        this.contentType = this.headers.get("content-type");
        if (this.isContent) {
            if (this.hasContent) {
                throw new CmisInvalidArgumentException("Only one content expected!");
            }
            this.hasContent = true;
            if (this.contentType == null) {
                this.contentType = "application/octet-stream";
            }
            this.readBodyAsStream();
        } else {
            this.contentSize = BigInteger.ZERO;
            String charset = null;
            if (this.contentType != null) {
                charset = MimeHelper.getCharsetFromContentType((String)this.contentType);
            }
            if (charset == null) {
                charset = "ISO-8859-1";
            }
            this.readBodyAsString(charset);
        }
    }

    private void skipPreamble() throws IOException {
        int boundaryPosition;
        this.readBuffer();
        if (this.bufferCount < this.boundary.length - 2) {
            throw new CmisInvalidArgumentException("Invalid multipart request!");
        }
        for (int i = 2; i < this.boundary.length && this.boundary[i] == this.buffer[i - 2]; ++i) {
            if (i != this.boundary.length - 1) continue;
            this.bufferPosition = this.boundary.length - 2;
            this.readBuffer();
            return;
        }
        while (true) {
            if ((boundaryPosition = this.findBoundary()) > -1) break;
            this.bufferPosition = 65537;
            this.readBuffer();
        }
        this.bufferPosition = boundaryPosition + this.boundary.length;
        this.readBuffer();
    }

    private void skipEpilogue() {
        try {
            byte[] tmpBuf = new byte[4096];
            while (this.requestStream.read(tmpBuf) > -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean readNext() throws Exception {
        try {
            this.readHeaders();
            if (this.headers == null) {
                this.skipEpilogue();
                return false;
            }
            this.readBody();
            return true;
        }
        catch (Exception e) {
            if (this.contentStream != null) {
                try {
                    this.contentStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.skipEpilogue();
            throw e;
        }
    }

    public boolean isContent() {
        return this.isContent;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BigInteger getSize() {
        return this.contentSize;
    }

    public InputStream getStream() {
        return this.contentStream;
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }
}

