/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public final class NavigationService {
    private NavigationService() {
    }

    public static void getChildren(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String filter = HttpUtils.getStringParameter(request, "filter");
        String orderBy = HttpUtils.getStringParameter(request, "orderBy");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        IncludeRelationships includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        Boolean includePathSegment = HttpUtils.getBooleanParameter(request, "includePathSegment");
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        BigInteger skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ObjectInFolderList children = service.getChildren(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItems, skipCount, null);
        if (children == null) {
            throw new CmisRuntimeException("Children are null!");
        }
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonChildren = JSONConverter.convert((ObjectInFolderList)children, (TypeCache)typeCache, (boolean)succinct);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonChildren, request, response);
    }

    public static void getDescendants(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        BigInteger depth = HttpUtils.getBigIntegerParameter(request, "depth");
        String filter = HttpUtils.getStringParameter(request, "filter");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        IncludeRelationships includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        Boolean includePathSegment = HttpUtils.getBooleanParameter(request, "includePathSegment");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        List descendants = service.getDescendants(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, null);
        if (descendants == null) {
            throw new CmisRuntimeException("Descendants are null!");
        }
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONArray jsonDescendants = new JSONArray();
        for (ObjectInFolderContainer descendant : descendants) {
            jsonDescendants.add((Object)JSONConverter.convert((ObjectInFolderContainer)descendant, (TypeCache)typeCache, (boolean)succinct));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonDescendants, request, response);
    }

    public static void getFolderTree(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        BigInteger depth = HttpUtils.getBigIntegerParameter(request, "depth");
        String filter = HttpUtils.getStringParameter(request, "filter");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        IncludeRelationships includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        Boolean includePathSegment = HttpUtils.getBooleanParameter(request, "includePathSegment");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        List folderTree = service.getFolderTree(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, null);
        if (folderTree == null) {
            throw new CmisRuntimeException("Folder Tree are null!");
        }
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONArray jsonDescendants = new JSONArray();
        for (ObjectInFolderContainer descendant : folderTree) {
            jsonDescendants.add((Object)JSONConverter.convert((ObjectInFolderContainer)descendant, (TypeCache)typeCache, (boolean)succinct));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonDescendants, request, response);
    }

    public static void getFolderParent(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String filter = HttpUtils.getStringParameter(request, "filter");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ObjectData parent = service.getFolderParent(repositoryId, objectId, filter, null);
        if (parent == null) {
            throw new CmisRuntimeException("Parent is null!");
        }
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)parent, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getObjectParents(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String filter = HttpUtils.getStringParameter(request, "filter");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        IncludeRelationships includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        Boolean includeRelativePathSegment = HttpUtils.getBooleanParameter(request, "includeRelativePathSegment");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        List parents = service.getObjectParents(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includeRelativePathSegment, null);
        if (parents == null) {
            throw new CmisRuntimeException("Parents are null!");
        }
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONArray jsonParents = new JSONArray();
        for (ObjectParentData parent : parents) {
            jsonParents.add((Object)JSONConverter.convert((ObjectParentData)parent, (TypeCache)typeCache, (boolean)succinct));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonParents, request, response);
    }

    public static void getCheckedOutDocs(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String filter = HttpUtils.getStringParameter(request, "filter");
        String orderBy = HttpUtils.getStringParameter(request, "orderBy");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        IncludeRelationships includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        BigInteger skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ObjectList checkedout = service.getCheckedOutDocs(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, null);
        if (checkedout == null) {
            throw new CmisRuntimeException("Checked out list is null!");
        }
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonCheckedOut = JSONConverter.convert((ObjectList)checkedout, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonCheckedOut, request, response);
    }
}

