/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.LastModifiedContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public final class ObjectService {
    private static final int BUFFER_SIZE = 65536;

    private ObjectService() {
    }

    public static void createDocument(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        VersioningState versioningState = HttpUtils.getEnumParameter(request, "versioningState", VersioningState.class);
        String token = HttpUtils.getStringParameter(request, "token");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ControlParser cp = new ControlParser(request);
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        String newObjectId = service.createDocument(repositoryId, BrowserBindingUtils.createProperties(cp, null, typeCache), folderId, BrowserBindingUtils.createContentStream(request), versioningState, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New document is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        BrowserBindingUtils.setStatus(request, response, 201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, token, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void createDocumentFromSource(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String sourceId = HttpUtils.getStringParameter(request, "sourceId");
        VersioningState versioningState = HttpUtils.getEnumParameter(request, "versioningState", VersioningState.class);
        String token = HttpUtils.getStringParameter(request, "token");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ControlParser cp = new ControlParser(request);
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        ObjectData sourceDoc = BrowserBindingUtils.getSimpleObject(service, repositoryId, sourceId);
        PropertyData sourceTypeId = (PropertyData)sourceDoc.getProperties().getProperties().get("cmis:objectTypeId");
        if (sourceTypeId == null || sourceTypeId.getFirstValue() == null) {
            throw new CmisRuntimeException("Source object has no type!?!");
        }
        String newObjectId = service.createDocumentFromSource(repositoryId, sourceId, BrowserBindingUtils.createProperties(cp, sourceTypeId.getFirstValue().toString(), typeCache), folderId, versioningState, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New document is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        BrowserBindingUtils.setStatus(request, response, 201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, token, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void createFolder(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String token = HttpUtils.getStringParameter(request, "token");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ControlParser cp = new ControlParser(request);
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        String newObjectId = service.createFolder(repositoryId, BrowserBindingUtils.createProperties(cp, null, typeCache), folderId, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New folder is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        BrowserBindingUtils.setStatus(request, response, 201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, token, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void createPolicy(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String token = HttpUtils.getStringParameter(request, "token");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ControlParser cp = new ControlParser(request);
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        String newObjectId = service.createPolicy(repositoryId, BrowserBindingUtils.createProperties(cp, null, typeCache), folderId, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New policy is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        BrowserBindingUtils.setStatus(request, response, 201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, token, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void createRelationship(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String token = HttpUtils.getStringParameter(request, "token");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ControlParser cp = new ControlParser(request);
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        String newObjectId = service.createRelationship(repositoryId, BrowserBindingUtils.createProperties(cp, null, typeCache), BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New relationship is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        BrowserBindingUtils.setStatus(request, response, 201);
        BrowserBindingUtils.setCookie(request, response, repositoryId, token, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void updateProperties(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String typeId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectTypeId");
        String changeToken = HttpUtils.getStringParameter(request, "changeToken");
        String token = HttpUtils.getStringParameter(request, "token");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ControlParser cp = new ControlParser(request);
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        Holder objectIdHolder = new Holder((Object)objectId);
        Holder changeTokenHolder = changeToken == null ? null : new Holder((Object)changeToken);
        service.updateProperties(repositoryId, objectIdHolder, changeTokenHolder, BrowserBindingUtils.createProperties(cp, typeId, typeCache), null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        int status = 200;
        if (!objectId.equals(newObjectId)) {
            status = 201;
        }
        BrowserBindingUtils.setStatus(request, response, status);
        BrowserBindingUtils.setCookie(request, response, repositoryId, token, BrowserBindingUtils.createCookieValue(status, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getProperties(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        ReturnVersion returnVersion = HttpUtils.getEnumParameter(request, "returnVersion", ReturnVersion.class);
        String filter = HttpUtils.getStringParameter(request, "filter");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        Properties properties = returnVersion == ReturnVersion.LATEST || returnVersion == ReturnVersion.LASTESTMAJOR ? service.getPropertiesOfLatestVersion(repositoryId, objectId, null, Boolean.valueOf(returnVersion == ReturnVersion.LASTESTMAJOR), filter, null) : service.getProperties(repositoryId, objectId, filter, null);
        if (properties == null) {
            throw new CmisRuntimeException("Properties are null!");
        }
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((Properties)properties, (String)objectId, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getObject(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        ReturnVersion returnVersion = HttpUtils.getEnumParameter(request, "returnVersion", ReturnVersion.class);
        String filter = HttpUtils.getStringParameter(request, "filter");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        IncludeRelationships includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        Boolean includePolicyIds = HttpUtils.getBooleanParameter(request, "includePolicyIds");
        Boolean includeAcl = HttpUtils.getBooleanParameter(request, "includeACL");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ObjectData object = returnVersion == ReturnVersion.LATEST || returnVersion == ReturnVersion.LASTESTMAJOR ? service.getObjectOfLatestVersion(repositoryId, objectId, null, Boolean.valueOf(returnVersion == ReturnVersion.LASTESTMAJOR), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null) : service.getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getAllowableActions(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        AllowableActions allowableActions = service.getAllowableActions(repositoryId, objectId, null);
        JSONObject jsonAllowableActions = JSONConverter.convert((AllowableActions)allowableActions);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonAllowableActions, request, response);
    }

    public static void getRenditions(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        BigInteger skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount");
        List renditions = service.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, null);
        JSONArray jsonRenditions = new JSONArray();
        if (renditions != null) {
            for (RenditionData rendition : renditions) {
                jsonRenditions.add((Object)JSONConverter.convert((RenditionData)rendition));
            }
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonRenditions, request, response);
    }

    public static void getContentStream(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int b;
        String contentType;
        GregorianCalendar lastModified;
        BigInteger length;
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String streamId = HttpUtils.getStringParameter(request, "streamId");
        boolean download = "attachment".equalsIgnoreCase(HttpUtils.getStringParameter(request, "download"));
        BigInteger offset = context.getOffset();
        ContentStream content = service.getContentStream(repositoryId, objectId, streamId, offset, length = context.getLength(), null);
        if (content == null || content.getStream() == null) {
            throw new CmisRuntimeException("Content stream is null!");
        }
        if (content instanceof LastModifiedContentStream && (lastModified = ((LastModifiedContentStream)content).getLastModified()) != null) {
            long lastModifiedSecs = (long)Math.floor((double)lastModified.getTimeInMillis() / 1000.0);
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
            String modifiedSinceStr = request.getHeader("If-Modified-Since");
            if (modifiedSinceStr != null) {
                try {
                    Date modifiedSince = sdf.parse(modifiedSinceStr);
                    long modifiedSinceSecs = (long)Math.floor((double)modifiedSince.getTime() / 1000.0);
                    if (modifiedSinceSecs >= lastModifiedSecs) {
                        content.getStream().close();
                        response.setStatus(304);
                        response.setContentLength(0);
                        return;
                    }
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            response.setHeader("Last-Modified", sdf.format(lastModifiedSecs * 1000L));
        }
        if ((contentType = content.getMimeType()) == null) {
            contentType = "application/octet-stream";
        }
        if (offset == null && length == null) {
            response.setStatus(200);
        } else {
            BrowserBindingUtils.setStatus(request, response, 206);
        }
        response.setContentType(contentType);
        String contentFilename = content.getFileName();
        if (contentFilename == null) {
            contentFilename = "content";
        }
        if (download) {
            response.setHeader("Content-Disposition", MimeHelper.encodeContentDisposition((String)"attachment", (String)contentFilename));
        } else {
            response.setHeader("Content-Disposition", MimeHelper.encodeContentDisposition((String)"inline", (String)contentFilename));
        }
        BufferedInputStream in = new BufferedInputStream(content.getStream(), 65536);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        byte[] buffer = new byte[65536];
        while ((b = ((InputStream)in).read(buffer)) > -1) {
            ((OutputStream)out).write(buffer, 0, b);
        }
        ((InputStream)in).close();
        ((OutputStream)out).flush();
    }

    public static void deleteObject(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        Boolean allVersions = HttpUtils.getBooleanParameter(request, "allVersions");
        service.deleteObject(repositoryId, objectId, allVersions, null);
        response.setStatus(200);
        BrowserBindingUtils.writeEmpty(request, response);
    }

    public static void deleteTree(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        Boolean allVersions = HttpUtils.getBooleanParameter(request, "allVersions");
        UnfileObject unfileObjects = HttpUtils.getEnumParameter(request, "unfileObjects", UnfileObject.class);
        Boolean continueOnFailure = HttpUtils.getBooleanParameter(request, "continueOnFailure");
        FailedToDeleteData ftd = service.deleteTree(repositoryId, objectId, allVersions, unfileObjects, continueOnFailure, null);
        response.setStatus(200);
        if (ftd != null && ftd.getIds() != null && ftd.getIds().size() > 0) {
            JSONObject jsonObject = JSONConverter.convert((FailedToDeleteData)ftd);
            BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
            return;
        }
        BrowserBindingUtils.writeEmpty(request, response);
    }

    public static void deleteContentStream(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String changeToken = HttpUtils.getStringParameter(request, "changeToken");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        Holder objectIdHolder = new Holder((Object)objectId);
        Holder changeTokenHolder = changeToken == null ? null : new Holder((Object)changeToken);
        service.deleteContentStream(repositoryId, objectIdHolder, changeTokenHolder, null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        response.setStatus(200);
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void setContentStream(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String changeToken = HttpUtils.getStringParameter(request, "changeToken");
        Boolean overwriteFlag = HttpUtils.getBooleanParameter(request, "overwriteFlag");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        Holder objectIdHolder = new Holder((Object)objectId);
        Holder changeTokenHolder = changeToken == null ? null : new Holder((Object)changeToken);
        service.setContentStream(repositoryId, objectIdHolder, overwriteFlag, changeTokenHolder, BrowserBindingUtils.createContentStream(request), null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        String location = AtomPubUtils.compileUrl(AtomPubUtils.compileBaseUrl(request, repositoryId), "content", newObjectId);
        BrowserBindingUtils.setStatus(request, response, 201);
        response.setHeader("Location", location);
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void moveObject(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String targetFolderId = HttpUtils.getStringParameter(request, "targetFolderId");
        String sourceFolderId = HttpUtils.getStringParameter(request, "sourceFolderId");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        Holder objectIdHolder = new Holder((Object)objectId);
        service.moveObject(repositoryId, objectIdHolder, targetFolderId, sourceFolderId, null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        String location = AtomPubUtils.compileUrl(AtomPubUtils.compileBaseUrl(request, repositoryId), "content", newObjectId);
        BrowserBindingUtils.setStatus(request, response, 201);
        response.setHeader("Location", location);
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }
}

