/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public class RelationshipService {
    public static void getObjectRelationships(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        Boolean includeSubRelationshipTypes = HttpUtils.getBooleanParameter(request, "includeSubRelationshipTypes");
        RelationshipDirection relationshipDirection = HttpUtils.getEnumParameter(request, "relationshipDirection", RelationshipDirection.class);
        String typeId = HttpUtils.getStringParameter(request, "typeId");
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        BigInteger skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount");
        boolean succinct = HttpUtils.getBooleanParameter(request, "succinct", false);
        ObjectList relationships = service.getObjectRelationships(repositoryId, objectId, includeSubRelationshipTypes, relationshipDirection, typeId, renditionFilter, includeAllowableActions, maxItems, skipCount, null);
        if (relationships == null) {
            throw new CmisRuntimeException("Relationships are null!");
        }
        ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
        JSONObject jsonChildren = JSONConverter.convert((ObjectList)relationships, (TypeCache)typeCache, (boolean)false, (boolean)succinct);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonChildren, request, response);
    }
}

