/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import com.sun.xml.ws.developer.StreamingAttachment;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAllowableActionsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisContentStreamType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRenditionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteTreeResponse;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumUnfileObject;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumVersioningState;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectServicePort;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MTOM
@StreamingAttachment(parseEagerly=true, memoryThreshold=0x4B4000L)
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectServicePort")
public class ObjectService
extends AbstractService
implements ObjectServicePort {
    @Resource
    public WebServiceContext wsContext;

    public void createDocument(String repositoryId, CmisPropertiesType properties, String folderId, CmisContentStreamType contentStream, EnumVersioningState versioningState, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            String id = service.createDocument(repositoryId, Converter.convert((CmisPropertiesType)properties), folderId, Converter.convert((CmisContentStreamType)contentStream), (VersioningState)Converter.convert(VersioningState.class, (Enum)versioningState), policies, Converter.convert((CmisAccessControlListType)addAces, null), Converter.convert((CmisAccessControlListType)removeAces, null), extData);
            if (objectId != null) {
                objectId.value = id;
            }
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void createDocumentFromSource(String repositoryId, String sourceId, CmisPropertiesType properties, String folderId, EnumVersioningState versioningState, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            String id = service.createDocumentFromSource(repositoryId, sourceId, Converter.convert((CmisPropertiesType)properties), folderId, (VersioningState)Converter.convert(VersioningState.class, (Enum)versioningState), policies, Converter.convert((CmisAccessControlListType)addAces, null), Converter.convert((CmisAccessControlListType)removeAces, null), extData);
            if (objectId != null) {
                objectId.value = id;
            }
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void createFolder(String repositoryId, CmisPropertiesType properties, String folderId, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            String id = service.createFolder(repositoryId, Converter.convert((CmisPropertiesType)properties), folderId, policies, Converter.convert((CmisAccessControlListType)addAces, null), Converter.convert((CmisAccessControlListType)removeAces, null), extData);
            if (objectId != null) {
                objectId.value = id;
            }
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void createPolicy(String repositoryId, CmisPropertiesType properties, String folderId, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            String id = service.createPolicy(repositoryId, Converter.convert((CmisPropertiesType)properties), folderId, policies, Converter.convert((CmisAccessControlListType)addAces, null), Converter.convert((CmisAccessControlListType)removeAces, null), extData);
            if (objectId != null) {
                objectId.value = id;
            }
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void createRelationship(String repositoryId, CmisPropertiesType properties, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            String id = service.createRelationship(repositoryId, Converter.convert((CmisPropertiesType)properties), policies, Converter.convert((CmisAccessControlListType)addAces, null), Converter.convert((CmisAccessControlListType)removeAces, null), extData);
            if (objectId != null) {
                objectId.value = id;
            }
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Holder<CmisExtensionType> extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder = Converter.convertHolder(objectId);
            org.apache.chemistry.opencmis.commons.spi.Holder changeTokenHolder = Converter.convertHolder(changeToken);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            service.deleteContentStream(repositoryId, objectIdHolder, changeTokenHolder, extData);
            Converter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            Converter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)changeTokenHolder, changeToken);
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, Holder<CmisExtensionType> extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            service.deleteObject(repositoryId, objectId, allVersions, extData);
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public DeleteTreeResponse.FailedToDelete deleteTree(String repositoryId, String folderId, Boolean allVersions, EnumUnfileObject unfileObjects, Boolean continueOnFailure, CmisExtensionType extension) throws CmisException {
        DeleteTreeResponse.FailedToDelete failedToDelete;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            failedToDelete = Converter.convert((FailedToDeleteData)service.deleteTree(repositoryId, folderId, allVersions, (UnfileObject)Converter.convert(UnfileObject.class, (Enum)unfileObjects), continueOnFailure, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return failedToDelete;
    }

    public CmisAllowableActionsType getAllowableActions(String repositoryId, String objectId, CmisExtensionType extension) throws CmisException {
        CmisAllowableActionsType cmisAllowableActionsType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisAllowableActionsType = Converter.convert((AllowableActions)service.getAllowableActions(repositoryId, objectId, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisAllowableActionsType;
    }

    public CmisContentStreamType getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, CmisExtensionType extension) throws CmisException {
        CmisContentStreamType cmisContentStreamType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisContentStreamType = Converter.convert((ContentStream)service.getContentStream(repositoryId, objectId, streamId, offset, length, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisContentStreamType;
    }

    public CmisObjectType getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, CmisExtensionType extension) throws CmisException {
        CmisObjectType cmisObjectType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisObjectType = Converter.convert((ObjectData)service.getObject(repositoryId, objectId, filter, includeAllowableActions, (IncludeRelationships)Converter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeAcl, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectType;
    }

    public CmisObjectType getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, CmisExtensionType extension) throws CmisException {
        CmisObjectType cmisObjectType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisObjectType = Converter.convert((ObjectData)service.getObjectByPath(repositoryId, path, filter, includeAllowableActions, (IncludeRelationships)Converter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeAcl, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectType;
    }

    public CmisPropertiesType getProperties(String repositoryId, String objectId, String filter, CmisExtensionType extension) throws CmisException {
        CmisPropertiesType cmisPropertiesType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisPropertiesType = Converter.convert((Properties)service.getProperties(repositoryId, objectId, filter, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisPropertiesType;
    }

    public List<CmisRenditionType> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisRenditionType> arrayList;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ArrayList<CmisRenditionType> result = new ArrayList<CmisRenditionType>();
            List renditionList = service.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, Converter.convert((CmisExtensionType)extension));
            if (renditionList != null) {
                for (RenditionData rendition : renditionList) {
                    result.add(Converter.convert((RenditionData)rendition));
                }
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, Holder<CmisExtensionType> extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder = Converter.convertHolder(objectId);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            service.moveObject(repositoryId, objectIdHolder, targetFolderId, sourceFolderId, extData);
            Converter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, CmisContentStreamType contentStream, Holder<CmisExtensionType> extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder = Converter.convertHolder(objectId);
            org.apache.chemistry.opencmis.commons.spi.Holder changeTokenHolder = Converter.convertHolder(changeToken);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            service.setContentStream(repositoryId, objectIdHolder, overwriteFlag, changeTokenHolder, Converter.convert((CmisContentStreamType)contentStream), extData);
            Converter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            Converter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)changeTokenHolder, changeToken);
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, CmisPropertiesType properties, Holder<CmisExtensionType> extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder = Converter.convertHolder(objectId);
            org.apache.chemistry.opencmis.commons.spi.Holder changeTokenHolder = Converter.convertHolder(changeToken);
            ExtensionsData extData = Converter.convertExtensionHolder(extension);
            service.updateProperties(repositoryId, objectIdHolder, changeTokenHolder, Converter.convert((CmisPropertiesType)properties), extData);
            Converter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            Converter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)changeTokenHolder, changeToken);
            Converter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }
}

