/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStringHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> parameters = new HashMap<String, String[]>();

    public QueryStringHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.parseFormData(request.getQueryString());
    }

    protected void parseFormData(String queryString) throws IOException {
        String[] nameValuePairs;
        if (queryString == null || queryString.length() < 3) {
            return;
        }
        for (String nameValuePair : nameValuePairs = queryString.split("&")) {
            String name;
            int x = nameValuePair.indexOf(61);
            if (x > 0) {
                name = URLDecoder.decode(nameValuePair.substring(0, x), "UTF-8");
                String value = x == nameValuePair.length() - 1 ? "" : URLDecoder.decode(nameValuePair.substring(x + 1), "UTF-8");
                this.addParameter(name, value);
                continue;
            }
            name = URLDecoder.decode(nameValuePair, "UTF-8");
            this.addParameter(name, null);
        }
    }

    protected void addParameter(String name, String value) {
        String[] values = this.parameters.get(name);
        if (values == null) {
            this.parameters.put(name, new String[]{value});
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            this.parameters.put(name, newValues);
        }
    }

    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }
}

