/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Component;
import java.awt.Container;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import org.apache.chemistry.opencmis.workbench.AbstractLoginTab;

public abstract class AbstractSpringLoginTab
extends AbstractLoginTab {
    private static final long serialVersionUID = 1L;

    protected JTextField createTextField(Container pane, String label) {
        JTextField textField = new JTextField(60);
        JLabel textLabel = new JLabel(label, 11);
        textLabel.setLabelFor(textField);
        pane.add(textLabel);
        pane.add(textField);
        return textField;
    }

    protected JFormattedTextField createIntegerField(Container pane, String label) {
        NumberFormat format = NumberFormat.getIntegerInstance();
        JFormattedTextField intField = new JFormattedTextField(format);
        JLabel intLabel = new JLabel(label, 11);
        intLabel.setLabelFor(intField);
        pane.add(intLabel);
        pane.add(intField);
        return intField;
    }

    protected JPasswordField createPasswordField(Container pane, String label) {
        JPasswordField textField = new JPasswordField(60);
        JLabel textLabel = new JLabel(label, 11);
        textLabel.setLabelFor(textField);
        pane.add(textLabel);
        pane.add(textField);
        return textField;
    }

    private SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    protected void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, this.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = this.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, this.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = this.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        layout.getConstraints(parent).setConstraint("East", x);
    }
}

