/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.icons.AddIcon;
import org.apache.chemistry.opencmis.workbench.icons.RemoveIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class AclEditorFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "ACL Editor";
    private static final Icon ICON_ADD = new AddIcon(16, 16);
    private final ClientModel model;
    private final CmisObject object;
    private final AceList addAceList;
    private final AceList removeAceList;
    private JRadioButton propagationRepositoryButton;
    private JRadioButton propagationObjectOnlyButton;
    private JRadioButton propagationPropagteButton;

    public AclEditorFrame(ClientModel model, CmisObject object) {
        this.model = model;
        this.object = object;
        ArrayList<String> princiaplList = new ArrayList<String>();
        try {
            String anyone;
            Object anonymous;
            princiaplList.add("");
            princiaplList.add("cmis:user");
            String user = model.getClientSession().getSessionParameters().get("org.apache.chemistry.opencmis.user");
            if (user != null && user.length() > 0) {
                princiaplList.add(user);
            }
            if ((anonymous = model.getRepositoryInfo().getPrincipalIdAnonymous()) != null && ((String)anonymous).length() > 0) {
                princiaplList.add((String)anonymous);
            }
            if ((anyone = model.getRepositoryInfo().getPrincipalIdAnyone()) != null && anyone.length() > 0) {
                princiaplList.add(anyone);
            }
            if (object.getAcl() != null && object.getAcl().getAces() != null) {
                ArrayList<String> aclPrinciaplList = new ArrayList<String>();
                for (Ace ace : object.getAcl().getAces()) {
                    String pid = ace.getPrincipalId();
                    if (princiaplList.contains(pid) || aclPrinciaplList.contains(pid)) continue;
                    aclPrinciaplList.add(pid);
                }
                Collections.sort(aclPrinciaplList);
                princiaplList.addAll(aclPrinciaplList);
            }
        }
        catch (Exception ex) {
            princiaplList = new ArrayList();
            princiaplList.add("");
            princiaplList.add("cmis:user");
        }
        ArrayList<String> permissionsList = new ArrayList<String>();
        try {
            permissionsList.add("");
            for (PermissionDefinition pd : model.getRepositoryInfo().getAclCapabilities().getPermissions()) {
                permissionsList.add(pd.getId());
            }
        }
        catch (Exception ex) {
            permissionsList = new ArrayList();
            permissionsList.add("");
            permissionsList.add("cmis:read");
            permissionsList.add("cmis:write");
            permissionsList.add("cmis:all");
        }
        this.addAceList = new AceList(princiaplList, permissionsList);
        this.removeAceList = new AceList(princiaplList, permissionsList);
        this.createGUI();
    }

    private void createGUI() {
        this.setTitle(WINDOW_TITLE);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension((int)(screenSize.getWidth() / 1.5), (int)(screenSize.getHeight() / 1.5)));
        this.setMinimumSize(new Dimension(300, 120));
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        Font labelFont = UIManager.getFont("Label.font");
        Font boldFont = labelFont.deriveFont(1, labelFont.getSize2D() * 1.2f);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel nameLabel = new JLabel(this.object.getName());
        nameLabel.setFont(boldFont);
        topPanel.add(nameLabel);
        topPanel.add(new JLabel(this.object.getId()));
        this.add((Component)topPanel, "First");
        JPanel addAcePanel = this.createAceListPanel("Add ACEs", this.addAceList);
        JPanel removeAcePanel = this.createAceListPanel("Remove ACEs", this.removeAceList);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JSplitPane aceSplitPanel = new JSplitPane(1, new JScrollPane(addAcePanel), new JScrollPane(removeAcePanel));
        centerPanel.add((Component)aceSplitPanel, "Center");
        this.propagationRepositoryButton = new JRadioButton("repository determined", true);
        this.propagationObjectOnlyButton = new JRadioButton("object only", false);
        this.propagationPropagteButton = new JRadioButton("propagate", false);
        try {
            if (this.model.getRepositoryInfo().getAclCapabilities().getAclPropagation() == AclPropagation.OBJECTONLY) {
                this.propagationPropagteButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            this.propagationPropagteButton.setEnabled(true);
        }
        ButtonGroup propagtionGroup = new ButtonGroup();
        propagtionGroup.add(this.propagationRepositoryButton);
        propagtionGroup.add(this.propagationObjectOnlyButton);
        propagtionGroup.add(this.propagationPropagteButton);
        JPanel propagtionPanel = new JPanel(new FlowLayout(0));
        propagtionPanel.add(new JLabel("ACL Propagation:"));
        propagtionPanel.add(this.propagationRepositoryButton);
        propagtionPanel.add(this.propagationObjectOnlyButton);
        propagtionPanel.add(this.propagationPropagteButton);
        centerPanel.add((Component)propagtionPanel, "Last");
        this.add((Component)centerPanel, "Center");
        JButton updateButton = new JButton("Update");
        updateButton.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        updateButton.setDefaultCapable(true);
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (AclEditorFrame.this.doApply()) {
                    AclEditorFrame.this.dispose();
                }
            }
        });
        this.add((Component)updateButton, "Last");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        aceSplitPanel.setDividerLocation(0.5);
    }

    private JPanel createAceListPanel(String title, final AceList list) {
        Font labelFont = UIManager.getFont("Label.font");
        Font boldFont = labelFont.deriveFont(1, labelFont.getSize2D() * 1.2f);
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 3));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 2));
        topPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(boldFont);
        topPanel.add((Component)titleLabel, "Before");
        topPanel.add(Box.createHorizontalGlue());
        JButton addButton = new JButton(ICON_ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                list.addNewAce();
            }
        });
        topPanel.add((Component)addButton, "After");
        result.add(topPanel);
        result.add(list);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doApply() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            List<Ace> adds = this.addAceList.getAces();
            List<Ace> removes = this.removeAceList.getAces();
            if (adds != null || removes != null) {
                AclPropagation aclPropagation = AclPropagation.REPOSITORYDETERMINED;
                if (this.propagationObjectOnlyButton.isSelected()) {
                    aclPropagation = AclPropagation.OBJECTONLY;
                }
                if (this.propagationPropagteButton.isSelected()) {
                    aclPropagation = AclPropagation.PROPAGATE;
                }
                this.object.applyAcl(adds, removes, aclPropagation);
                this.model.reloadObject();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ClientHelper.showError(this, ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static class AceInputPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final Color BACKGROUND1 = UIManager.getColor("Table:\"Table.cellRenderer\".background");
        private static final Color BACKGROUND2 = UIManager.getColor("Table.alternateRowColor");
        private static final Color LINE = new Color(184, 184, 184);
        private static final Icon ICON_REMOVE = new RemoveIcon(16, 16);
        private static final Icon ICON_REMOVE_DISABLED = new RemoveIcon(16, 16, false);
        private final List<String> permissions;
        private int position;
        private final JComboBox<String> principalBox;
        private final JPanel permissionsPanel;
        private final List<JComboBox<String>> permissionBoxes;

        public AceInputPanel(final AceList list, List<String> principals, List<String> permissions, int position) {
            this.permissions = permissions;
            this.updatePosition(position);
            this.setLayout(new GridBagLayout());
            this.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createCompoundBorder(WorkbenchScale.scaleBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, LINE)), WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5)))));
            GridBagConstraints c = new GridBagConstraints();
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 21;
            c.gridy = 0;
            this.add((Component)new JLabel("Principal:"), c);
            c.gridy = 1;
            this.add((Component)new JSeparator(0), c);
            c.gridy = 2;
            this.add((Component)new JLabel("Permissions:"), c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 21;
            this.principalBox = new JComboBox<String>(principals.toArray(new String[0]));
            this.principalBox.setEditable(true);
            this.principalBox.setPrototypeDisplayValue("1234567890123456789012345");
            c.gridy = 0;
            this.add(this.principalBox, c);
            c.gridy = 1;
            this.add((Component)new JSeparator(0), c);
            this.permissionsPanel = new JPanel();
            this.permissionsPanel.setLayout(new BoxLayout(this.permissionsPanel, 1));
            this.permissionsPanel.setOpaque(false);
            this.permissionBoxes = new ArrayList<JComboBox<String>>();
            this.updatePermissionsPanel(false);
            c.gridy = 2;
            this.add((Component)this.permissionsPanel, c);
            c.gridx = 2;
            c.weightx = 1.0;
            c.fill = 0;
            c.anchor = 22;
            c.gridy = 0;
            JButton removeButton = new JButton(ICON_REMOVE);
            removeButton.setDisabledIcon(ICON_REMOVE_DISABLED);
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    list.removeAce(AceInputPanel.this.getPosition());
                }
            });
            this.add((Component)removeButton, c);
        }

        private JComboBox<String> createPermissionBox() {
            JComboBox<String> result = new JComboBox<String>(this.permissions.toArray(new String[0]));
            result.setEditable(true);
            result.setPrototypeDisplayValue("1234567890123456789012345");
            JTextComponent editor = (JTextComponent)result.getEditor().getEditorComponent();
            editor.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent event) {
                    AceInputPanel.this.updatePermissionsPanel(true);
                }
            });
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                        AceInputPanel.this.updatePermissionsPanel(true);
                    }
                }
            });
            return result;
        }

        private void updatePermissionsPanel(boolean focus) {
            boolean changed = false;
            if (!this.permissionBoxes.isEmpty()) {
                int i = 0;
                while (i < this.permissionBoxes.size() - 1) {
                    if (this.permissionBoxes.get(i).getSelectedItem().toString().trim().length() == 0) {
                        this.permissionBoxes.remove(i);
                        changed = true;
                        continue;
                    }
                    ++i;
                }
                if (this.permissionBoxes.get(this.permissionBoxes.size() - 1).getSelectedItem().toString().trim().length() > 0) {
                    this.permissionBoxes.add(this.createPermissionBox());
                    changed = true;
                }
            } else {
                this.permissionBoxes.add(this.createPermissionBox());
                changed = true;
            }
            if (changed) {
                this.permissionsPanel.removeAll();
                for (JComboBox<String> box : this.permissionBoxes) {
                    this.permissionsPanel.add(box);
                }
                this.revalidate();
                if (focus) {
                    this.permissionBoxes.get(this.permissionBoxes.size() - 1).requestFocusInWindow();
                }
            }
        }

        private void updatePosition(int position) {
            this.position = position;
            this.setBackground(position % 2 == 0 ? BACKGROUND1 : BACKGROUND2);
        }

        public int getPosition() {
            return this.position;
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Short.MAX_VALUE, this.getPreferredSize().height);
        }

        public Ace getAce() {
            ArrayList<String> permissionsList = new ArrayList<String>();
            for (JComboBox<String> box : this.permissionBoxes) {
                String permission = box.getSelectedItem().toString().trim();
                if (permission.length() <= 0) continue;
                permissionsList.add(permission);
            }
            return new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(this.principalBox.getSelectedItem().toString()), permissionsList);
        }
    }

    private static class AceList
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final List<AceInputPanel> panels = new ArrayList<AceInputPanel>();
        private final List<String> principals;
        private final List<String> permissions;

        public AceList(List<String> principals, List<String> permissions) {
            this.principals = principals;
            this.permissions = permissions;
            this.setLayout(new BoxLayout(this, 1));
        }

        public synchronized void addNewAce() {
            AceInputPanel acePanel = new AceInputPanel(this, this.principals, this.permissions, this.panels.size());
            this.panels.add(acePanel);
            this.add(acePanel);
        }

        public synchronized void removeAce(int position) {
            this.panels.remove(position);
            for (int i = position; i < this.panels.size(); ++i) {
                this.panels.get(i).updatePosition(i);
            }
            this.removeAll();
            for (AceInputPanel p : this.panels) {
                this.add(p);
            }
            this.revalidate();
        }

        public synchronized List<Ace> getAces() {
            ArrayList<Ace> result = new ArrayList<Ace>();
            for (AceInputPanel p : this.panels) {
                result.add(p.getAce());
            }
            return result.isEmpty() ? null : result;
        }
    }
}

