/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Container;
import java.awt.Dimension;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.workbench.AbstractSpringLoginTab;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.model.ClientSession;

public class BasicLoginTab
extends AbstractSpringLoginTab {
    private static final long serialVersionUID = 1L;
    public static final String SYSPROP_URL = "cmis.workbench.url";
    public static final String SYSPROP_BINDING = "cmis.workbench.binding";
    public static final String SYSPROP_AUTHENTICATION = "cmis.workbench.authentication";
    public static final String SYSPROP_COMPRESSION = "cmis.workbench.compression";
    public static final String SYSPROP_CLIENTCOMPRESSION = "cmis.workbench.clientcompression";
    public static final String SYSPROP_COOKIES = "cmis.workbench.cookies";
    public static final String SYSPROP_CONN_TIMEOUT = "cmis.workbench.connecttimeout";
    public static final String SYSPROP_READ_TIMEOUT = "cmis.workbench.readtimeout";
    public static final String SYSPROP_USER = "cmis.workbench.user";
    public static final String SYSPROP_PASSWORD = "cmis.workbench.password";
    public static final String SYSPROP_CSRF_HEADER = "cmis.workbench.csrfheader";
    private JTextField urlField;
    private JRadioButton bindingAtomButton;
    private JRadioButton bindingWebServicesButton;
    private JRadioButton bindingBrowserButton;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JRadioButton authenticationNoneButton;
    private JRadioButton authenticationStandardButton;
    private JRadioButton authenticationNTLMButton;
    private JRadioButton authenticationOAuthButton;
    private JRadioButton compressionOnButton;
    private JRadioButton compressionOffButton;
    private JRadioButton clientCompressionOnButton;
    private JRadioButton clientCompressionOffButton;
    private JRadioButton cookiesOnButton;
    private JRadioButton cookiesOffButton;
    private JTextField csrfHeaderField;
    private JFormattedTextField connectTimeoutField;
    private JFormattedTextField readTimeoutField;

    public BasicLoginTab() {
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(new SpringLayout());
        this.urlField = this.createTextField(this, "URL:");
        this.urlField.setText(System.getProperty(SYSPROP_URL, "").trim());
        this.createBindingButtons(this);
        this.usernameField = this.createTextField(this, "Username:");
        this.usernameField.setText(System.getProperty(SYSPROP_USER, ""));
        this.passwordField = this.createPasswordField(this, "Password:");
        this.passwordField.setText(System.getProperty(SYSPROP_PASSWORD, ""));
        this.createAuthenticationButtons(this);
        this.createCompressionButtons(this);
        this.createClientCompressionButtons(this);
        this.createCookieButtons(this);
        this.csrfHeaderField = this.createTextField(this, "CSRF Header:");
        this.csrfHeaderField.setText(System.getProperty(SYSPROP_CSRF_HEADER, ""));
        this.connectTimeoutField = this.createIntegerField(this, "Connect timeout (secs):");
        try {
            this.connectTimeoutField.setValue(Long.parseLong(System.getProperty(SYSPROP_CONN_TIMEOUT, "30")));
        }
        catch (NumberFormatException e) {
            this.connectTimeoutField.setValue(30);
        }
        this.readTimeoutField = this.createIntegerField(this, "Read timeout (secs):");
        try {
            this.readTimeoutField.setValue(Long.parseLong(System.getProperty(SYSPROP_READ_TIMEOUT, "600")));
        }
        catch (NumberFormatException e) {
            this.readTimeoutField.setValue(600);
        }
        this.makeCompactGrid(this, 11, 2, 5, 10, 5, 5);
    }

    private void createBindingButtons(Container pane) {
        JPanel bindingContainer = new JPanel();
        bindingContainer.setLayout(new BoxLayout(bindingContainer, 2));
        char bc = System.getProperty(SYSPROP_BINDING, "atom").toLowerCase(Locale.ENGLISH).charAt(0);
        boolean atom = bc == 'a';
        boolean ws = bc == 'w';
        boolean browser = bc == 'b';
        this.bindingAtomButton = new JRadioButton("AtomPub", atom);
        this.bindingWebServicesButton = new JRadioButton("Web Services", ws);
        this.bindingBrowserButton = new JRadioButton("Browser", browser);
        ButtonGroup bindingGroup = new ButtonGroup();
        bindingGroup.add(this.bindingAtomButton);
        bindingGroup.add(this.bindingWebServicesButton);
        bindingGroup.add(this.bindingBrowserButton);
        bindingContainer.add(this.bindingAtomButton);
        bindingContainer.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(10, 0))));
        bindingContainer.add(this.bindingWebServicesButton);
        bindingContainer.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(10, 0))));
        bindingContainer.add(this.bindingBrowserButton);
        JLabel bindingLabel = new JLabel("Binding:", 11);
        pane.add(bindingLabel);
        pane.add(bindingContainer);
    }

    private void createAuthenticationButtons(Container pane) {
        JPanel authenticationContainer = new JPanel();
        authenticationContainer.setLayout(new BoxLayout(authenticationContainer, 2));
        boolean standard = System.getProperty(SYSPROP_AUTHENTICATION, "standard").toLowerCase(Locale.ENGLISH).equals("standard");
        boolean ntlm = System.getProperty(SYSPROP_AUTHENTICATION, "").toLowerCase(Locale.ENGLISH).equals("ntlm");
        boolean oauth = System.getProperty(SYSPROP_AUTHENTICATION, "").toLowerCase(Locale.ENGLISH).equals("oauth");
        boolean none = !standard && !ntlm;
        this.authenticationNoneButton = new JRadioButton("None", none);
        this.authenticationStandardButton = new JRadioButton("Standard", standard);
        this.authenticationNTLMButton = new JRadioButton("NTLM", ntlm);
        this.authenticationOAuthButton = new JRadioButton("OAuth 2.0 (Bearer Token)", oauth);
        ButtonGroup authenticationGroup = new ButtonGroup();
        authenticationGroup.add(this.authenticationNoneButton);
        authenticationGroup.add(this.authenticationStandardButton);
        authenticationGroup.add(this.authenticationNTLMButton);
        authenticationGroup.add(this.authenticationOAuthButton);
        authenticationContainer.add(this.authenticationNoneButton);
        authenticationContainer.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(10, 0))));
        authenticationContainer.add(this.authenticationStandardButton);
        authenticationContainer.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(10, 0))));
        authenticationContainer.add(this.authenticationNTLMButton);
        authenticationContainer.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(10, 0))));
        authenticationContainer.add(this.authenticationOAuthButton);
        JLabel authenticatioLabel = new JLabel("Authentication:", 11);
        pane.add(authenticatioLabel);
        pane.add(authenticationContainer);
    }

    private void createCompressionButtons(Container pane) {
        JPanel compressionContainer = new JPanel();
        compressionContainer.setLayout(new BoxLayout(compressionContainer, 2));
        boolean compression = !System.getProperty(SYSPROP_COMPRESSION, "on").equalsIgnoreCase("off");
        this.compressionOnButton = new JRadioButton("On", compression);
        this.compressionOffButton = new JRadioButton("Off", !compression);
        ButtonGroup compressionGroup = new ButtonGroup();
        compressionGroup.add(this.compressionOnButton);
        compressionGroup.add(this.compressionOffButton);
        compressionContainer.add(this.compressionOnButton);
        compressionContainer.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(10, 0))));
        compressionContainer.add(this.compressionOffButton);
        JLabel compressionLabel = new JLabel("Compression:", 11);
        pane.add(compressionLabel);
        pane.add(compressionContainer);
    }

    private void createClientCompressionButtons(Container pane) {
        JPanel clientCompressionContainer = new JPanel();
        clientCompressionContainer.setLayout(new BoxLayout(clientCompressionContainer, 2));
        boolean clientCompression = System.getProperty(SYSPROP_CLIENTCOMPRESSION, "off").equalsIgnoreCase("on");
        this.clientCompressionOnButton = new JRadioButton("On", clientCompression);
        this.clientCompressionOffButton = new JRadioButton("Off", !clientCompression);
        ButtonGroup clientCompressionGroup = new ButtonGroup();
        clientCompressionGroup.add(this.clientCompressionOnButton);
        clientCompressionGroup.add(this.clientCompressionOffButton);
        clientCompressionContainer.add(this.clientCompressionOnButton);
        clientCompressionContainer.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(10, 0))));
        clientCompressionContainer.add(this.clientCompressionOffButton);
        JLabel clientCompressionLabel = new JLabel("Client Compression:", 11);
        pane.add(clientCompressionLabel);
        pane.add(clientCompressionContainer);
    }

    private void createCookieButtons(Container pane) {
        JPanel cookiesContainer = new JPanel();
        cookiesContainer.setLayout(new BoxLayout(cookiesContainer, 2));
        boolean cookies = System.getProperty(SYSPROP_COOKIES, "on").equalsIgnoreCase("on");
        this.cookiesOnButton = new JRadioButton("On", cookies);
        this.cookiesOffButton = new JRadioButton("Off", !cookies);
        ButtonGroup cookiesGroup = new ButtonGroup();
        cookiesGroup.add(this.cookiesOnButton);
        cookiesGroup.add(this.cookiesOffButton);
        cookiesContainer.add(this.cookiesOnButton);
        cookiesContainer.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(10, 0))));
        cookiesContainer.add(this.cookiesOffButton);
        JLabel cookiesLabel = new JLabel("Cookies:", 11);
        pane.add(cookiesLabel);
        pane.add(cookiesContainer);
    }

    @Override
    public String getTabTitle() {
        return "Basic";
    }

    @Override
    public Map<String, String> getSessionParameters() {
        String url = this.urlField.getText().trim();
        BindingType binding = BindingType.ATOMPUB;
        if (this.bindingWebServicesButton.isSelected()) {
            binding = BindingType.WEBSERVICES;
        } else if (this.bindingBrowserButton.isSelected()) {
            binding = BindingType.BROWSER;
        }
        String username = this.usernameField.getText();
        String password = new String(this.passwordField.getPassword());
        ClientSession.Authentication authentication = ClientSession.Authentication.NONE;
        if (this.authenticationStandardButton.isSelected()) {
            authentication = ClientSession.Authentication.STANDARD;
        } else if (this.authenticationNTLMButton.isSelected()) {
            authentication = ClientSession.Authentication.NTLM;
        } else if (this.authenticationOAuthButton.isSelected()) {
            authentication = ClientSession.Authentication.OAUTH_BEARER;
        }
        long connectTimeout = 0L;
        if (this.connectTimeoutField.getValue() instanceof Number && (connectTimeout = ((Number)this.connectTimeoutField.getValue()).longValue() * 1000L) < 0L) {
            this.connectTimeoutField.setValue(0);
            connectTimeout = 0L;
        }
        long readTimeout = 0L;
        if (this.readTimeoutField.getValue() instanceof Number && (readTimeout = ((Number)this.readTimeoutField.getValue()).longValue() * 1000L) < 0L) {
            this.readTimeoutField.setValue(0);
            readTimeout = 0L;
        }
        return ClientSession.createSessionParameters(url, binding, username, password, authentication, this.compressionOnButton.isSelected(), this.clientCompressionOnButton.isSelected(), this.cookiesOnButton.isSelected(), this.csrfHeaderField.getText(), connectTimeout, readTimeout);
    }

    @Override
    public boolean transferSessionParametersToExpertTab() {
        return true;
    }
}

