/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.CollectionRenderer;
import org.apache.chemistry.opencmis.workbench.swing.GregorianCalendarRenderer;

public class ChangeLogFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "CMIS Change Log";
    private final ClientModel model;
    private JTextField changeLogTokenField;
    private ChangeLogTable changeLogTable;

    public ChangeLogFrame(ClientModel model) {
        this.model = model;
        this.createGUI();
    }

    private void createGUI() {
        this.setTitle("CMIS Change Log - " + this.model.getRepositoryName());
        this.setIconImages(ClientHelper.getCmisIconImages());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension((int)(screenSize.getWidth() / 3.0), (int)(screenSize.getHeight() / 1.5)));
        this.setMinimumSize(new Dimension(200, 60));
        this.setLayout(new BorderLayout());
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        inputPanel.add((Component)new JLabel("Change Log Token: "), "Before");
        this.changeLogTokenField = new JTextField();
        try {
            this.changeLogTokenField.setText(this.model.getRepositoryInfo().getLatestChangeLogToken());
        }
        catch (Exception e) {
            this.changeLogTokenField.setText("");
        }
        inputPanel.add((Component)this.changeLogTokenField, "Center");
        JButton loadButton = new JButton("Load");
        loadButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                String changeLogToken = ChangeLogFrame.this.changeLogTokenField.getText();
                if (changeLogToken.trim().length() == 0) {
                    changeLogToken = null;
                }
                ChangeEvents events = null;
                try {
                    ChangeLogFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    events = ChangeLogFrame.this.model.getClientSession().getSession().getContentChanges(changeLogToken, true, 1000L);
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                    return;
                }
                finally {
                    ChangeLogFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                ChangeLogFrame.this.changeLogTable.setChangeEvents(events.getChangeEvents());
                ChangeLogFrame.this.changeLogTokenField.setText(events.getLatestChangeLogToken() == null ? "" : events.getLatestChangeLogToken());
            }
        });
        inputPanel.add((Component)loadButton, "After");
        this.getRootPane().setDefaultButton(loadButton);
        this.add((Component)inputPanel, "First");
        this.changeLogTable = new ChangeLogTable();
        this.add((Component)new JScrollPane(this.changeLogTable), "Center");
        ClientHelper.installEscapeBinding(this, this.getRootPane(), true);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    static class ChangeLogTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private static final String[] COLUMN_NAMES = new String[]{"Change Type", "Object Id", "Change Time", "Properties"};
        private static final int[] COLUMN_WIDTHS = new int[]{100, 200, 200, 400};
        private List<ChangeEvent> changeEvents;

        public ChangeLogTable() {
            this.setDefaultRenderer(GregorianCalendar.class, new GregorianCalendarRenderer());
            this.setDefaultRenderer(Collection.class, new CollectionRenderer());
            this.setModel(new ChangeLogTableModel(this));
            this.setAutoResizeMode(0);
            this.setAutoCreateRowSorter(true);
            for (int i = 0; i < COLUMN_WIDTHS.length; ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setPreferredWidth(WorkbenchScale.scaleInt(COLUMN_WIDTHS[i]));
            }
            this.setRowHeight((int)((double)this.getFontMetrics(this.getFont()).getHeight() * 1.1));
            this.setFillsViewportHeight(true);
        }

        public void setChangeEvents(List<ChangeEvent> changeEvents) {
            this.changeEvents = changeEvents;
            ((AbstractTableModel)this.getModel()).fireTableDataChanged();
        }

        public List<ChangeEvent> getChangeEvents() {
            return this.changeEvents;
        }

        static class ChangeLogTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private final ChangeLogTable table;

            public ChangeLogTableModel(ChangeLogTable table) {
                this.table = table;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return COLUMN_NAMES[columnIndex];
            }

            @Override
            public int getColumnCount() {
                return COLUMN_NAMES.length;
            }

            @Override
            public int getRowCount() {
                if (this.table.getChangeEvents() == null) {
                    return 0;
                }
                return this.table.getChangeEvents().size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                ChangeEvent event = this.table.getChangeEvents().get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return event.getChangeType() == null ? "?" : event.getChangeType().value();
                    }
                    case 1: {
                        return event.getObjectId() == null ? "?" : event.getObjectId();
                    }
                    case 2: {
                        return event.getChangeTime();
                    }
                    case 3: {
                        return event.getProperties().entrySet();
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 2) {
                    return GregorianCalendar.class;
                }
                if (columnIndex == 3) {
                    return Collection.class;
                }
                return super.getColumnClass(columnIndex);
            }
        }
    }
}

