/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.apache.chemistry.opencmis.workbench.ChangeLogFrame;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.CreateDocumentDialog;
import org.apache.chemistry.opencmis.workbench.CreateFolderDialog;
import org.apache.chemistry.opencmis.workbench.CreateItemDialog;
import org.apache.chemistry.opencmis.workbench.CreatePolicyDialog;
import org.apache.chemistry.opencmis.workbench.CreateRelationshipDialog;
import org.apache.chemistry.opencmis.workbench.FolderPanel;
import org.apache.chemistry.opencmis.workbench.InfoDialog;
import org.apache.chemistry.opencmis.workbench.LogFrame;
import org.apache.chemistry.opencmis.workbench.LoginDialog;
import org.apache.chemistry.opencmis.workbench.QueryFrame;
import org.apache.chemistry.opencmis.workbench.RepositoryInfoFrame;
import org.apache.chemistry.opencmis.workbench.TckDialog;
import org.apache.chemistry.opencmis.workbench.TypesFrame;
import org.apache.chemistry.opencmis.workbench.details.DetailsTabs;
import org.apache.chemistry.opencmis.workbench.icons.ChangeLogIcon;
import org.apache.chemistry.opencmis.workbench.icons.ConnectIcon;
import org.apache.chemistry.opencmis.workbench.icons.ConsoleIcon;
import org.apache.chemistry.opencmis.workbench.icons.CreateObjectIcon;
import org.apache.chemistry.opencmis.workbench.icons.InfoIcon;
import org.apache.chemistry.opencmis.workbench.icons.LogIcon;
import org.apache.chemistry.opencmis.workbench.icons.QueryIcon;
import org.apache.chemistry.opencmis.workbench.icons.RepositoryInfoIcon;
import org.apache.chemistry.opencmis.workbench.icons.TckIcon;
import org.apache.chemistry.opencmis.workbench.icons.TypesIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ClientFrame.class);
    private static final String SYSPROP_SCRIPTS = "cmis.workbench.scripts";
    private static final String WINDOW_TITLE = "CMIS Workbench";
    private static final int BUTTON_CONNECT = 0;
    private static final int BUTTON_REPOSITORY_INFO = 1;
    private static final int BUTTON_TYPES = 2;
    private static final int BUTTON_QUERY = 3;
    private static final int BUTTON_CHANGELOG = 4;
    private static final int BUTTON_CONSOLE = 5;
    private static final int BUTTON_TCK = 6;
    private static final int BUTTON_CREATE = 7;
    private static final int BUTTON_LOG = 8;
    private static final int BUTTON_INFO = 9;
    private static final String PREFS_X = "x";
    private static final String PREFS_Y = "y";
    private static final String PREFS_WIDTH = "width";
    private static final String PREFS_HEIGHT = "height";
    private static final String PREFS_DIV = "div";
    private static final String GROOVY_SCRIPT_FOLDER = "/scripts/";
    private static final String GROOVY_SCRIPT_LIBRARY = "script-library.properties";
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private LoginDialog loginDialog;
    private LogFrame logFrame;
    private InfoDialog infoDialog;
    private JToolBar toolBar;
    private JButton[] toolbarButton;
    private JPopupMenu toolbarConsolePopup;
    private JPopupMenu toolbarCreatePopup;
    private JMenuItem documentMenuItem;
    private JMenuItem itemMenuItem;
    private JMenuItem folderMenuItem;
    private JMenuItem relationshipMenuItem;
    private JMenuItem policyMenuItem;
    private JSplitPane split;
    private FolderPanel folderPanel;
    private DetailsTabs detailsTabs;
    private final ClientModel model = new ClientModel();

    public ClientFrame() {
        this.createGUI();
        this.showLoginForm();
    }

    private void createGUI() {
        this.setTitle(WINDOW_TITLE);
        this.setIconImages(ClientHelper.getCmisIconImages());
        if (ClientHelper.isMacOSX()) {
            try {
                Class<?> macAppClass = Class.forName("com.apple.eawt.Application");
                Method macAppGetApp = macAppClass.getMethod("getApplication", null);
                Iterator<ClientHelper.FileEntry> macApp = macAppGetApp.invoke(null, (Object[])null);
                ImageIcon icon = ClientHelper.getCmisIconImage();
                if (icon != null) {
                    try {
                        macAppClass.getMethod("setDockIconImage", Image.class).invoke((Object)macApp, icon.getImage());
                    }
                    catch (Exception e) {
                        LOG.debug("Could not set dock icon!", (Throwable)e);
                    }
                }
                try {
                    Class<?> fullscreenClass = Class.forName("com.apple.eawt.FullScreenUtilities");
                    fullscreenClass.getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE).invoke(fullscreenClass, this, true);
                }
                catch (Exception e) {
                    LOG.debug("Could not add fullscreen button!", (Throwable)e);
                }
            }
            catch (Exception e) {
                LOG.debug("Could not get com.apple.eawt.Application object!", (Throwable)e);
            }
        }
        this.setLayout(new BorderLayout());
        final ClientFrame thisFrame = this;
        this.loginDialog = new LoginDialog(this);
        this.logFrame = new LogFrame();
        this.infoDialog = new InfoDialog(this);
        Container pane = this.getContentPane();
        this.toolBar = new JToolBar("CMIS Toolbar", 0);
        this.toolbarButton = new JButton[10];
        this.toolbarButton[0] = new JButton("Connection", new ConnectIcon(20, 20));
        this.toolbarButton[0].setDisabledIcon(new ConnectIcon(20, 20, false));
        this.toolbarButton[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.showLoginForm();
            }
        });
        this.toolBar.add(this.toolbarButton[0]);
        this.toolBar.addSeparator();
        this.toolbarButton[1] = new JButton("Repository Info", new RepositoryInfoIcon(20, 20));
        this.toolbarButton[1].setDisabledIcon(new RepositoryInfoIcon(20, 20, false));
        this.toolbarButton[1].setEnabled(false);
        this.toolbarButton[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RepositoryInfoFrame(ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[1]);
        this.toolbarButton[2] = new JButton("Types", new TypesIcon(20, 20));
        this.toolbarButton[2].setDisabledIcon(new TypesIcon(20, 20, false));
        this.toolbarButton[2].setEnabled(false);
        this.toolbarButton[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TypesFrame(ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[2]);
        this.toolbarButton[3] = new JButton("Query", new QueryIcon(20, 20));
        this.toolbarButton[3].setDisabledIcon(new QueryIcon(20, 20, false));
        this.toolbarButton[3].setEnabled(false);
        this.toolbarButton[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new QueryFrame(ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[3]);
        this.toolbarButton[4] = new JButton("Change Log", new ChangeLogIcon(20, 20));
        this.toolbarButton[4].setDisabledIcon(new ChangeLogIcon(20, 20, false));
        this.toolbarButton[4].setEnabled(false);
        this.toolbarButton[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ChangeLogFrame(ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[4]);
        this.toolbarButton[5] = new JButton("Console", new ConsoleIcon(20, 20));
        this.toolbarButton[5].setDisabledIcon(new ConsoleIcon(20, 20, false));
        this.toolbarButton[5].setEnabled(false);
        this.toolbarButton[5].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.toolbarConsolePopup.show(ClientFrame.this.toolbarButton[5], 0, ClientFrame.this.toolbarButton[5].getHeight());
            }
        });
        this.toolBar.add(this.toolbarButton[5]);
        this.toolbarConsolePopup = new JPopupMenu();
        for (ClientHelper.FileEntry fe : this.readScriptLibrary()) {
            JMenuItem menuItem = new JMenuItem(fe.getName());
            final URI file = fe.getFile();
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientHelper.openConsole((Component)ClientFrame.this, ClientFrame.this.model, file);
                }
            });
            this.toolbarConsolePopup.add(menuItem);
        }
        this.toolbarButton[6] = new JButton("TCK", new TckIcon(20, 20));
        this.toolbarButton[6].setDisabledIcon(new TckIcon(20, 20, false));
        this.toolbarButton[6].setEnabled(false);
        this.toolbarButton[6].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TckDialog(thisFrame, ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[6]);
        this.toolBar.addSeparator();
        this.toolbarCreatePopup = new JPopupMenu();
        this.documentMenuItem = new JMenuItem("Document");
        this.documentMenuItem.setEnabled(true);
        this.toolbarCreatePopup.add(this.documentMenuItem);
        this.documentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new CreateDocumentDialog((Frame)thisFrame, ClientFrame.this.model);
            }
        });
        this.itemMenuItem = new JMenuItem("Item");
        this.itemMenuItem.setEnabled(false);
        this.toolbarCreatePopup.add(this.itemMenuItem);
        this.itemMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new CreateItemDialog((Frame)thisFrame, ClientFrame.this.model);
            }
        });
        this.folderMenuItem = new JMenuItem("Folder");
        this.folderMenuItem.setEnabled(true);
        this.toolbarCreatePopup.add(this.folderMenuItem);
        this.folderMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new CreateFolderDialog((Frame)thisFrame, ClientFrame.this.model);
            }
        });
        this.relationshipMenuItem = new JMenuItem("Relationship");
        this.relationshipMenuItem.setEnabled(false);
        this.toolbarCreatePopup.add(this.relationshipMenuItem);
        this.relationshipMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new CreateRelationshipDialog((Frame)thisFrame, ClientFrame.this.model);
            }
        });
        this.policyMenuItem = new JMenuItem("Policy");
        this.policyMenuItem.setEnabled(false);
        this.toolbarCreatePopup.add(this.policyMenuItem);
        this.policyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new CreatePolicyDialog((Frame)thisFrame, ClientFrame.this.model);
            }
        });
        this.toolbarButton[7] = new JButton("Create Object", new CreateObjectIcon(20, 20));
        this.toolbarButton[7].setDisabledIcon(new CreateObjectIcon(20, 20, false));
        this.toolbarButton[7].setEnabled(false);
        this.toolbarButton[7].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.toolbarCreatePopup.show(ClientFrame.this.toolbarButton[7], 0, ClientFrame.this.toolbarButton[7].getHeight());
            }
        });
        this.toolBar.add(this.toolbarButton[7]);
        this.toolBar.addSeparator();
        this.toolbarButton[8] = new JButton("Log", new LogIcon(20, 20));
        this.toolbarButton[8].setDisabledIcon(new LogIcon(20, 20, false));
        this.toolbarButton[8].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.logFrame.showFrame();
            }
        });
        this.toolBar.add(this.toolbarButton[8]);
        this.toolbarButton[9] = new JButton("Info", new InfoIcon(20, 20));
        this.toolbarButton[9].setDisabledIcon(new InfoIcon(20, 20, false));
        this.toolbarButton[9].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.infoDialog.showDialog();
            }
        });
        this.toolBar.add(this.toolbarButton[9]);
        pane.add((Component)this.toolBar, "First");
        this.folderPanel = new FolderPanel(this.model);
        this.detailsTabs = new DetailsTabs(this.model);
        this.split = new JSplitPane(1, this.folderPanel, this.detailsTabs);
        pane.add((Component)this.split, "Center");
        this.addWindowListener(this);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(this.prefs.getInt(PREFS_WIDTH, (int)(screenSize.getWidth() / 1.5)), this.prefs.getInt(PREFS_HEIGHT, (int)(screenSize.getHeight() / 1.5))));
        this.setMinimumSize(new Dimension(200, 60));
        this.setDefaultCloseOperation(3);
        this.pack();
        this.split.setDividerLocation(this.prefs.getInt(PREFS_DIV, this.getPreferredSize().width / 4));
        if (this.prefs.getInt(PREFS_X, Integer.MAX_VALUE) == Integer.MAX_VALUE) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(this.prefs.getInt(PREFS_X, 0), this.prefs.getInt(PREFS_Y, 0));
        }
        this.setVisible(true);
    }

    private void showLoginForm() {
        this.loginDialog.showDialog();
        if (!this.loginDialog.isCanceled()) {
            ClientSession clientSession = this.loginDialog.getClientSession();
            this.model.setClientSession(clientSession);
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.model.loadFolder(clientSession.getStartFolderId(), false);
                this.model.loadObject(clientSession.getStartFolderId());
                this.toolbarButton[1].setEnabled(true);
                this.toolbarButton[2].setEnabled(true);
                this.toolbarButton[3].setEnabled(this.model.supportsQuery());
                this.toolbarButton[4].setEnabled(this.model.supportsChangeLog());
                this.toolbarButton[5].setEnabled(true);
                this.toolbarButton[6].setEnabled(true);
                this.toolbarButton[7].setEnabled(true);
                this.itemMenuItem.setEnabled(this.model.supportsItems());
                this.relationshipMenuItem.setEnabled(this.model.supportsRelationships());
                this.policyMenuItem.setEnabled(this.model.supportsPolicies());
                String user = clientSession.getSessionParameters().get("org.apache.chemistry.opencmis.user");
                user = user != null ? " - (" + user + ")" : "";
                this.setTitle(WINDOW_TITLE + user + " - " + clientSession.getSession().getRepositoryInfo().getName());
            }
            catch (Exception ex) {
                this.toolbarButton[1].setEnabled(false);
                this.toolbarButton[2].setEnabled(false);
                this.toolbarButton[3].setEnabled(false);
                this.toolbarButton[4].setEnabled(false);
                this.toolbarButton[5].setEnabled(false);
                this.toolbarButton[6].setEnabled(false);
                this.toolbarButton[7].setEnabled(false);
                ClientHelper.showError(null, ex);
                this.setTitle(WINDOW_TITLE);
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private List<ClientHelper.FileEntry> readScriptLibrary() {
        URI propFile = null;
        String externalScripts = System.getProperty(SYSPROP_SCRIPTS);
        propFile = externalScripts == null ? ClientHelper.getClasspathURI("/scripts/script-library.properties") : new File(externalScripts).toURI();
        List<ClientHelper.FileEntry> result = ClientHelper.readFileProperties(propFile);
        if (result == null || result.isEmpty()) {
            result = Collections.singletonList(new ClientHelper.FileEntry("Groovy Console", null));
        }
        return result;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Point p = this.getLocation();
        this.prefs.putInt(PREFS_X, p.x);
        this.prefs.putInt(PREFS_Y, p.y);
        this.prefs.putInt(PREFS_WIDTH, this.getWidth());
        this.prefs.putInt(PREFS_HEIGHT, this.getHeight());
        this.prefs.putInt(PREFS_DIV, this.split.getDividerLocation());
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

