/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import groovy.lang.Binding;
import groovy.ui.Console;
import groovy.util.GroovyScriptEngine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Style;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.MimeTypes;
import org.apache.chemistry.opencmis.workbench.ExceptionDialog;
import org.apache.chemistry.opencmis.workbench.LoggingInputStream;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientHelper {
    public static final Color LINK_COLOR = new Color(105, 29, 21);
    public static final Color LINK_SELECTED_COLOR = new Color(255, 255, 255);
    public static final int TOOLBAR_ICON_SIZE = 20;
    public static final int BUTTON_ICON_SIZE = 11;
    public static final int OBJECT_ICON_SIZE = 16;
    public static final int ICON_BUTTON_ICON_SIZE = 16;
    private static final Logger LOG = LoggerFactory.getLogger(ClientHelper.class);
    private static final int BUFFER_SIZE = 65536;
    private static final ImageIcon CMIS_ICON = ClientHelper.getIcon("icon256.png");
    private static final List<BufferedImage> CMIS_ICON_LIST = new ArrayList<BufferedImage>();

    private ClientHelper() {
    }

    public static void logError(Exception ex) {
        if (LOG.isErrorEnabled()) {
            LOG.error(ex.getClass().getSimpleName() + ": " + ex.getMessage(), (Throwable)ex);
            if (ex instanceof CmisBaseException) {
                CmisBaseException cex = (CmisBaseException)ex;
                if (cex.getCode() != null) {
                    LOG.error("Error code: " + cex.getCode());
                }
                if (cex.getErrorContent() != null) {
                    LOG.error("Error content: " + cex.getErrorContent());
                }
                if (LOG.isDebugEnabled() && cex.getCause() != null) {
                    LOG.debug("Cause: " + cex.getCause().toString(), cex.getCause());
                }
            }
        }
    }

    public static void showError(Component parent, Exception ex) {
        ClientHelper.logError(ex);
        JFrame frame = parent == null ? null : (JFrame)SwingUtilities.getRoot(parent);
        new ExceptionDialog((Frame)frame, ex);
    }

    public static boolean isMacOSX() {
        String osname = System.getProperty("os.name");
        return osname == null ? false : osname.startsWith("Mac OS X");
    }

    public static void installKeyBindings() {
        if (ClientHelper.isMacOSX()) {
            KeyStroke copyKeyStroke = KeyStroke.getKeyStroke("meta pressed C");
            KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke("meta pressed V");
            KeyStroke cutKeyStroke = KeyStroke.getKeyStroke("meta pressed X");
            KeyStroke allKeyStroke = KeyStroke.getKeyStroke("meta pressed A");
            InputMap textFieldMap = (InputMap)UIManager.get("TextField.focusInputMap");
            textFieldMap.put(copyKeyStroke, "copy-to-clipboard");
            textFieldMap.put(pasteKeyStroke, "paste-from-clipboard");
            textFieldMap.put(cutKeyStroke, "cut-to-clipboard");
            textFieldMap.put(allKeyStroke, "select-all");
            InputMap formattedTextFieldMap = (InputMap)UIManager.get("FormattedTextField.focusInputMap");
            formattedTextFieldMap.put(copyKeyStroke, "copy-to-clipboard");
            formattedTextFieldMap.put(pasteKeyStroke, "paste-from-clipboard");
            formattedTextFieldMap.put(cutKeyStroke, "cut-to-clipboard");
            formattedTextFieldMap.put(allKeyStroke, "select-all");
            InputMap textAreaMap = (InputMap)UIManager.get("TextArea.focusInputMap");
            textAreaMap.put(copyKeyStroke, "copy-to-clipboard");
            textAreaMap.put(pasteKeyStroke, "paste-from-clipboard");
            textAreaMap.put(cutKeyStroke, "cut-to-clipboard");
            textAreaMap.put(allKeyStroke, "select-all");
            InputMap editorPaneMap = (InputMap)UIManager.get("EditorPane.focusInputMap");
            editorPaneMap.put(copyKeyStroke, "copy-to-clipboard");
            editorPaneMap.put(pasteKeyStroke, "paste-from-clipboard");
            editorPaneMap.put(cutKeyStroke, "cut-to-clipboard");
            editorPaneMap.put(allKeyStroke, "select-all");
            InputMap passwordFieldMap = (InputMap)UIManager.get("PasswordField.focusInputMap");
            passwordFieldMap.put(pasteKeyStroke, "paste-from-clipboard");
        }
    }

    public static void installEscapeBinding(final Window window, JRootPane rootPane, final boolean dispose) {
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        rootPane.getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dispose) {
                    window.dispose();
                } else {
                    window.setVisible(false);
                }
            }
        });
    }

    public static ImageIcon getIcon(String name) {
        URL imageURL = ClientHelper.class.getResource("/images/" + name);
        if (imageURL != null) {
            return WorkbenchScale.scaleIcon(new ImageIcon(imageURL));
        }
        return null;
    }

    public static ImageIcon getCmisIconImage() {
        return CMIS_ICON;
    }

    public static List<? extends Image> getCmisIconImages() {
        return CMIS_ICON_LIST;
    }

    public static String getDateString(GregorianCalendar cal) {
        if (cal == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZ");
        sdf.setTimeZone(cal.getTimeZone());
        return sdf.format(cal.getTime());
    }

    public static void download(Component component, CmisObject object, String streamId) {
        ContentStream content = ClientHelper.getContentStream(object, streamId);
        if (content == null) {
            return;
        }
        String filename = content.getFileName();
        if (filename == null) {
            filename = object instanceof Document ? ((Document)object).getContentStreamFileName() : object.getName();
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(filename));
        int chooseResult = fileChooser.showDialog(component, "Download");
        if (chooseResult == 0) {
            try {
                ClientHelper.storeStream(content.getStream(), fileChooser.getSelectedFile());
            }
            catch (Exception e) {
                ClientHelper.showError(component, e);
            }
        }
    }

    public static void copy(Component component, File file) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(file.getName()));
        int chooseResult = fileChooser.showDialog(component, "Download");
        if (chooseResult == 0) {
            try {
                ClientHelper.storeStream(new FileInputStream(file), fileChooser.getSelectedFile());
            }
            catch (Exception e) {
                ClientHelper.showError(component, e);
            }
        }
    }

    public static void open(Component component, CmisObject object, String streamId) {
        if (!Desktop.isDesktopSupported()) {
            ClientHelper.download(component, object, streamId);
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.OPEN)) {
            ClientHelper.download(component, object, streamId);
            return;
        }
        File file = null;
        try {
            file = ClientHelper.createTempFileFromDocument(object, streamId);
        }
        catch (Exception e) {
            ClientHelper.showError(component, e);
            return;
        }
        try {
            desktop.open(file);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                ClientHelper.copy(component, file);
            }
            ClientHelper.showError(component, e);
        }
    }

    public static File createTempFile(String filename) {
        String tempDir = System.getProperty("java.io.tmpdir");
        File clientTempDir = new File(tempDir, "cmisworkbench");
        if (!clientTempDir.exists() && !clientTempDir.mkdirs()) {
            throw new CmisRuntimeException("Could not create directory for temp file!");
        }
        clientTempDir.deleteOnExit();
        File tempFile = new File(clientTempDir, filename);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static File createTempFileFromDocument(CmisObject object, String streamId) throws IOException {
        String ext;
        ContentStream content = ClientHelper.getContentStream(object, streamId);
        if (content == null) {
            throw new IllegalArgumentException("No content!");
        }
        String filename = content.getFileName();
        if ((filename == null || filename.length() == 0) && object instanceof Document) {
            filename = ((Document)object).getContentStreamFileName();
        }
        if (filename == null || filename.length() == 0) {
            filename = object.getName();
        }
        if (filename == null || filename.length() == 0) {
            filename = "content";
        }
        if ((ext = MimeTypes.getExtension((String)content.getMimeType())).length() > 0 && !filename.endsWith(ext)) {
            filename = filename + ext;
        }
        File tempFile = ClientHelper.createTempFile(filename);
        try {
            ClientHelper.storeStream(content.getStream(), tempFile);
        }
        catch (CmisConstraintException cmisConstraintException) {
            // empty catch block
        }
        return tempFile;
    }

    private static void storeStream(InputStream in, File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            IOUtils.copy((InputStream)new LoggingInputStream(in, file.getName()), (OutputStream)out, (int)65536);
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
            IOUtils.closeQuietly((Closeable)out);
        }
    }

    private static ContentStream getContentStream(CmisObject object, String streamId) {
        if (object == null) {
            return null;
        }
        if (object instanceof Document) {
            return ((Document)object).getContentStream(streamId);
        }
        if (streamId == null) {
            return null;
        }
        List renditions = object.getRenditions();
        if (renditions == null) {
            return null;
        }
        for (Rendition rendition : renditions) {
            if (!streamId.equals(rendition.getStreamId())) continue;
            return rendition.getContentStream();
        }
        return null;
    }

    public static void copyTableToClipboard(JTable table) {
        String newline = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder(1024);
        int rows = table.getModel().getRowCount();
        int cols = table.getModel().getColumnCount();
        for (int col = 0; col < cols; ++col) {
            if (col > 0) {
                sb.append(',');
            }
            sb.append(ClientHelper.formatCSVValue(table.getModel().getColumnName(col)));
        }
        sb.append(newline);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                if (col > 0) {
                    sb.append(',');
                }
                Object value = table.getModel().getValueAt(row, col);
                sb.append(ClientHelper.formatCSVValue(value));
            }
            sb.append(newline);
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferable = new StringSelection(sb.toString());
        clipboard.setContents(transferable, null);
    }

    public static String encodeHtml(StringBuilder sb, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&#39;");
                continue;
            }
            if (c > '\u007f') {
                sb.append("&#" + c + ";");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String formatCSVValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof GregorianCalendar) {
            return ClientHelper.getDateString((GregorianCalendar)value);
        }
        if (value instanceof String) {
            String s = value.toString();
            StringBuilder sb = new StringBuilder(s.length() + 16);
            sb.append('\"');
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                sb.append(c);
                if (c != '\"') continue;
                sb.append('\"');
            }
            sb.append('\"');
            return sb.toString();
        }
        if (value instanceof Collection) {
            StringBuilder sb = new StringBuilder(((Collection)value).size() * 16 + 16);
            sb.append('[');
            for (Object v : (Collection)value) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                sb.append(ClientHelper.formatCSVValue(v));
            }
            sb.append(']');
            return sb.toString();
        }
        if (value instanceof ObjectId) {
            return ClientHelper.formatCSVValue(((ObjectId)value).getId());
        }
        if (value instanceof ImageIcon) {
            return "<icon>";
        }
        return value.toString();
    }

    public static URI getClasspathURI(String path) {
        try {
            return ClientHelper.class.getResource(path).toURI();
        }
        catch (URISyntaxException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String readFileAndRemoveHeader(URI file) {
        InputStream stream;
        if (file == null) {
            return "";
        }
        try {
            stream = file.toURL().openStream();
        }
        catch (Exception e) {
            return "";
        }
        String result = ClientHelper.readStreamAndRemoveHeader(stream);
        IOUtils.closeQuietly((Closeable)stream);
        return result;
    }

    public static String readStreamAndRemoveHeader(InputStream stream) {
        if (stream == null) {
            return "";
        }
        try {
            return IOUtils.readAllLinesAndRemoveHeader((InputStream)stream, (int)10000);
        }
        catch (IOException e1) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileEntry> readFileProperties(URI propertiesFile) {
        String path;
        int x;
        InputStream stream;
        try {
            stream = propertiesFile.toURL().openStream();
            if (stream == null) {
                return null;
            }
        }
        catch (Exception e) {
            LOG.error("Cannot open library file: {}", (Object)propertiesFile, (Object)e);
            return null;
        }
        String classpathParent = null;
        if ("classpath".equalsIgnoreCase(propertiesFile.getScheme()) && (x = (path = propertiesFile.getSchemeSpecificPart()).lastIndexOf(47)) > -1) {
            classpathParent = path.substring(0, x);
        }
        if ("jar".equalsIgnoreCase(propertiesFile.getScheme()) && (x = (path = propertiesFile.getSchemeSpecificPart()).lastIndexOf(47)) > -1 && (x = (path = path.substring(0, x)).indexOf("!/")) > -1) {
            classpathParent = path.substring(x + 1);
        }
        String fileParent = null;
        if ("file".equalsIgnoreCase(propertiesFile.getScheme())) {
            fileParent = new File(propertiesFile).getParent();
        }
        try {
            Properties properties = new Properties();
            properties.load(stream);
            stream.close();
            ArrayList<FileEntry> result = new ArrayList<FileEntry>();
            for (String file : properties.stringPropertyNames()) {
                try {
                    URL url;
                    URI uri = null;
                    if (classpathParent != null && (url = ClientHelper.class.getResource(classpathParent + "/" + file)) != null) {
                        uri = url.toURI();
                    }
                    if (fileParent != null) {
                        uri = new File(fileParent, file).toURI();
                    }
                    if (uri != null) {
                        result.add(new FileEntry(properties.getProperty(file), uri));
                        continue;
                    }
                    LOG.error("Cannot find library entry: {}", (Object)file);
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            Collections.sort(result);
            ArrayList<FileEntry> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error("Cannot read library file: {}", (Object)propertiesFile);
            List<FileEntry> list = null;
            return list;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    public static Console openConsole(Component parent, ClientModel model, URI file) {
        return ClientHelper.openConsole(parent, model, file, null);
    }

    public static Console openConsole(Component parent, ClientModel model, String soureCode) {
        return ClientHelper.openConsole(parent, model, null, soureCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Console openConsole(Component parent, ClientModel model, URI file, String soureCode) {
        try {
            parent.setCursor(Cursor.getPredefinedCursor(3));
            final Session groovySession = model.getClientSession().getSession();
            final String user = model.getClientSession().getSessionParameters().get("org.apache.chemistry.opencmis.user");
            final String title = "GroovyConsole - Repsository: " + groovySession.getRepositoryInfo().getId();
            final Console console = new Console(parent.getClass().getClassLoader()){

                public void updateTitle() {
                    JFrame frame = (JFrame)this.getFrame();
                    if (this.getScriptFile() != null) {
                        frame.setTitle(((File)this.getScriptFile()).getName() + (this.getDirty() ? " * " : "") + " - " + title);
                    } else {
                        frame.setTitle(title);
                    }
                }
            };
            console.setVariable("session", (Object)groovySession);
            console.setVariable("binding", (Object)groovySession.getBinding());
            console.run();
            JMenu cmisMenu = new JMenu("CMIS");
            console.getFrame().getRootPane().getJMenuBar().add(cmisMenu);
            ClientHelper.addConsoleMenu(cmisMenu, "CMIS 1.0 Specification", new URI("http://docs.oasis-open.org/cmis/CMIS/v1.0/os/cmis-spec-v1.0.html"));
            ClientHelper.addConsoleMenu(cmisMenu, "CMIS 1.1 Specification", new URI("http://docs.oasis-open.org/cmis/CMIS/v1.1/CMIS-v1.1.html"));
            ClientHelper.addConsoleMenu(cmisMenu, "OpenCMIS Documentation", new URI("http://chemistry.apache.org/java/opencmis.html"));
            ClientHelper.addConsoleMenu(cmisMenu, "OpenCMIS Client API JavaDoc", new URI("http://chemistry.apache.org/java/0.13.0/maven/apidocs/"));
            cmisMenu.addSeparator();
            JMenuItem menuItem = new JMenuItem("CMIS Session Details");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Style style = console.getOutputStyle();
                    console.clearOutput();
                    console.appendOutputNl((Object)("Session ID:      " + groovySession.getBinding().getSessionId()), (Object)style);
                    console.appendOutputNl((Object)("Repository ID:   " + groovySession.getRepositoryInfo().getId()), (Object)style);
                    console.appendOutputNl((Object)("Repository name: " + groovySession.getRepositoryInfo().getName()), (Object)style);
                    console.appendOutputNl((Object)("Binding:         " + groovySession.getBinding().getBindingType()), (Object)style);
                    console.appendOutputNl((Object)("User:            " + user), (Object)style);
                }
            });
            cmisMenu.add(menuItem);
            if (file != null) {
                console.getInputArea().setText(ClientHelper.readFileAndRemoveHeader(file));
            } else if (soureCode != null) {
                console.getInputArea().setText(soureCode);
            }
            Console console2 = console;
            return console2;
        }
        catch (Exception ex) {
            ClientHelper.showError(null, ex);
            Console console = null;
            return console;
        }
        finally {
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private static void addConsoleMenu(JMenu menu, String title, final URI url) {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            return;
        }
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(url);
                }
                catch (IOException ex) {
                    ClientHelper.showError(null, ex);
                }
            }
        });
        menu.add(menuItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runGroovyScript(Component parent, ClientModel model, File file, Writer out) {
        try {
            parent.setCursor(Cursor.getPredefinedCursor(3));
            String[] roots = new String[]{file.getParentFile().getAbsolutePath()};
            GroovyScriptEngine gse = new GroovyScriptEngine(roots, parent.getClass().getClassLoader());
            Binding binding = new Binding();
            binding.setVariable("session", (Object)model.getClientSession().getSession());
            binding.setVariable("binding", (Object)model.getClientSession().getSession().getBinding());
            binding.setVariable("out", (Object)out);
            gse.run(file.getName(), binding);
        }
        catch (Exception ex) {
            ClientHelper.showError(null, ex);
        }
        finally {
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runJSR223Script(Component parent, ClientModel model, File file, String ext, Writer out) {
        InputStreamReader reader = null;
        try {
            parent.setCursor(Cursor.getPredefinedCursor(3));
            reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine engine = mgr.getEngineByExtension(ext);
            engine.getContext().setWriter(out);
            engine.getContext().setErrorWriter(out);
            engine.put("session", model.getClientSession().getSession());
            engine.put("binding", model.getClientSession().getSession().getBinding());
            engine.put("out", new PrintWriter(out));
            engine.eval(reader);
            IOUtils.closeQuietly((Closeable)reader);
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception ex) {
            ClientHelper.showError(null, ex);
        }
        finally {
            IOUtils.closeQuietly(reader);
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    static {
        try {
            CMIS_ICON_LIST.add(ImageIO.read(ClientHelper.class.getResource("/images/icon256.png")));
            CMIS_ICON_LIST.add(ImageIO.read(ClientHelper.class.getResource("/images/icon128.png")));
            CMIS_ICON_LIST.add(ImageIO.read(ClientHelper.class.getResource("/images/icon64.png")));
            CMIS_ICON_LIST.add(ImageIO.read(ClientHelper.class.getResource("/images/icon48.png")));
            CMIS_ICON_LIST.add(ImageIO.read(ClientHelper.class.getResource("/images/icon32.png")));
            CMIS_ICON_LIST.add(ImageIO.read(ClientHelper.class.getResource("/images/icon16.png")));
        }
        catch (Exception e) {
            LOG.error("Icons cannot be loaded!", (Throwable)e);
        }
    }

    public static class FileEntry
    implements Comparable<FileEntry> {
        private final String name;
        private final URI file;

        public FileEntry(String name, URI file) {
            this.name = name;
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public URI getFile() {
            return this.file;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(FileEntry o) {
            return this.name.compareToIgnoreCase(o.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FileEntry)) {
                return false;
            }
            return this.name.equals(((FileEntry)obj).getName());
        }
    }
}

