/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Locale;
import javax.net.ssl.SSLException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisProxyAuthenticationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParseException;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.xml.sax.SAXParseException;

public class ConnectionErrorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private final Exception exception;

    public ConnectionErrorDialog(JDialog owner, Exception exception) {
        super(owner, "Connection Error", true);
        this.exception = exception;
        ClientHelper.logError(exception);
        this.createGUI();
    }

    private void createGUI() {
        this.setMinimumSize(new Dimension(WorkbenchScale.scaleInt(600), WorkbenchScale.scaleInt(400)));
        this.setPreferredSize(new Dimension(WorkbenchScale.scaleInt(600), WorkbenchScale.scaleInt(450)));
        this.setLayout(new BorderLayout());
        StringBuilder hint = new StringBuilder(1024);
        hint.append("<h2><font color=\"red\">Exception: <em>" + this.exception.getClass().getSimpleName() + "</em></font><br>");
        ClientHelper.encodeHtml(hint, this.exception.getMessage());
        hint.append("</h2>");
        if (this.exception.getCause() != null) {
            hint.append("<h3><font color=\"red\">Cause: <em>" + this.exception.getCause().getClass().getSimpleName() + "</em></font><br>");
            ClientHelper.encodeHtml(hint, this.exception.getCause().getMessage());
            hint.append("</h3>");
        }
        hint.append("<hr><br>");
        hint.append(this.getHint());
        JPanel hintsPanel = new JPanel();
        hintsPanel.setLayout(new BoxLayout(hintsPanel, 3));
        hintsPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)hintsPanel, "Center");
        JEditorPane hints = new JEditorPane("text/html", hint.toString());
        hints.setEditable(false);
        hints.setCaretPosition(0);
        hintsPanel.add(new JScrollPane(hints, 20, 31));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        buttonPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)buttonPanel, "Last");
        JButton closeButton = new JButton("Close");
        closeButton.setPreferredSize(new Dimension(Short.MAX_VALUE, WorkbenchScale.scaleInt(30)));
        closeButton.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        closeButton.setAlignmentX(0.5f);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionErrorDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        this.getRootPane().setDefaultButton(closeButton);
        ClientHelper.installEscapeBinding(this, this.getRootPane(), true);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    private String getHint() {
        if (this.exception instanceof CmisObjectNotFoundException || this.exception instanceof CmisNotSupportedException) {
            return "The CMIS Workbench could connect to the server but the provided URL is not a CMIS endpoint URL.<br>Check your URL and proxy settings." + this.getProxyConfig();
        }
        if (this.exception instanceof CmisUnauthorizedException) {
            return "The provided credentials are invalid.<br>Check your credentials.";
        }
        if (this.exception instanceof CmisPermissionDeniedException) {
            return "The provided credentials are invalid or the user has no permission to connect.<br>Check your credentials.";
        }
        if (this.exception instanceof CmisProxyAuthenticationException) {
            return "The proxy server requires valid credentials.<br>Check the session parameters 'org.apache.chemistry.opencmis.binding.proxyuser' and 'org.apache.chemistry.opencmis.binding.proxypassword'." + this.getProxyConfig();
        }
        if (this.exception instanceof CmisRuntimeException) {
            return "Something fatal happend on the client or server side.<br>Check your URL, the binding, and your proxy settings.<br><br>Also see the CMIS Workbench log for more details." + this.getProxyConfig();
        }
        if (this.exception instanceof CmisConnectionException) {
            Throwable cause = this.exception.getCause();
            while (cause instanceof CmisConnectionException) {
                cause = cause.getCause();
            }
            if (cause instanceof MalformedURLException || cause instanceof URISyntaxException) {
                return "The provided URL is not a valid URL.<br>Check your URL.";
            }
            if (cause instanceof UnknownHostException) {
                return "The CMIS Workbench could not connect to the server.<br>Check your URL and your network and proxy settings." + this.getProxyConfig();
            }
            if (cause instanceof SSLException) {
                return "The CMIS Workbench could not establish a SSL connection to the server.<br>Check your network and proxy settings.<br><br>If you want to connect to a server with a self-signed certificate, add the parameter <code>-Dcmis.workbench.acceptSelfSignedCertificates=true</code> to the JAVA_OPTS in the CMIS Workbench start script and restart.<br><b>WARNING:</b> It disables <em>all</em> SSL certificate checks!" + this.getProxyConfig();
            }
            if (cause instanceof JSONParseException) {
                return "The provided URL does not return a JSON response.<br>Check your URL, the binding, and your proxy settings.<br><br>Some servers return a HTML login page if the credentials are incorrect.<br>Check your credentials." + this.getProxyConfig();
            }
            if (cause instanceof XMLStreamException) {
                return "The provided URL does not return an AtomPub response.<br>Check your URL, the binding, and your proxy settings.<br><br>Some servers return a HTML login page if the credentials are incorrect.<br>Check your credentials." + this.getProxyConfig();
            }
            if (cause instanceof SAXParseException) {
                return "The provided URL does not return a WSDL.<br>Check your URL, the binding, and your proxy settings.<br><br>Some servers return a HTML login page if the credentials are incorrect.<br>Check your credentials." + this.getProxyConfig();
            }
            if (cause instanceof IOException) {
                return "A network problem occured.<br>Check your URL and your network and proxy settings." + this.getProxyConfig();
            }
            if (this.exception.getMessage().toLowerCase(Locale.ENGLISH).startsWith("unexpected document")) {
                return "The provided URL does not return a AtomPub response.<br>Check your URL, the binding, and your proxy settings.<br><br>Some servers return a HTML login page if the credentials are incorrect.<br>Check your credentials." + this.getProxyConfig();
            }
            return "Check the URL, the binding, and the credentials.";
        }
        return this.exception.getMessage();
    }

    private String getProxyConfig() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<br><br><hr><br><em>Current proxy settings:</em><br><br>");
        if (System.getProperty(HTTP_PROXY_HOST) == null && System.getProperty(HTTPS_PROXY_HOST) == null) {
            sb.append("<b>- no proxy settings -</b>");
        } else {
            sb.append("<table>");
            if (System.getProperty(HTTP_PROXY_HOST) != null) {
                sb.append("<tr><td><b>HTTP proxy:</b></td><td>");
                sb.append(System.getProperty(HTTP_PROXY_HOST) + ":" + System.getProperty(HTTP_PROXY_PORT));
                sb.append("</td></tr>");
            }
            if (System.getProperty(HTTPS_PROXY_HOST) != null) {
                sb.append("<tr><td><b>HTTPS proxy:</b></td><td>");
                sb.append(System.getProperty(HTTPS_PROXY_HOST) + ":" + System.getProperty(HTTPS_PROXY_PORT));
                sb.append("</td></tr>");
            }
            if (System.getProperty(HTTP_NON_PROXY_HOSTS) != null) {
                sb.append("<tr><td><b>Non proxy hosts:</b></td><td>");
                sb.append(System.getProperty(HTTP_NON_PROXY_HOSTS));
                sb.append("</td></tr>");
            }
        }
        return sb.toString();
    }
}

