/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.icons.NewDocumentIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientSession;
import org.apache.chemistry.opencmis.workbench.swing.CreateDialog;

public class CreateDocumentDialog
extends CreateDialog {
    private static final long serialVersionUID = 1L;
    private JRadioButton unfiledButton;
    private JRadioButton currentPathButton;
    private JTextField nameField;
    private JComboBox<CreateDialog.ObjectTypeItem> typeBox;
    private JTextField filenameField;
    private JFormattedTextField generateContentSizeField;
    private JComboBox<String> generateContentUnitField;
    private JRadioButton versioningStateNoneButton;
    private JRadioButton versioningStateMajorButton;
    private JRadioButton versioningStateMinorButton;
    private JRadioButton versioningStateCheckedoutButton;
    private JCheckBox verifyAfterUploadButton;

    public CreateDocumentDialog(Frame owner, ClientModel model) {
        this(owner, model, null);
    }

    public CreateDocumentDialog(Frame owner, ClientModel model, File file) {
        super(owner, "Create Document", model);
        this.createGUI(file);
    }

    private void createGUI(File file) {
        final CreateDocumentDialog thisDialog = this;
        this.unfiledButton = new JRadioButton("create unfiled");
        this.unfiledButton.setSelected(false);
        this.currentPathButton = new JRadioButton("create in the current folder: " + this.getClientModel().getCurrentFolder().getPath());
        this.currentPathButton.setSelected(true);
        ButtonGroup filedGroup = new ButtonGroup();
        filedGroup.add(this.unfiledButton);
        filedGroup.add(this.currentPathButton);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(this.unfiledButton);
        buttonPanel.add(this.currentPathButton);
        this.createRow("", buttonPanel, 0);
        this.nameField = new JTextField(60);
        this.createRow("Name:", this.nameField, 1);
        CreateDialog.ObjectTypeItem[] types = this.getTypes(BaseTypeId.CMIS_DOCUMENT.value());
        if (types.length == 0) {
            JOptionPane.showMessageDialog(this, "No creatable type!", "Creatable Types", 0);
            thisDialog.dispose();
            return;
        }
        this.typeBox = new JComboBox<CreateDialog.ObjectTypeItem>(types);
        this.typeBox.setSelectedIndex(0);
        this.typeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DocumentTypeDefinition type = (DocumentTypeDefinition)((CreateDialog.ObjectTypeItem)CreateDocumentDialog.this.typeBox.getSelectedItem()).getObjectType();
                if (type.isVersionable().booleanValue()) {
                    CreateDocumentDialog.this.versioningStateMajorButton.setSelected(true);
                } else {
                    CreateDocumentDialog.this.versioningStateNoneButton.setSelected(true);
                }
                CreateDocumentDialog.this.updateMandatoryOrOnCreateFields((TypeDefinition)type);
            }
        });
        CreateDialog.ObjectTypeItem type = (CreateDialog.ObjectTypeItem)this.typeBox.getSelectedItem();
        this.updateMandatoryOrOnCreateFields((TypeDefinition)type.getObjectType());
        this.createRow("Type:", this.typeBox, 2);
        JPanel filePanel = new JPanel(new BorderLayout());
        this.filenameField = new JTextField(30);
        this.filenameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.adjustGenerateContentComponents();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.adjustGenerateContentComponents();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void adjustGenerateContentComponents() {
                if (CreateDocumentDialog.this.filenameField.getText().length() == 0) {
                    CreateDocumentDialog.this.generateContentSizeField.setEnabled(true);
                    CreateDocumentDialog.this.generateContentUnitField.setEnabled(true);
                } else {
                    CreateDocumentDialog.this.generateContentSizeField.setEnabled(false);
                    CreateDocumentDialog.this.generateContentUnitField.setEnabled(false);
                }
            }
        });
        filePanel.add((Component)this.filenameField, "Center");
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser();
                int chooseResult = fileChooser.showDialog(CreateDocumentDialog.this.filenameField, "Select");
                if (chooseResult == 0 && fileChooser.getSelectedFile().isFile()) {
                    CreateDocumentDialog.this.setFile(fileChooser.getSelectedFile());
                }
            }
        });
        filePanel.add((Component)browseButton, "After");
        this.createRow("File:", filePanel, 4);
        JPanel generateContentPanel = new JPanel();
        generateContentPanel.setLayout(new BoxLayout(generateContentPanel, 0));
        this.generateContentSizeField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.generateContentSizeField.setValue(0L);
        this.generateContentSizeField.setColumns(8);
        this.generateContentSizeField.setHorizontalAlignment(4);
        this.generateContentSizeField.setMaximumSize(this.generateContentSizeField.getPreferredSize());
        generateContentPanel.add(this.generateContentSizeField);
        this.generateContentUnitField = new JComboBox<String>(new String[]{"Bytes", "KiB", "MiB", "GiB"});
        this.generateContentUnitField.setMaximumSize(new Dimension((int)this.generateContentUnitField.getPreferredSize().getWidth() + 200, (int)this.generateContentUnitField.getPreferredSize().getHeight()));
        generateContentPanel.add(this.generateContentUnitField);
        generateContentPanel.add(Box.createHorizontalGlue());
        this.createRow("Generate content:", generateContentPanel, 5);
        this.versioningStateNoneButton = new JRadioButton("none");
        this.versioningStateMajorButton = new JRadioButton("major");
        this.versioningStateMinorButton = new JRadioButton("minor");
        this.versioningStateCheckedoutButton = new JRadioButton("checked out");
        ButtonGroup versioningStateGroup = new ButtonGroup();
        versioningStateGroup.add(this.versioningStateNoneButton);
        versioningStateGroup.add(this.versioningStateMajorButton);
        versioningStateGroup.add(this.versioningStateMinorButton);
        versioningStateGroup.add(this.versioningStateCheckedoutButton);
        JPanel versioningStatePanel = new JPanel(new FlowLayout(0));
        versioningStatePanel.add(this.versioningStateNoneButton);
        versioningStatePanel.add(this.versioningStateMajorButton);
        versioningStatePanel.add(this.versioningStateMinorButton);
        versioningStatePanel.add(this.versioningStateCheckedoutButton);
        if (((DocumentTypeDefinition)((CreateDialog.ObjectTypeItem)this.typeBox.getSelectedItem()).getObjectType()).isVersionable().booleanValue()) {
            this.versioningStateMajorButton.setSelected(true);
        } else {
            this.versioningStateNoneButton.setSelected(true);
        }
        this.createRow("Versioning State:", versioningStatePanel, 6);
        this.verifyAfterUploadButton = new JCheckBox("Verify content after upload");
        this.createRow("", this.verifyAfterUploadButton, 7);
        JButton createButton = new JButton("Create Document", new NewDocumentIcon(11, 11));
        createButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                String name = CreateDocumentDialog.this.nameField.getText();
                ObjectType type = ((CreateDialog.ObjectTypeItem)CreateDocumentDialog.this.typeBox.getSelectedItem()).getObjectType();
                String filename = CreateDocumentDialog.this.filenameField.getText();
                try {
                    CreateDocumentDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    VersioningState versioningState = VersioningState.NONE;
                    if (CreateDocumentDialog.this.versioningStateMajorButton.isSelected()) {
                        versioningState = VersioningState.MAJOR;
                    } else if (CreateDocumentDialog.this.versioningStateMinorButton.isSelected()) {
                        versioningState = VersioningState.MINOR;
                    } else if (CreateDocumentDialog.this.versioningStateCheckedoutButton.isSelected()) {
                        versioningState = VersioningState.CHECKEDOUT;
                    }
                    ObjectId objectId = null;
                    if (filename.length() > 0) {
                        objectId = CreateDocumentDialog.this.getClientModel().createDocument(name, type.getId(), filename, CreateDocumentDialog.this.getMandatoryOrOnCreatePropertyValues((TypeDefinition)type), versioningState, CreateDocumentDialog.this.unfiledButton.isSelected());
                        if (CreateDocumentDialog.this.verifyAfterUploadButton.isSelected()) {
                            ContentStream contentStream = CreateDocumentDialog.this.getClientModel().createContentStream(filename);
                            CreateDocumentDialog.this.verifyContentStreams(contentStream, objectId);
                        }
                    } else {
                        long seed = System.currentTimeMillis();
                        long length = ((Number)CreateDocumentDialog.this.generateContentSizeField.getValue()).longValue();
                        if (length < 0L) {
                            length = 0L;
                        } else {
                            for (int i = 0; i < CreateDocumentDialog.this.generateContentUnitField.getSelectedIndex(); ++i) {
                                length *= 1024L;
                            }
                        }
                        objectId = CreateDocumentDialog.this.getClientModel().createDocument(name, type.getId(), CreateDocumentDialog.this.getMandatoryOrOnCreatePropertyValues((TypeDefinition)type), length, seed, versioningState, CreateDocumentDialog.this.unfiledButton.isSelected());
                        if (CreateDocumentDialog.this.verifyAfterUploadButton.isSelected()) {
                            ContentStream contentStream = CreateDocumentDialog.this.getClientModel().createContentStream("", length, seed);
                            CreateDocumentDialog.this.verifyContentStreams(contentStream, objectId);
                        }
                    }
                    if (objectId != null) {
                        CreateDocumentDialog.this.getClientModel().loadObject(objectId.getId());
                    }
                    thisDialog.setVisible(false);
                    thisDialog.dispose();
                }
                catch (Exception e) {
                    ClientHelper.showError(null, e);
                }
                finally {
                    CreateDocumentDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        CreateDocumentDialog.this.getClientModel().reloadFolder();
                    }
                    catch (Exception e) {
                        ClientHelper.showError(null, e);
                    }
                }
            }
        });
        this.createActionRow("", createButton, 7);
        if (file != null) {
            this.setFile(file);
        }
        this.getRootPane().setDefaultButton(createButton);
        this.showDialog();
    }

    private void setFile(File file) {
        this.filenameField.setText(file.getAbsolutePath());
        if (this.nameField.getText().trim().length() == 0) {
            this.nameField.setText(file.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyContentStreams(ContentStream sourceContentStream, ObjectId objectId) {
        BufferedInputStream docContent;
        BufferedInputStream sourceContent;
        block12: {
            ClientSession clientSession = this.getClientModel().getClientSession();
            Document doc = (Document)clientSession.getSession().getObject(objectId, clientSession.getObjectOperationContext());
            ContentStream docContentStream = doc.getContentStream();
            if (docContentStream == null) {
                if (sourceContentStream.getLength() == 0L) {
                    JOptionPane.showMessageDialog(this.getOwner(), "Source file and document content are both empty.", "Verification successful", 1);
                    return;
                }
                JOptionPane.showMessageDialog(this.getOwner(), "Document has no conent but the source file is not empty!", "Verification failed", 0);
                return;
            }
            sourceContent = null;
            docContent = null;
            try {
                sourceContent = new BufferedInputStream(sourceContentStream.getStream(), 65536);
                docContent = new BufferedInputStream(docContentStream.getStream(), 65536);
                int fb = 0;
                int db = 0;
                long pos = 0L;
                while (fb > -1 && db > -1) {
                    fb = ((InputStream)sourceContent).read();
                    if (fb != (db = ((InputStream)docContent).read())) {
                        if (fb == -1) {
                            JOptionPane.showMessageDialog(this.getOwner(), "The document content is bigger than the source file!", "Verification failed", 0);
                            break block12;
                        }
                        if (db == -1) {
                            JOptionPane.showMessageDialog(this.getOwner(), "The source file is bigger than the document content!", "Verification failed", 0);
                            break block12;
                        } else {
                            JOptionPane.showMessageDialog(this.getOwner(), "Contents differ at byte " + pos + "!", "Verification failed", 0);
                        }
                        break block12;
                    }
                    ++pos;
                }
                JOptionPane.showMessageDialog(this.getOwner(), "Source file and document content are identical.", "Verification successful", 1);
            }
            catch (Exception e) {
                try {
                    JOptionPane.showMessageDialog(this.getOwner(), "Content test exception: " + e.getMessage(), "Verification failed", 0);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(sourceContent);
                    IOUtils.consumeAndClose(docContent);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)sourceContent);
                IOUtils.consumeAndClose((InputStream)docContent);
                return;
            }
            IOUtils.closeQuietly((Closeable)sourceContent);
            IOUtils.consumeAndClose((InputStream)docContent);
            return;
        }
        IOUtils.closeQuietly((Closeable)sourceContent);
        IOUtils.consumeAndClose((InputStream)docContent);
    }
}

