/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.icons.NewFolderIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.CreateDialog;

public class CreateFolderDialog
extends CreateDialog {
    private static final long serialVersionUID = 1L;
    private JTextField nameField;
    private JComboBox<CreateDialog.ObjectTypeItem> typeBox;

    public CreateFolderDialog(Frame owner, ClientModel model) {
        super(owner, "Create Folder", model);
        this.createGUI();
    }

    private void createGUI() {
        final CreateFolderDialog thisDialog = this;
        this.nameField = new JTextField(60);
        this.createRow("Name:", this.nameField, 0);
        CreateDialog.ObjectTypeItem[] types = this.getTypes(BaseTypeId.CMIS_FOLDER.value());
        if (types.length == 0) {
            JOptionPane.showMessageDialog(this, "No creatable type!", "Creatable Types", 0);
            thisDialog.dispose();
            return;
        }
        this.typeBox = new JComboBox<CreateDialog.ObjectTypeItem>(types);
        this.typeBox.setSelectedIndex(0);
        this.typeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ObjectType type = ((CreateDialog.ObjectTypeItem)CreateFolderDialog.this.typeBox.getSelectedItem()).getObjectType();
                CreateFolderDialog.this.updateMandatoryOrOnCreateFields((TypeDefinition)type);
            }
        });
        CreateDialog.ObjectTypeItem type = (CreateDialog.ObjectTypeItem)this.typeBox.getSelectedItem();
        this.updateMandatoryOrOnCreateFields((TypeDefinition)type.getObjectType());
        this.createRow("Type:", this.typeBox, 1);
        JButton createButton = new JButton("Create Folder", new NewFolderIcon(11, 11));
        createButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                String name = CreateFolderDialog.this.nameField.getText();
                ObjectType type = ((CreateDialog.ObjectTypeItem)CreateFolderDialog.this.typeBox.getSelectedItem()).getObjectType();
                try {
                    CreateFolderDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    ObjectId objectId = CreateFolderDialog.this.getClientModel().createFolder(name, type.getId(), CreateFolderDialog.this.getMandatoryOrOnCreatePropertyValues((TypeDefinition)type));
                    if (objectId != null) {
                        CreateFolderDialog.this.getClientModel().loadObject(objectId.getId());
                    }
                    thisDialog.setVisible(false);
                    thisDialog.dispose();
                }
                catch (Exception e) {
                    ClientHelper.showError(null, e);
                }
                finally {
                    CreateFolderDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        CreateFolderDialog.this.getClientModel().reloadFolder();
                    }
                    catch (Exception e) {
                        ClientHelper.showError(null, e);
                    }
                }
            }
        });
        this.createActionRow("", createButton, 3);
        this.getRootPane().setDefaultButton(createButton);
        this.showDialog();
    }
}

