/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.icons.NewItemIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.CreateDialog;

public class CreateItemDialog
extends CreateDialog {
    private static final long serialVersionUID = 1L;
    private JRadioButton unfiledButton;
    private JRadioButton currentPathButton;
    private JTextField nameField;
    private JComboBox<CreateDialog.ObjectTypeItem> typeBox;

    public CreateItemDialog(Frame owner, ClientModel model) {
        super(owner, "Create Item", model);
        this.createGUI();
    }

    private void createGUI() {
        final CreateItemDialog thisDialog = this;
        this.unfiledButton = new JRadioButton("create unfiled");
        this.unfiledButton.setSelected(false);
        this.currentPathButton = new JRadioButton("create in the current folder: " + this.getClientModel().getCurrentFolder().getPath());
        this.currentPathButton.setSelected(true);
        ButtonGroup filedGroup = new ButtonGroup();
        filedGroup.add(this.unfiledButton);
        filedGroup.add(this.currentPathButton);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(this.unfiledButton);
        buttonPanel.add(this.currentPathButton);
        this.createRow("", buttonPanel, 0);
        this.nameField = new JTextField(60);
        this.createRow("Name:", this.nameField, 1);
        CreateDialog.ObjectTypeItem[] types = this.getTypes(BaseTypeId.CMIS_ITEM.value());
        if (types.length == 0) {
            JOptionPane.showMessageDialog(this, "No creatable type!", "Creatable Types", 0);
            thisDialog.dispose();
            return;
        }
        this.typeBox = new JComboBox<CreateDialog.ObjectTypeItem>(types);
        this.typeBox.setSelectedIndex(0);
        this.typeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ObjectType type = ((CreateDialog.ObjectTypeItem)CreateItemDialog.this.typeBox.getSelectedItem()).getObjectType();
                CreateItemDialog.this.updateMandatoryOrOnCreateFields((TypeDefinition)type);
            }
        });
        CreateDialog.ObjectTypeItem type = (CreateDialog.ObjectTypeItem)this.typeBox.getSelectedItem();
        this.updateMandatoryOrOnCreateFields((TypeDefinition)type.getObjectType());
        this.createRow("Type:", this.typeBox, 2);
        JButton createButton = new JButton("Create Item", new NewItemIcon(11, 11));
        createButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                String name = CreateItemDialog.this.nameField.getText();
                ObjectType type = ((CreateDialog.ObjectTypeItem)CreateItemDialog.this.typeBox.getSelectedItem()).getObjectType();
                try {
                    CreateItemDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    ObjectId objectId = CreateItemDialog.this.getClientModel().createItem(name, type.getId(), CreateItemDialog.this.getMandatoryOrOnCreatePropertyValues((TypeDefinition)type), CreateItemDialog.this.unfiledButton.isSelected());
                    if (objectId != null) {
                        CreateItemDialog.this.getClientModel().loadObject(objectId.getId());
                    }
                    thisDialog.setVisible(false);
                    thisDialog.dispose();
                }
                catch (Exception e) {
                    ClientHelper.showError(null, e);
                }
                finally {
                    CreateItemDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        CreateItemDialog.this.getClientModel().reloadFolder();
                    }
                    catch (Exception e) {
                        ClientHelper.showError(null, e);
                    }
                }
            }
        });
        this.createActionRow("", createButton, 3);
        this.getRootPane().setDefaultButton(createButton);
        this.showDialog();
    }
}

