/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.icons.NewPolicyIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.CreateDialog;

public class CreatePolicyDialog
extends CreateDialog {
    private static final long serialVersionUID = 1L;
    private JRadioButton unfiledButton;
    private JRadioButton currentPathButton;
    private JTextField nameField;
    private JTextField policyTextField;
    private JComboBox<CreateDialog.ObjectTypeItem> typeBox;

    public CreatePolicyDialog(Frame owner, ClientModel model) {
        super(owner, "Create Policy", model);
        this.createGUI();
    }

    private void createGUI() {
        final CreatePolicyDialog thisDialog = this;
        this.unfiledButton = new JRadioButton("create unfiled");
        this.unfiledButton.setSelected(false);
        this.currentPathButton = new JRadioButton("create in the current folder: " + this.getClientModel().getCurrentFolder().getPath());
        this.currentPathButton.setSelected(true);
        ButtonGroup filedGroup = new ButtonGroup();
        filedGroup.add(this.unfiledButton);
        filedGroup.add(this.currentPathButton);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(this.unfiledButton);
        buttonPanel.add(this.currentPathButton);
        this.createRow("", buttonPanel, 0);
        this.nameField = new JTextField(60);
        this.createRow("Name:", this.nameField, 1);
        CreateDialog.ObjectTypeItem[] types = this.getTypes(BaseTypeId.CMIS_POLICY.value());
        if (types.length == 0) {
            JOptionPane.showMessageDialog(this, "No creatable type!", "Creatable Types", 0);
            thisDialog.dispose();
            return;
        }
        this.typeBox = new JComboBox<CreateDialog.ObjectTypeItem>(types);
        this.typeBox.setSelectedIndex(0);
        this.typeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ObjectType type = ((CreateDialog.ObjectTypeItem)CreatePolicyDialog.this.typeBox.getSelectedItem()).getObjectType();
                CreatePolicyDialog.this.updateMandatoryOrOnCreateFields((TypeDefinition)type);
            }
        });
        CreateDialog.ObjectTypeItem type = (CreateDialog.ObjectTypeItem)this.typeBox.getSelectedItem();
        this.updateMandatoryOrOnCreateFields((TypeDefinition)type.getObjectType());
        this.createRow("Type:", this.typeBox, 2);
        this.policyTextField = new JTextField(60);
        this.createRow("Policy Text:", this.policyTextField, 3);
        JButton createButton = new JButton("Create Policy", new NewPolicyIcon(11, 11));
        createButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                String name = CreatePolicyDialog.this.nameField.getText();
                String policyText = CreatePolicyDialog.this.policyTextField.getText();
                ObjectType type = ((CreateDialog.ObjectTypeItem)CreatePolicyDialog.this.typeBox.getSelectedItem()).getObjectType();
                try {
                    CreatePolicyDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    ObjectId objectId = CreatePolicyDialog.this.getClientModel().createPolicy(name, type.getId(), policyText, CreatePolicyDialog.this.getMandatoryOrOnCreatePropertyValues((TypeDefinition)type), CreatePolicyDialog.this.unfiledButton.isSelected());
                    if (objectId != null) {
                        CreatePolicyDialog.this.getClientModel().loadObject(objectId.getId());
                    }
                    thisDialog.setVisible(false);
                    thisDialog.dispose();
                }
                catch (Exception e) {
                    ClientHelper.showError(null, e);
                }
                finally {
                    CreatePolicyDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        CreatePolicyDialog.this.getClientModel().reloadFolder();
                    }
                    catch (Exception e) {
                        ClientHelper.showError(null, e);
                    }
                }
            }
        });
        this.createActionRow("", createButton, 4);
        this.getRootPane().setDefaultButton(createButton);
        this.showDialog();
    }
}

