/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.icons.NewRelationshipIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.CreateDialog;

public class CreateRelationshipDialog
extends CreateDialog {
    private static final long serialVersionUID = 1L;
    private JTextField nameField;
    private JComboBox<CreateDialog.ObjectTypeItem> typeBox;
    private JTextField sourceIdField;
    private JTextField targetIdField;

    public CreateRelationshipDialog(Frame owner, ClientModel model) {
        super(owner, "Create Relationship", model);
        this.createGUI();
    }

    private void createGUI() {
        final CreateRelationshipDialog thisDialog = this;
        this.nameField = new JTextField(60);
        this.createRow("Name:", this.nameField, 0);
        CreateDialog.ObjectTypeItem[] types = this.getTypes(BaseTypeId.CMIS_RELATIONSHIP.value());
        if (types.length == 0) {
            JOptionPane.showMessageDialog(this, "No creatable type!", "Creatable Types", 0);
            thisDialog.dispose();
            return;
        }
        this.typeBox = new JComboBox<CreateDialog.ObjectTypeItem>(types);
        this.typeBox.setSelectedIndex(0);
        this.typeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ObjectType type = ((CreateDialog.ObjectTypeItem)CreateRelationshipDialog.this.typeBox.getSelectedItem()).getObjectType();
                CreateRelationshipDialog.this.updateMandatoryOrOnCreateFields((TypeDefinition)type);
            }
        });
        CreateDialog.ObjectTypeItem type = (CreateDialog.ObjectTypeItem)this.typeBox.getSelectedItem();
        this.updateMandatoryOrOnCreateFields((TypeDefinition)type.getObjectType());
        this.createRow("Type:", this.typeBox, 1);
        this.sourceIdField = new JTextField(60);
        if (this.getClientModel().getCurrentObject() != null) {
            this.sourceIdField.setText(this.getClientModel().getCurrentObject().getId());
        }
        this.createRow("Source Id:", this.sourceIdField, 2);
        this.targetIdField = new JTextField(60);
        this.createRow("Target Id:", this.targetIdField, 3);
        JButton createButton = new JButton("Create Relationship", new NewRelationshipIcon(11, 11));
        createButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                String name = CreateRelationshipDialog.this.nameField.getText();
                ObjectType type = ((CreateDialog.ObjectTypeItem)CreateRelationshipDialog.this.typeBox.getSelectedItem()).getObjectType();
                String sourceId = CreateRelationshipDialog.this.sourceIdField.getText();
                String targetId = CreateRelationshipDialog.this.targetIdField.getText();
                try {
                    CreateRelationshipDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    ObjectId objectId = CreateRelationshipDialog.this.getClientModel().createRelationship(name, type.getId(), sourceId, targetId, CreateRelationshipDialog.this.getMandatoryOrOnCreatePropertyValues((TypeDefinition)type));
                    if (objectId != null) {
                        CreateRelationshipDialog.this.getClientModel().loadObject(objectId.getId());
                    }
                    thisDialog.setVisible(false);
                    thisDialog.dispose();
                }
                catch (Exception e) {
                    ClientHelper.showError(null, e);
                }
                finally {
                    CreateRelationshipDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        CreateRelationshipDialog.this.getClientModel().reloadFolder();
                    }
                    catch (Exception e) {
                        ClientHelper.showError(null, e);
                    }
                }
            }
        });
        this.createActionRow("", createButton, 4);
        this.getRootPane().setDefaultButton(createButton);
        this.showDialog();
    }
}

