/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.chemistry.opencmis.client.api.CmisEndpointDocumentReader;
import org.apache.chemistry.opencmis.client.runtime.CmisEndpointDocumentReaderImpl;
import org.apache.chemistry.opencmis.commons.endpoints.CmisAuthentication;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpoint;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpointsDocument;
import org.apache.chemistry.opencmis.commons.impl.endpoints.CmisEndpointsDocumentHelper;
import org.apache.chemistry.opencmis.commons.impl.endpoints.CmisEndpointsDocumentImpl;
import org.apache.chemistry.opencmis.workbench.AbstractLoginTab;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.LoginDialog;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;

public class DiscoverLoginTab
extends AbstractLoginTab {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Preference", "CMIS", "Binding", "Authentication", "Details"};
    private static final int[] COLUMN_WIDTHS = new int[]{30, 40, 70, 100, 440};
    private static final int DETAILS_COLUMN = 4;
    public static final String SYSPROP_URL = "cmis.workbench.url";
    private JTextField urlField;
    private CmisAuthenticationTable authTable;
    private CmisEndpointDocumentReader reader = new CmisEndpointDocumentReaderImpl();

    public DiscoverLoginTab() {
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        JPanel urlPanel = new JPanel(new BorderLayout());
        urlPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        urlPanel.add((Component)new JLabel("Endpoint Document URL:"), "Before");
        this.urlField = new JTextField();
        urlPanel.add((Component)this.urlField, "Center");
        JButton loadButton = new JButton("Load");
        urlPanel.add((Component)loadButton, "After");
        this.add((Component)urlPanel, "First");
        this.authTable = new CmisAuthenticationTable();
        this.add((Component)new JScrollPane(this.authTable), "Center");
        ActionListener loadActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DiscoverLoginTab.this.setCursor(Cursor.getPredefinedCursor(3));
                    CmisEndpointsDocument doc = DiscoverLoginTab.this.reader.read(new URL(DiscoverLoginTab.this.urlField.getText()));
                    ((CmisAuthenticationModel)DiscoverLoginTab.this.authTable.getModel()).setCmisEndpointDocument(doc);
                    if (DiscoverLoginTab.this.authTable.getModel().getRowCount() > 0) {
                        DiscoverLoginTab.this.authTable.setRowSelectionInterval(0, 0);
                    }
                }
                catch (Exception ex) {
                    ClientHelper.showError(DiscoverLoginTab.this, ex);
                }
                finally {
                    DiscoverLoginTab.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        this.urlField.addActionListener(loadActionListener);
        loadButton.addActionListener(loadActionListener);
    }

    @Override
    public String getTabTitle() {
        return "Discover";
    }

    @Override
    public boolean transferSessionParametersToExpertTab() {
        return true;
    }

    @Override
    public Map<String, String> getSessionParameters() {
        int row = this.authTable.getSelectedRow();
        if (row < 0) {
            return Collections.emptyMap();
        }
        CmisAuthentication auth = (CmisAuthentication)this.authTable.getValueAt(row, this.authTable.convertColumnIndexToView(4));
        Map parameters = this.reader.pepareSessionParameters(auth);
        if ("basic".equals(auth.getType()) || "usernameToken".equals(auth.getType()) || "ntlm".equals(auth.getType())) {
            parameters.put("org.apache.chemistry.opencmis.user", "");
            parameters.put("org.apache.chemistry.opencmis.password", "");
        } else if ("oauth".equals(auth.getType())) {
            parameters.put("org.apache.chemistry.opencmis.oauth.tokenEndpoint", "");
            parameters.put("org.apache.chemistry.opencmis.oauth.clientId", "");
            parameters.put("org.apache.chemistry.opencmis.oauth.clientSecret", "");
            parameters.put("org.apache.chemistry.opencmis.oauth.code", "");
        } else if (!"none".equals(auth.getType()) && !parameters.containsKey("org.apache.chemistry.opencmis.binding.auth.classname")) {
            parameters.put("org.apache.chemistry.opencmis.binding.auth.classname", "");
        }
        return parameters;
    }

    static class CmisAuthenticationRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int height = (int)this.getPreferredSize().getHeight();
            if (height > this.getFontMetrics(this.getFont()).getHeight() + this.getInsets().bottom + this.getInsets().top && table.getRowHeight(row) != height) {
                table.setRowHeight(row, height);
            }
            return comp;
        }

        @Override
        public void setValue(Object value) {
            StringBuilder text = new StringBuilder(128);
            if (value instanceof CmisAuthentication) {
                CmisAuthentication auth = (CmisAuthentication)value;
                text.append("<html>");
                if (auth.getDisplayName() != null) {
                    text.append("<b>");
                    text.append(auth.getDisplayName());
                    text.append("</b>");
                } else {
                    text.append("???");
                }
                text.append("<br>");
                if (auth.getEndpoint().getDisplayName() != null) {
                    text.append(auth.getEndpoint().getDisplayName());
                } else {
                    text.append("???");
                }
                if (auth.getEndpoint().getUrl() != null) {
                    text.append("<br>Endpoint URL: ");
                    text.append(auth.getEndpoint().getUrl());
                } else if (auth.getEndpoint().getRepositoryServiceWdsl() != null) {
                    text.append("<br>Endpoint WSDL: ");
                    text.append(auth.getEndpoint().getRepositoryServiceWdsl());
                }
                if (auth.getDocumentationUrl() != null) {
                    text.append("<br>Documentation URL: ");
                    text.append(auth.getDocumentationUrl());
                }
            }
            this.setText(text.toString());
        }
    }

    static class CmisAuthenticationModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private CmisEndpointsDocument endpointDocument = new CmisEndpointsDocumentImpl();
        private List<CmisAuthentication> authentications = Collections.emptyList();

        public CmisEndpointsDocument getCmisEndpointsDocument() {
            return this.endpointDocument;
        }

        public void setCmisEndpointDocument(CmisEndpointsDocument endpointDocument) {
            this.endpointDocument = endpointDocument;
            this.authentications = endpointDocument.getAuthenticationsSortedByPreference();
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return this.authentications.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CmisAuthentication auth = this.authentications.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return auth.getPreference();
                }
                case 1: {
                    return auth.getEndpoint().getCmisVersion() == null ? "?" : auth.getEndpoint().getCmisVersion();
                }
                case 2: {
                    return auth.getEndpoint().getBinding() == null ? "?" : auth.getEndpoint().getBinding();
                }
                case 3: {
                    return auth.getType() == null ? "?" : auth.getType();
                }
                case 4: {
                    return auth;
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 4: {
                    return CmisAuthentication.class;
                }
            }
            return String.class;
        }
    }

    static class CmisAuthenticationTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public CmisAuthenticationTable() {
            this.setModel(new CmisAuthenticationModel());
            this.setSelectionMode(0);
            this.setAutoResizeMode(0);
            this.setAutoCreateRowSorter(true);
            this.setDefaultRenderer(CmisAuthentication.class, new CmisAuthenticationRenderer());
            for (int i = 0; i < COLUMN_WIDTHS.length; ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setPreferredWidth(WorkbenchScale.scaleInt(COLUMN_WIDTHS[i]));
            }
            JPopupMenu popup = new JPopupMenu();
            JMenuItem expertLoginMenuItem = new JMenuItem("Transfer to expert login tab");
            popup.add(expertLoginMenuItem);
            expertLoginMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((LoginDialog)SwingUtilities.getRoot(CmisAuthenticationTable.this)).switchToExpertTab();
                }
            });
            popup.addSeparator();
            JMenuItem allEnpointsMenuItem = new JMenuItem("Copy all endpoints to clipboard");
            popup.add(allEnpointsMenuItem);
            allEnpointsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String json = CmisEndpointsDocumentHelper.write((CmisEndpointsDocument)((CmisAuthenticationModel)CmisAuthenticationTable.this.getModel()).getCmisEndpointsDocument());
                    CmisAuthenticationTable.this.copyTableToClipboard(json);
                }
            });
            JMenuItem selectedEnpointsMenuItem = new JMenuItem("Copy selected endpoint to clipboard");
            popup.add(selectedEnpointsMenuItem);
            selectedEnpointsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = CmisAuthenticationTable.this.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    CmisAuthentication auth = (CmisAuthentication)CmisAuthenticationTable.this.getValueAt(row, CmisAuthenticationTable.this.convertColumnIndexToView(4));
                    if (auth != null) {
                        String json = CmisEndpointsDocumentHelper.write((CmisEndpoint)auth.getEndpoint());
                        CmisAuthenticationTable.this.copyTableToClipboard(json);
                    }
                }
            });
            JMenuItem selectedAuthMenuItem = new JMenuItem("Copy selected authentication to clipboard");
            popup.add(selectedAuthMenuItem);
            selectedAuthMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = CmisAuthenticationTable.this.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    CmisAuthentication auth = (CmisAuthentication)CmisAuthenticationTable.this.getValueAt(row, CmisAuthenticationTable.this.convertColumnIndexToView(4));
                    if (auth != null) {
                        String json = CmisEndpointsDocumentHelper.write((CmisAuthentication)auth);
                        CmisAuthenticationTable.this.copyTableToClipboard(json);
                    }
                }
            });
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                popup.addSeparator();
                JMenuItem docMenuItem = new JMenuItem("Open documentation URL");
                popup.add(docMenuItem);
                docMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int row = CmisAuthenticationTable.this.getSelectedRow();
                        if (row < 0) {
                            return;
                        }
                        CmisAuthentication auth = (CmisAuthentication)CmisAuthenticationTable.this.getValueAt(row, CmisAuthenticationTable.this.convertColumnIndexToView(4));
                        if (auth != null && auth.getDocumentationUrl() != null) {
                            try {
                                Desktop.getDesktop().browse(new URI(auth.getDocumentationUrl()));
                            }
                            catch (Exception ex) {
                                ClientHelper.showError(CmisAuthenticationTable.this, ex);
                            }
                        }
                    }
                });
            }
            this.setComponentPopupMenu(popup);
        }

        private void copyTableToClipboard(String s) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection transferable = new StringSelection(s);
            clipboard.setContents(transferable, null);
        }
    }
}

