/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;

public class ExceptionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final Exception exception;

    public ExceptionDialog(Frame owner, Exception exception) {
        super(owner, "Exception", true);
        this.exception = exception;
        this.createGUI();
    }

    private void createGUI() {
        String errorContent;
        this.setMinimumSize(new Dimension(WorkbenchScale.scaleInt(600), WorkbenchScale.scaleInt(150)));
        this.setPreferredSize(new Dimension(WorkbenchScale.scaleInt(600), WorkbenchScale.scaleInt(150)));
        this.setLayout(new BorderLayout());
        String exceptionName = this.exception instanceof CmisBaseException ? "CMIS Exception: <em>" + ((CmisBaseException)this.exception).getExceptionName() + "</em>" : "Exception: <em>" + this.exception.getClass().getSimpleName() + "</em>";
        StringBuilder exceptionText = new StringBuilder(1024);
        exceptionText.append("<h2><font color=\"red\">" + exceptionName + "</font><br>");
        ClientHelper.encodeHtml(exceptionText, this.exception.getMessage());
        exceptionText.append("</h2>");
        if (this.exception.getCause() != null) {
            exceptionText.append("<h3><font color=\"red\">Cause: <em>" + this.exception.getCause().getClass().getSimpleName() + "</em></font><br>");
            ClientHelper.encodeHtml(exceptionText, this.exception.getCause().getMessage());
            exceptionText.append("</h3>");
        }
        if (this.exception instanceof CmisBaseException && (errorContent = ((CmisBaseException)this.exception).getErrorContent()) != null && errorContent.length() > 0) {
            exceptionText.append("<hr><br><b>Error Content:</b><br>");
            ClientHelper.encodeHtml(exceptionText, errorContent);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, WorkbenchScale.scaleInt(250)));
        }
        JPanel exceptionPanel = new JPanel();
        exceptionPanel.setLayout(new BoxLayout(exceptionPanel, 3));
        exceptionPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.add((Component)exceptionPanel, "Center");
        JEditorPane exceptionTextPane = new JEditorPane("text/html", exceptionText.toString());
        exceptionTextPane.setEditable(false);
        exceptionTextPane.setCaretPosition(0);
        exceptionPanel.add(new JScrollPane(exceptionTextPane, 20, 30));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        buttonPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)buttonPanel, "Last");
        JButton closeButton = new JButton("Close");
        closeButton.setPreferredSize(new Dimension(Short.MAX_VALUE, WorkbenchScale.scaleInt(30)));
        closeButton.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        closeButton.setAlignmentX(0.5f);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        this.getRootPane().setDefaultButton(closeButton);
        ClientHelper.installEscapeBinding(this, this.getRootPane(), true);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }
}

