/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.chemistry.opencmis.client.SessionParameterMap;
import org.apache.chemistry.opencmis.workbench.AbstractLoginTab;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;

public class ExpertLoginTab
extends AbstractLoginTab {
    private static final long serialVersionUID = 1L;
    public static final String SYSPROP_CONFIGS = "cmis.workbench.configs";
    private static final String CONFIGS_FOLDER = "/configs/";
    private static final String CONFIGS_LIBRARY = "config-library.properties";
    private JComboBox<ClientHelper.FileEntry> configs;
    private JTextArea sessionParameterTextArea;
    private List<ClientHelper.FileEntry> sessionConfigurations;

    public ExpertLoginTab() {
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        URI propFile = null;
        String externalConfigs = System.getProperty(SYSPROP_CONFIGS);
        propFile = externalConfigs == null ? ClientHelper.getClasspathURI("/configs/config-library.properties") : new File(externalConfigs).toURI();
        this.sessionConfigurations = ClientHelper.readFileProperties(propFile);
        this.configs = new JComboBox();
        this.configs.setMaximumRowCount(20);
        this.configs.addItem(new ClientHelper.FileEntry("", null));
        if (this.sessionConfigurations != null) {
            for (ClientHelper.FileEntry fe : this.sessionConfigurations) {
                this.configs.addItem(fe);
            }
        }
        this.configs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ClientHelper.FileEntry fe = (ClientHelper.FileEntry)e.getItem();
                    ExpertLoginTab.this.sessionParameterTextArea.setText(ClientHelper.readFileAndRemoveHeader(fe.getFile()));
                    ExpertLoginTab.this.sessionParameterTextArea.setCaretPosition(0);
                }
            }
        });
        this.add(this.configs, "First");
        this.sessionParameterTextArea = new JTextArea();
        this.sessionParameterTextArea.setFont(new Font("Monospaced", 0, this.sessionParameterTextArea.getFont().getSize()));
        this.add((Component)new JScrollPane(this.sessionParameterTextArea), "Center");
    }

    public void setSessionParameters(Map<String, String> parameters) {
        this.configs.setSelectedIndex(0);
        StringBuilder sb = new StringBuilder(128);
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            sb.append(parameter.getKey());
            sb.append('=');
            sb.append(parameter.getValue());
            sb.append('\n');
        }
        this.sessionParameterTextArea.setText(sb.toString());
        this.sessionParameterTextArea.setCaretPosition(0);
    }

    @Override
    public String getTabTitle() {
        return "Expert";
    }

    @Override
    public Map<String, String> getSessionParameters() {
        SessionParameterMap result = new SessionParameterMap();
        result.parse(this.sessionParameterTextArea.getText());
        return result;
    }

    @Override
    public boolean transferSessionParametersToExpertTab() {
        return false;
    }
}

